/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMFactory
 * @model kind="package"
 * @generated
 */
public interface IOMPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME= "iom";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI= "http://www.pst.ifi.lmu.de/projekte/mdd4soa/iom";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX= "iom";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	IOMPackage eINSTANCE= de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceElementImpl <em>Service Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceElementImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceElement()
	 * @generated
	 */
	int SERVICE_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ELEMENT__NAME = 0;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ELEMENT__PARENT = 1;

	/**
	 * The number of structural features of the '<em>Service Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ELEMENT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PartnerPointImpl <em>Partner Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PartnerPointImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getPartnerPoint()
	 * @generated
	 */
	int PARTNER_POINT = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTNER_POINT__NAME = 0;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTNER_POINT__INTERFACE = 1;

	/**
	 * The number of structural features of the '<em>Partner Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTNER_POINT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ExpressionImpl
	 * <em>Expression</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ExpressionImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getExpression()
	 * @generated
	 */
	int EXPRESSION= 27;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__TYPE= 0;

	/**
	 * The number of structural features of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FEATURE_COUNT= 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.RightHandSideExpressionImpl <em>Right Hand Side Expression</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.RightHandSideExpressionImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getRightHandSideExpression()
	 * @generated
	 */
	int RIGHT_HAND_SIDE_EXPRESSION= 35;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RIGHT_HAND_SIDE_EXPRESSION__TYPE= EXPRESSION__TYPE;

	/**
	 * The number of structural features of the '<em>Right Hand Side Expression</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT= EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LeftHandSideExpressionImpl <em>Left Hand Side Expression</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LeftHandSideExpressionImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getLeftHandSideExpression()
	 * @generated
	 */
	int LEFT_HAND_SIDE_EXPRESSION= 34;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE_EXPRESSION__TYPE= RIGHT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The number of structural features of the '<em>Left Hand Side Expression</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.VariableImpl <em>Variable</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.VariableImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getVariable()
	 * @generated
	 */
	int VARIABLE= 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__TYPE= LEFT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__NAME= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>ServiceActivity</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__SCOPE= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variable</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE_FEATURE_COUNT= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationImpl <em>Service Operation</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceOperation()
	 * @generated
	 */
	int SERVICE_OPERATION= 3;

	/**
	 * The feature id for the '<em><b>Used In</b></em>' reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION__USED_IN= 0;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION__PARAMETERS = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION__NAME= 2;

	/**
	 * The number of structural features of the '<em>Service Operation</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION_FEATURE_COUNT= 3;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SimpleElementImpl <em>Simple Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SimpleElementImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getSimpleElement()
	 * @generated
	 */
	int SIMPLE_ELEMENT = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_ELEMENT__NAME = SERVICE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_ELEMENT__PARENT = SERVICE_ELEMENT__PARENT;

	/**
	 * The number of structural features of the '<em>Simple Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_ELEMENT_FEATURE_COUNT = SERVICE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompositeElementImpl <em>Composite Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompositeElementImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getCompositeElement()
	 * @generated
	 */
	int COMPOSITE_ELEMENT = 23;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ELEMENT__NAME = SERVICE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ELEMENT__PARENT = SERVICE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ELEMENT__CHILDREN = SERVICE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Composite Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ELEMENT_FEATURE_COUNT = SERVICE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceActivityImpl <em>Service Activity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceActivityImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceActivity()
	 * @generated
	 */
	int SERVICE_ACTIVITY = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__NAME = COMPOSITE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__PARENT = COMPOSITE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__CHILDREN = COMPOSITE_ELEMENT__CHILDREN;

	/**
	 * The feature id for the '<em><b>Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__VARIABLES = COMPOSITE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Handlers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__HANDLERS = COMPOSITE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Interrupting Receives</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__INTERRUPTING_RECEIVES = COMPOSITE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Service Activity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY_FEATURE_COUNT = COMPOSITE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.HandlerImpl <em>Handler</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.HandlerImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getHandler()
	 * @generated
	 */
	int HANDLER= 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HANDLER__NAME= COMPOSITE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HANDLER__PARENT= COMPOSITE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HANDLER__CHILDREN= COMPOSITE_ELEMENT__CHILDREN;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HANDLER__PARAMETER= COMPOSITE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Handler</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HANDLER_FEATURE_COUNT= COMPOSITE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInteractionImpl <em>Service Interaction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInteractionImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceInteraction()
	 * @generated
	 */
	int SERVICE_INTERACTION = 21;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__NAME = SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__PARENT = SIMPLE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__OPERATION = SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__RCV_PARAMETERS = SIMPLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__SND_PARAMETERS = SIMPLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__PARTNER = SIMPLE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Service Interaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION_FEATURE_COUNT = SIMPLE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendImpl <em>Send</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getSend()
	 * @generated
	 */
	int SEND= 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__NAME= SERVICE_INTERACTION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__PARENT= SERVICE_INTERACTION__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__OPERATION= SERVICE_INTERACTION__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND__RCV_PARAMETERS = SERVICE_INTERACTION__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND__SND_PARAMETERS = SERVICE_INTERACTION__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND__PARTNER = SERVICE_INTERACTION__PARTNER;

	/**
	 * The number of structural features of the '<em>Send</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_FEATURE_COUNT= SERVICE_INTERACTION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveImpl <em>Receive</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getReceive()
	 * @generated
	 */
	int RECEIVE= 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__NAME= SERVICE_INTERACTION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__PARENT= SERVICE_INTERACTION__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__OPERATION= SERVICE_INTERACTION__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE__RCV_PARAMETERS = SERVICE_INTERACTION__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE__SND_PARAMETERS = SERVICE_INTERACTION__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE__PARTNER = SERVICE_INTERACTION__PARTNER;

	/**
	 * The feature id for the '<em><b>Interrupts</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE__INTERRUPTS = SERVICE_INTERACTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Receive</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_FEATURE_COUNT= SERVICE_INTERACTION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendAndReceiveImpl <em>Send And Receive</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendAndReceiveImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getSendAndReceive()
	 * @generated
	 */
	int SEND_AND_RECEIVE= 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__NAME= SEND__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__PARENT= SEND__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__OPERATION= SEND__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__RCV_PARAMETERS = SEND__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__SND_PARAMETERS = SEND__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__PARTNER = SEND__PARTNER;

	/**
	 * The feature id for the '<em><b>Interrupts</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__INTERRUPTS = SEND_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Send And Receive</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE_FEATURE_COUNT= SEND_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveAndReplyImpl <em>Receive And Reply</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveAndReplyImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getReceiveAndReply()
	 * @generated
	 */
	int RECEIVE_AND_REPLY = 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_AND_REPLY__NAME = RECEIVE__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_AND_REPLY__PARENT = RECEIVE__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_AND_REPLY__OPERATION = RECEIVE__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_AND_REPLY__RCV_PARAMETERS = RECEIVE__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_AND_REPLY__SND_PARAMETERS = RECEIVE__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_AND_REPLY__PARTNER = RECEIVE__PARTNER;

	/**
	 * The feature id for the '<em><b>Interrupts</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_AND_REPLY__INTERRUPTS = RECEIVE__INTERRUPTS;

	/**
	 * The number of structural features of the '<em>Receive And Reply</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_AND_REPLY_FEATURE_COUNT = RECEIVE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensateAllImpl <em>Compensate All</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensateAllImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getCompensateAll()
	 * @generated
	 */
	int COMPENSATE_ALL = 11;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATE_ALL__NAME = SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATE_ALL__PARENT = SIMPLE_ELEMENT__PARENT;

	/**
	 * The number of structural features of the '<em>Compensate All</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATE_ALL_FEATURE_COUNT = SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensateImpl <em>Compensate</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensateImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getCompensate()
	 * @generated
	 */
	int COMPENSATE = 12;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATE__NAME = SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATE__PARENT = SIMPLE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Service Activity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATE__SERVICE_ACTIVITY = SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Compensate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATE_FEATURE_COUNT = SIMPLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ExceptionHandlerImpl <em>Exception Handler</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ExceptionHandlerImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getExceptionHandler()
	 * @generated
	 */
	int EXCEPTION_HANDLER= 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__NAME= HANDLER__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__PARENT= HANDLER__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__CHILDREN= HANDLER__CHILDREN;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__PARAMETER= HANDLER__PARAMETER;

	/**
	 * The feature id for the '<em><b>Fault Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__FAULT_NAME = HANDLER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Exception Handler</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER_FEATURE_COUNT= HANDLER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensationHandlerImpl <em>Compensation Handler</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensationHandlerImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getCompensationHandler()
	 * @generated
	 */
	int COMPENSATION_HANDLER= 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER__NAME= HANDLER__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER__PARENT= HANDLER__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER__CHILDREN= HANDLER__CHILDREN;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER__PARAMETER= HANDLER__PARAMETER;

	/**
	 * The number of structural features of the '<em>Compensation Handler</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER_FEATURE_COUNT= HANDLER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PathBasedPartitionImpl <em>Path Based Partition</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PathBasedPartitionImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getPathBasedPartition()
	 * @generated
	 */
	int PATH_BASED_PARTITION= 15;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION__NAME= COMPOSITE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION__PARENT= COMPOSITE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION__CHILDREN= COMPOSITE_ELEMENT__CHILDREN;

	/**
	 * The feature id for the '<em><b>Paths</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION__PATHS= COMPOSITE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Path Based Partition</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION_FEATURE_COUNT= COMPOSITE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PathImpl <em>Path</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PathImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getPath()
	 * @generated
	 */
	int PATH= 16;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH__NAME= COMPOSITE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH__PARENT= COMPOSITE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH__CHILDREN= COMPOSITE_ELEMENT__CHILDREN;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH__CONDITION= COMPOSITE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Path</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH_FEATURE_COUNT= COMPOSITE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DecisionImpl <em>Decision</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DecisionImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getDecision()
	 * @generated
	 */
	int DECISION = 17;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECISION__NAME = PATH_BASED_PARTITION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECISION__PARENT = PATH_BASED_PARTITION__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECISION__CHILDREN = PATH_BASED_PARTITION__CHILDREN;

	/**
	 * The feature id for the '<em><b>Paths</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECISION__PATHS = PATH_BASED_PARTITION__PATHS;

	/**
	 * The number of structural features of the '<em>Decision</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECISION_FEATURE_COUNT = PATH_BASED_PARTITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ForkImpl <em>Fork</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ForkImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getFork()
	 * @generated
	 */
	int FORK = 18;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORK__NAME = PATH_BASED_PARTITION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORK__PARENT = PATH_BASED_PARTITION__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORK__CHILDREN = PATH_BASED_PARTITION__CHILDREN;

	/**
	 * The feature id for the '<em><b>Paths</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORK__PATHS = PATH_BASED_PARTITION__PATHS;

	/**
	 * The number of structural features of the '<em>Fork</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORK_FEATURE_COUNT = PATH_BASED_PARTITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LoopImpl <em>Loop</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LoopImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getLoop()
	 * @generated
	 */
	int LOOP= 19;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP__NAME= PATH_BASED_PARTITION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP__PARENT= PATH_BASED_PARTITION__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP__CHILDREN= PATH_BASED_PARTITION__CHILDREN;

	/**
	 * The feature id for the '<em><b>Paths</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP__PATHS= PATH_BASED_PARTITION__PATHS;

	/**
	 * The feature id for the '<em><b>Ll Condition</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP__LL_CONDITION= PATH_BASED_PARTITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Loop</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP_FEATURE_COUNT= PATH_BASED_PARTITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.EventHandlerImpl
	 * <em>Event Handler</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.EventHandlerImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getEventHandler()
	 * @generated
	 */
	int EVENT_HANDLER= 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER__NAME= HANDLER__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER__PARENT= HANDLER__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER__CHILDREN= HANDLER__CHILDREN;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER__PARAMETER= HANDLER__PARAMETER;

	/**
	 * The number of structural features of the '<em>Event Handler</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER_FEATURE_COUNT= HANDLER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ThrowImpl <em>Throw</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ThrowImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getThrow()
	 * @generated
	 */
	int THROW= 22;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int THROW__NAME= SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int THROW__PARENT= SIMPLE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Fault</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int THROW__FAULT= SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Fault Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROW__FAULT_NAME = SIMPLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Throw</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int THROW_FEATURE_COUNT= SIMPLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PickImpl <em>Pick</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PickImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getPick()
	 * @generated
	 */
	int PICK= 24;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PICK__NAME= PATH_BASED_PARTITION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PICK__PARENT= PATH_BASED_PARTITION__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICK__CHILDREN= PATH_BASED_PARTITION__CHILDREN;

	/**
	 * The feature id for the '<em><b>Paths</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICK__PATHS= PATH_BASED_PARTITION__PATHS;

	/**
	 * The number of structural features of the '<em>Pick</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PICK_FEATURE_COUNT= PATH_BASED_PARTITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReplyImpl <em>Reply</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReplyImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getReply()
	 * @generated
	 */
	int REPLY= 25;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__NAME= SERVICE_INTERACTION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__PARENT= SERVICE_INTERACTION__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__OPERATION= SERVICE_INTERACTION__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPLY__RCV_PARAMETERS = SERVICE_INTERACTION__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPLY__SND_PARAMETERS = SERVICE_INTERACTION__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPLY__PARTNER = SERVICE_INTERACTION__PARTNER;

	/**
	 * The number of structural features of the '<em>Reply</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY_FEATURE_COUNT= SERVICE_INTERACTION_FEATURE_COUNT + 0;


	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DataHandlingImpl
	 * <em>Data Handling</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DataHandlingImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getDataHandling()
	 * @generated
	 */
	int DATA_HANDLING= 26;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_HANDLING__NAME= SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_HANDLING__PARENT= SIMPLE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Statements</b></em>' reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_HANDLING__STATEMENTS= SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Data Handling</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_HANDLING_FEATURE_COUNT= SIMPLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.FieldImpl <em>Field</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.FieldImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getField()
	 * @generated
	 */
	int FIELD= 28;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FIELD__TYPE= LEFT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FIELD__PARENT= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FIELD__NAME= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Field</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FIELD_FEATURE_COUNT= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.StatementImpl <em>Statement</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.StatementImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getStatement()
	 * @generated
	 */
	int STATEMENT= 31;

	/**
	 * The number of structural features of the '<em>Statement</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STATEMENT_FEATURE_COUNT= 0;

	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.AssignmentImpl
	 * <em>Assignment</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.AssignmentImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getAssignment()
	 * @generated
	 */
	int ASSIGNMENT= 29;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__TARGET= STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__SOURCE= STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_FEATURE_COUNT= STATEMENT_FEATURE_COUNT + 2;


	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DeclarationImpl
	 * <em>Declaration</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DeclarationImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getDeclaration()
	 * @generated
	 */
	int DECLARATION= 30;

	/**
	 * The feature id for the '<em><b>Declared Var</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DECLARATION__DECLARED_VAR= STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Declaration</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_FEATURE_COUNT= STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LiteralImpl <em>Literal</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LiteralImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getLiteral()
	 * @generated
	 */
	int LITERAL= 32;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL__TYPE= RIGHT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL__VALUE= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Literal</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_FEATURE_COUNT= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OperationImpl <em>Operation</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OperationImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getOperation()
	 * @generated
	 */
	int OPERATION= 33;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION__TYPE= RIGHT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Operands</b></em>' reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION__OPERANDS= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operation Type</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION__OPERATION_TYPE= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Operation</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_FEATURE_COUNT= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInterfaceImpl <em>Service Interface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInterfaceImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceInterface()
	 * @generated
	 */
	int SERVICE_INTERFACE = 36;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERFACE__NAME = TypePackage.TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERFACE__PACKAGE = TypePackage.TYPE__PACKAGE;

	/**
	 * The feature id for the '<em><b>Used</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERFACE__USED = TypePackage.TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Implemented</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERFACE__IMPLEMENTED = TypePackage.TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Service Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERFACE_FEATURE_COUNT = TypePackage.TYPE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServicePointImpl <em>Service Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServicePointImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServicePoint()
	 * @generated
	 */
	int SERVICE_POINT = 37;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_POINT__NAME = PARTNER_POINT__NAME;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_POINT__INTERFACE = PARTNER_POINT__INTERFACE;

	/**
	 * The number of structural features of the '<em>Service Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_POINT_FEATURE_COUNT = PARTNER_POINT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.RequestPointImpl <em>Request Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.RequestPointImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getRequestPoint()
	 * @generated
	 */
	int REQUEST_POINT = 38;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_POINT__NAME = PARTNER_POINT__NAME;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_POINT__INTERFACE = PARTNER_POINT__INTERFACE;

	/**
	 * The number of structural features of the '<em>Request Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_POINT_FEATURE_COUNT = PARTNER_POINT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationParameterImpl <em>Service Operation Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationParameterImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceOperationParameter()
	 * @generated
	 */
	int SERVICE_OPERATION_PARAMETER = 39;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION_PARAMETER__NAME = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION_PARAMETER__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION_PARAMETER__OPERATION = 2;

	/**
	 * The number of structural features of the '<em>Service Operation Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION_PARAMETER_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.InParameterImpl <em>In Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.InParameterImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getInParameter()
	 * @generated
	 */
	int IN_PARAMETER = 40;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__NAME = SERVICE_OPERATION_PARAMETER__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__TYPE = SERVICE_OPERATION_PARAMETER__TYPE;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__OPERATION = SERVICE_OPERATION_PARAMETER__OPERATION;

	/**
	 * The number of structural features of the '<em>In Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER_FEATURE_COUNT = SERVICE_OPERATION_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OutParameterImpl <em>Out Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OutParameterImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getOutParameter()
	 * @generated
	 */
	int OUT_PARAMETER = 41;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__NAME = SERVICE_OPERATION_PARAMETER__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__TYPE = SERVICE_OPERATION_PARAMETER__TYPE;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__OPERATION = SERVICE_OPERATION_PARAMETER__OPERATION;

	/**
	 * The number of structural features of the '<em>Out Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER_FEATURE_COUNT = SERVICE_OPERATION_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.InteractionParameterImpl <em>Interaction Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.InteractionParameterImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getInteractionParameter()
	 * @generated
	 */
	int INTERACTION_PARAMETER = 42;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION_PARAMETER__OPERATION_PARAMETER = 0;

	/**
	 * The number of structural features of the '<em>Interaction Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERACTION_PARAMETER_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveParameterImpl <em>Receive Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveParameterImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getReceiveParameter()
	 * @generated
	 */
	int RECEIVE_PARAMETER = 43;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_PARAMETER__OPERATION_PARAMETER = INTERACTION_PARAMETER__OPERATION_PARAMETER;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_PARAMETER__TARGET = INTERACTION_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Receive Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_PARAMETER_FEATURE_COUNT = INTERACTION_PARAMETER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendParameterImpl <em>Send Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendParameterImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getSendParameter()
	 * @generated
	 */
	int SEND_PARAMETER = 44;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_PARAMETER__OPERATION_PARAMETER = INTERACTION_PARAMETER__OPERATION_PARAMETER;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_PARAMETER__SOURCE = INTERACTION_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Send Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_PARAMETER_FEATURE_COUNT = INTERACTION_PARAMETER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.TerminateImpl <em>Terminate</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.TerminateImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getTerminate()
	 * @generated
	 */
	int TERMINATE = 45;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE__NAME = SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE__PARENT = SIMPLE_ELEMENT__PARENT;

	/**
	 * The number of structural features of the '<em>Terminate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_FEATURE_COUNT = SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ParticipantImpl <em>Participant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ParticipantImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getParticipant()
	 * @generated
	 */
	int PARTICIPANT = 46;

	/**
	 * The feature id for the '<em><b>Partners</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__PARTNERS = 0;

	/**
	 * The feature id for the '<em><b>Behaviours</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__BEHAVIOURS = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__NAME = 2;

	/**
	 * The feature id for the '<em><b>Root Package</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__ROOT_PACKAGE = 3;

	/**
	 * The number of structural features of the '<em>Participant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType
	 * <em>Operation Type</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getOperationType()
	 * @generated
	 */
	int OPERATION_TYPE= 47;

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement <em>Service Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Element</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement
	 * @generated
	 */
	EClass getServiceElement();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement#getName()
	 * @see #getServiceElement()
	 * @generated
	 */
	EAttribute getServiceElement_Name();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parent</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement#getParent()
	 * @see #getServiceElement()
	 * @generated
	 */
	EReference getServiceElement_Parent();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint <em>Partner Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Partner Point</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint
	 * @generated
	 */
	EClass getPartnerPoint();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint#getName()
	 * @see #getPartnerPoint()
	 * @generated
	 */
	EAttribute getPartnerPoint_Name();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint#getInterface <em>Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Interface</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint#getInterface()
	 * @see #getPartnerPoint()
	 * @generated
	 */
	EReference getPartnerPoint_Interface();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable <em>Variable</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable
	 * @generated
	 */
	EClass getVariable();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable#getName()
	 * @see #getVariable()
	 * @generated
	 */
	EAttribute getVariable_Name();

	/**
	 * Returns the meta object for the container reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable#getScope <em>Scope</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Scope</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable#getScope()
	 * @see #getVariable()
	 * @generated
	 */
	EReference getVariable_Scope();

	/**
	 * Returns the meta object for class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation
	 * <em>Service Operation</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Service Operation</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation
	 * @generated
	 */
	EClass getServiceOperation();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getName()
	 * @see #getServiceOperation()
	 * @generated
	 */
	EAttribute getServiceOperation_Name();

	/**
	 * Returns the meta object for the reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getUsedIn <em>Used In</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Used In</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getUsedIn()
	 * @see #getServiceOperation()
	 * @generated
	 */
	EReference getServiceOperation_UsedIn();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getParameters()
	 * @see #getServiceOperation()
	 * @generated
	 */
	EReference getServiceOperation_Parameters();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SimpleElement <em>Simple Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Element</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SimpleElement
	 * @generated
	 */
	EClass getSimpleElement();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity <em>Service Activity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Activity</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity
	 * @generated
	 */
	EClass getServiceActivity();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getVariables <em>Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Variables</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getVariables()
	 * @see #getServiceActivity()
	 * @generated
	 */
	EReference getServiceActivity_Variables();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getHandlers <em>Handlers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Handlers</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getHandlers()
	 * @see #getServiceActivity()
	 * @generated
	 */
	EReference getServiceActivity_Handlers();

	/**
	 * Returns the meta object for the reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getInterruptingReceives <em>Interrupting Receives</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Interrupting Receives</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getInterruptingReceives()
	 * @see #getServiceActivity()
	 * @generated
	 */
	EReference getServiceActivity_InterruptingReceives();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler <em>Handler</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Handler</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler
	 * @generated
	 */
	EClass getHandler();

	/**
	 * Returns the meta object for the containment reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Parameter</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler#getParameter()
	 * @see #getHandler()
	 * @generated
	 */
	EReference getHandler_Parameter();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Send <em>Send</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Send</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Send
	 * @generated
	 */
	EClass getSend();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive <em>Receive</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Receive</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive
	 * @generated
	 */
	EClass getReceive();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive#getInterrupts <em>Interrupts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Interrupts</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive#getInterrupts()
	 * @see #getReceive()
	 * @generated
	 */
	EReference getReceive_Interrupts();

	/**
	 * Returns the meta object for class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendAndReceive
	 * <em>Send And Receive</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Send And Receive</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendAndReceive
	 * @generated
	 */
	EClass getSendAndReceive();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveAndReply <em>Receive And Reply</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Receive And Reply</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveAndReply
	 * @generated
	 */
	EClass getReceiveAndReply();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensateAll <em>Compensate All</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Compensate All</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensateAll
	 * @generated
	 */
	EClass getCompensateAll();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate <em>Compensate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Compensate</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate
	 * @generated
	 */
	EClass getCompensate();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate#getServiceActivity <em>Service Activity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Service Activity</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate#getServiceActivity()
	 * @see #getCompensate()
	 * @generated
	 */
	EReference getCompensate_ServiceActivity();

	/**
	 * Returns the meta object for class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler
	 * <em>Exception Handler</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Exception Handler</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler
	 * @generated
	 */
	EClass getExceptionHandler();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler#getFaultName <em>Fault Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fault Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler#getFaultName()
	 * @see #getExceptionHandler()
	 * @generated
	 */
	EAttribute getExceptionHandler_FaultName();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensationHandler <em>Compensation Handler</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Compensation Handler</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensationHandler
	 * @generated
	 */
	EClass getCompensationHandler();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition <em>Path Based Partition</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Path Based Partition</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition
	 * @generated
	 */
	EClass getPathBasedPartition();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition#getPaths <em>Paths</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Paths</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition#getPaths()
	 * @see #getPathBasedPartition()
	 * @generated
	 */
	EReference getPathBasedPartition_Paths();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path <em>Path</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Path</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path
	 * @generated
	 */
	EClass getPath();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path#getCondition <em>Condition</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Condition</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path#getCondition()
	 * @see #getPath()
	 * @generated
	 */
	EReference getPath_Condition();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Decision <em>Decision</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Decision</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Decision
	 * @generated
	 */
	EClass getDecision();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Fork <em>Fork</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Fork</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Fork
	 * @generated
	 */
	EClass getFork();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop <em>Loop</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Loop</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop
	 * @generated
	 */
	EClass getLoop();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop#getLlCondition <em>Ll Condition</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Ll Condition</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop#getLlCondition()
	 * @see #getLoop()
	 * @generated
	 */
	EReference getLoop_LlCondition();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.EventHandler <em>Event Handler</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Handler</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.EventHandler
	 * @generated
	 */
	EClass getEventHandler();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction <em>Service Interaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Interaction</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction
	 * @generated
	 */
	EClass getServiceInteraction();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Operation</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getOperation()
	 * @see #getServiceInteraction()
	 * @generated
	 */
	EReference getServiceInteraction_Operation();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getRcvParameters <em>Rcv Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Rcv Parameters</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getRcvParameters()
	 * @see #getServiceInteraction()
	 * @generated
	 */
	EReference getServiceInteraction_RcvParameters();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getSndParameters <em>Snd Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Snd Parameters</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getSndParameters()
	 * @see #getServiceInteraction()
	 * @generated
	 */
	EReference getServiceInteraction_SndParameters();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getPartner <em>Partner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Partner</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getPartner()
	 * @see #getServiceInteraction()
	 * @generated
	 */
	EReference getServiceInteraction_Partner();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw <em>Throw</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Throw</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw
	 * @generated
	 */
	EClass getThrow();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw#getFault <em>Fault</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Fault</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw#getFault()
	 * @see #getThrow()
	 * @generated
	 */
	EReference getThrow_Fault();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw#getFaultName <em>Fault Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fault Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw#getFaultName()
	 * @see #getThrow()
	 * @generated
	 */
	EAttribute getThrow_FaultName();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement <em>Composite Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Composite Element</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement
	 * @generated
	 */
	EClass getCompositeElement();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Children</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement#getChildren()
	 * @see #getCompositeElement()
	 * @generated
	 */
	EReference getCompositeElement_Children();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Pick <em>Pick</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pick</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Pick
	 * @generated
	 */
	EClass getPick();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Reply <em>Reply</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reply</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Reply
	 * @generated
	 */
	EClass getReply();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling <em>Data Handling</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Handling</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling
	 * @generated
	 */
	EClass getDataHandling();

	/**
	 * Returns the meta object for the reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling#getStatements <em>Statements</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Statements</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling#getStatements()
	 * @see #getDataHandling()
	 * @generated
	 */
	EReference getDataHandling_Statements();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expression</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression
	 * @generated
	 */
	EClass getExpression();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression#getType <em>Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression#getType()
	 * @see #getExpression()
	 * @generated
	 */
	EReference getExpression_Type();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field <em>Field</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Field</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field
	 * @generated
	 */
	EClass getField();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parent</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field#getParent()
	 * @see #getField()
	 * @generated
	 */
	EReference getField_Parent();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field#getName()
	 * @see #getField()
	 * @generated
	 */
	EAttribute getField_Name();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment <em>Assignment</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assignment</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment
	 * @generated
	 */
	EClass getAssignment();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment#getTarget()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_Target();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment#getSource()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_Source();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration <em>Declaration</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Declaration</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration
	 * @generated
	 */
	EClass getDeclaration();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration#getDeclaredVar <em>Declared Var</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Declared Var</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration#getDeclaredVar()
	 * @see #getDeclaration()
	 * @generated
	 */
	EReference getDeclaration_DeclaredVar();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement <em>Statement</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Statement</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement
	 * @generated
	 */
	EClass getStatement();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal <em>Literal</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Literal</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal
	 * @generated
	 */
	EClass getLiteral();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal#getValue()
	 * @see #getLiteral()
	 * @generated
	 */
	EAttribute getLiteral_Value();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation <em>Operation</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operation</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation
	 * @generated
	 */
	EClass getOperation();

	/**
	 * Returns the meta object for the reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation#getOperands <em>Operands</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Operands</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation#getOperands()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Operands();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation#getOperationType <em>Operation Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operation Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation#getOperationType()
	 * @see #getOperation()
	 * @generated
	 */
	EAttribute getOperation_OperationType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.LeftHandSideExpression <em>Left Hand Side Expression</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Left Hand Side Expression</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.LeftHandSideExpression
	 * @generated
	 */
	EClass getLeftHandSideExpression();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RightHandSideExpression <em>Right Hand Side Expression</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Right Hand Side Expression</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RightHandSideExpression
	 * @generated
	 */
	EClass getRightHandSideExpression();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface <em>Service Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Interface</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface
	 * @generated
	 */
	EClass getServiceInterface();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface#getUsed <em>Used</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Used</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface#getUsed()
	 * @see #getServiceInterface()
	 * @generated
	 */
	EReference getServiceInterface_Used();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface#getImplemented <em>Implemented</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Implemented</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface#getImplemented()
	 * @see #getServiceInterface()
	 * @generated
	 */
	EReference getServiceInterface_Implemented();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServicePoint <em>Service Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Point</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServicePoint
	 * @generated
	 */
	EClass getServicePoint();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RequestPoint <em>Request Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Request Point</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RequestPoint
	 * @generated
	 */
	EClass getRequestPoint();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter <em>Service Operation Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Operation Parameter</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter
	 * @generated
	 */
	EClass getServiceOperationParameter();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter#getName()
	 * @see #getServiceOperationParameter()
	 * @generated
	 */
	EAttribute getServiceOperationParameter_Name();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter#getType()
	 * @see #getServiceOperationParameter()
	 * @generated
	 */
	EReference getServiceOperationParameter_Type();

	/**
	 * Returns the meta object for the container reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Operation</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter#getOperation()
	 * @see #getServiceOperationParameter()
	 * @generated
	 */
	EReference getServiceOperationParameter_Operation();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InParameter <em>In Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>In Parameter</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InParameter
	 * @generated
	 */
	EClass getInParameter();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OutParameter <em>Out Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Out Parameter</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OutParameter
	 * @generated
	 */
	EClass getOutParameter();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter <em>Interaction Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Interaction Parameter</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter
	 * @generated
	 */
	EClass getInteractionParameter();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter#getOperationParameter <em>Operation Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Operation Parameter</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter#getOperationParameter()
	 * @see #getInteractionParameter()
	 * @generated
	 */
	EReference getInteractionParameter_OperationParameter();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter <em>Receive Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Receive Parameter</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter
	 * @generated
	 */
	EClass getReceiveParameter();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter#getTarget()
	 * @see #getReceiveParameter()
	 * @generated
	 */
	EReference getReceiveParameter_Target();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter <em>Send Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Send Parameter</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter
	 * @generated
	 */
	EClass getSendParameter();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter#getSource()
	 * @see #getSendParameter()
	 * @generated
	 */
	EReference getSendParameter_Source();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Terminate <em>Terminate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Terminate</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Terminate
	 * @generated
	 */
	EClass getTerminate();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant <em>Participant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Participant</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant
	 * @generated
	 */
	EClass getParticipant();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant#getPartners <em>Partners</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Partners</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant#getPartners()
	 * @see #getParticipant()
	 * @generated
	 */
	EReference getParticipant_Partners();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant#getBehaviours <em>Behaviours</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Behaviours</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant#getBehaviours()
	 * @see #getParticipant()
	 * @generated
	 */
	EReference getParticipant_Behaviours();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant#getName()
	 * @see #getParticipant()
	 * @generated
	 */
	EAttribute getParticipant_Name();

	/**
	 * Returns the meta object for the containment reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant#getRootPackage <em>Root Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Root Package</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant#getRootPackage()
	 * @see #getParticipant()
	 * @generated
	 */
	EReference getParticipant_RootPackage();

	/**
	 * Returns the meta object for enum '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType <em>Operation Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Operation Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType
	 * @generated
	 */
	EEnum getOperationType();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	IOMFactory getIOMFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceElementImpl <em>Service Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceElementImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceElement()
		 * @generated
		 */
		EClass SERVICE_ELEMENT = eINSTANCE.getServiceElement();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE_ELEMENT__NAME = eINSTANCE.getServiceElement_Name();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_ELEMENT__PARENT = eINSTANCE.getServiceElement_Parent();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PartnerPointImpl <em>Partner Point</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PartnerPointImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getPartnerPoint()
		 * @generated
		 */
		EClass PARTNER_POINT = eINSTANCE.getPartnerPoint();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARTNER_POINT__NAME = eINSTANCE.getPartnerPoint_Name();

		/**
		 * The meta object literal for the '<em><b>Interface</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTNER_POINT__INTERFACE = eINSTANCE.getPartnerPoint_Interface();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.VariableImpl
		 * <em>Variable</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.VariableImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getVariable()
		 * @generated
		 */
		EClass VARIABLE= eINSTANCE.getVariable();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VARIABLE__NAME= eINSTANCE.getVariable_Name();

		/**
		 * The meta object literal for the '<em><b>Scope</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE__SCOPE= eINSTANCE.getVariable_Scope();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationImpl <em>Service Operation</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceOperation()
		 * @generated
		 */
		EClass SERVICE_OPERATION= eINSTANCE.getServiceOperation();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE_OPERATION__NAME= eINSTANCE.getServiceOperation_Name();

		/**
		 * The meta object literal for the '<em><b>Used In</b></em>' reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_OPERATION__USED_IN= eINSTANCE.getServiceOperation_UsedIn();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_OPERATION__PARAMETERS = eINSTANCE.getServiceOperation_Parameters();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SimpleElementImpl <em>Simple Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SimpleElementImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getSimpleElement()
		 * @generated
		 */
		EClass SIMPLE_ELEMENT = eINSTANCE.getSimpleElement();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceActivityImpl <em>Service Activity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceActivityImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceActivity()
		 * @generated
		 */
		EClass SERVICE_ACTIVITY = eINSTANCE.getServiceActivity();

		/**
		 * The meta object literal for the '<em><b>Variables</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_ACTIVITY__VARIABLES = eINSTANCE.getServiceActivity_Variables();

		/**
		 * The meta object literal for the '<em><b>Handlers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_ACTIVITY__HANDLERS = eINSTANCE.getServiceActivity_Handlers();

		/**
		 * The meta object literal for the '<em><b>Interrupting Receives</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_ACTIVITY__INTERRUPTING_RECEIVES = eINSTANCE.getServiceActivity_InterruptingReceives();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.HandlerImpl
		 * <em>Handler</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.HandlerImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getHandler()
		 * @generated
		 */
		EClass HANDLER= eINSTANCE.getHandler();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference HANDLER__PARAMETER= eINSTANCE.getHandler_Parameter();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendImpl <em>Send</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getSend()
		 * @generated
		 */
		EClass SEND= eINSTANCE.getSend();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveImpl
		 * <em>Receive</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getReceive()
		 * @generated
		 */
		EClass RECEIVE= eINSTANCE.getReceive();

		/**
		 * The meta object literal for the '<em><b>Interrupts</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RECEIVE__INTERRUPTS = eINSTANCE.getReceive_Interrupts();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendAndReceiveImpl <em>Send And Receive</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendAndReceiveImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getSendAndReceive()
		 * @generated
		 */
		EClass SEND_AND_RECEIVE= eINSTANCE.getSendAndReceive();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveAndReplyImpl <em>Receive And Reply</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveAndReplyImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getReceiveAndReply()
		 * @generated
		 */
		EClass RECEIVE_AND_REPLY = eINSTANCE.getReceiveAndReply();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensateAllImpl <em>Compensate All</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensateAllImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getCompensateAll()
		 * @generated
		 */
		EClass COMPENSATE_ALL = eINSTANCE.getCompensateAll();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensateImpl <em>Compensate</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensateImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getCompensate()
		 * @generated
		 */
		EClass COMPENSATE = eINSTANCE.getCompensate();

		/**
		 * The meta object literal for the '<em><b>Service Activity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPENSATE__SERVICE_ACTIVITY = eINSTANCE.getCompensate_ServiceActivity();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ExceptionHandlerImpl <em>Exception Handler</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ExceptionHandlerImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getExceptionHandler()
		 * @generated
		 */
		EClass EXCEPTION_HANDLER= eINSTANCE.getExceptionHandler();

		/**
		 * The meta object literal for the '<em><b>Fault Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXCEPTION_HANDLER__FAULT_NAME = eINSTANCE.getExceptionHandler_FaultName();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensationHandlerImpl <em>Compensation Handler</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompensationHandlerImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getCompensationHandler()
		 * @generated
		 */
		EClass COMPENSATION_HANDLER= eINSTANCE.getCompensationHandler();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PathBasedPartitionImpl <em>Path Based Partition</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PathBasedPartitionImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getPathBasedPartition()
		 * @generated
		 */
		EClass PATH_BASED_PARTITION= eINSTANCE.getPathBasedPartition();

		/**
		 * The meta object literal for the '<em><b>Paths</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATH_BASED_PARTITION__PATHS= eINSTANCE.getPathBasedPartition_Paths();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PathImpl <em>Path</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PathImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getPath()
		 * @generated
		 */
		EClass PATH= eINSTANCE.getPath();

		/**
		 * The meta object literal for the '<em><b>Condition</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference PATH__CONDITION= eINSTANCE.getPath_Condition();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DecisionImpl <em>Decision</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DecisionImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getDecision()
		 * @generated
		 */
		EClass DECISION = eINSTANCE.getDecision();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ForkImpl <em>Fork</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ForkImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getFork()
		 * @generated
		 */
		EClass FORK = eINSTANCE.getFork();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LoopImpl <em>Loop</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LoopImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getLoop()
		 * @generated
		 */
		EClass LOOP= eINSTANCE.getLoop();

		/**
		 * The meta object literal for the '<em><b>Ll Condition</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOOP__LL_CONDITION= eINSTANCE.getLoop_LlCondition();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.EventHandlerImpl <em>Event Handler</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.EventHandlerImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getEventHandler()
		 * @generated
		 */
		EClass EVENT_HANDLER= eINSTANCE.getEventHandler();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInteractionImpl <em>Service Interaction</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInteractionImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceInteraction()
		 * @generated
		 */
		EClass SERVICE_INTERACTION = eINSTANCE.getServiceInteraction();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_INTERACTION__OPERATION = eINSTANCE.getServiceInteraction_Operation();

		/**
		 * The meta object literal for the '<em><b>Rcv Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_INTERACTION__RCV_PARAMETERS = eINSTANCE.getServiceInteraction_RcvParameters();

		/**
		 * The meta object literal for the '<em><b>Snd Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_INTERACTION__SND_PARAMETERS = eINSTANCE.getServiceInteraction_SndParameters();

		/**
		 * The meta object literal for the '<em><b>Partner</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_INTERACTION__PARTNER = eINSTANCE.getServiceInteraction_Partner();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ThrowImpl <em>Throw</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ThrowImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getThrow()
		 * @generated
		 */
		EClass THROW= eINSTANCE.getThrow();

		/**
		 * The meta object literal for the '<em><b>Fault</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference THROW__FAULT= eINSTANCE.getThrow_Fault();

		/**
		 * The meta object literal for the '<em><b>Fault Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute THROW__FAULT_NAME = eINSTANCE.getThrow_FaultName();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompositeElementImpl <em>Composite Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.CompositeElementImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getCompositeElement()
		 * @generated
		 */
		EClass COMPOSITE_ELEMENT = eINSTANCE.getCompositeElement();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPOSITE_ELEMENT__CHILDREN = eINSTANCE.getCompositeElement_Children();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PickImpl <em>Pick</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.PickImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getPick()
		 * @generated
		 */
		EClass PICK= eINSTANCE.getPick();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReplyImpl <em>Reply</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReplyImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getReply()
		 * @generated
		 */
		EClass REPLY= eINSTANCE.getReply();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DataHandlingImpl <em>Data Handling</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DataHandlingImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getDataHandling()
		 * @generated
		 */
		EClass DATA_HANDLING= eINSTANCE.getDataHandling();

		/**
		 * The meta object literal for the '<em><b>Statements</b></em>' reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_HANDLING__STATEMENTS= eINSTANCE.getDataHandling_Statements();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ExpressionImpl <em>Expression</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ExpressionImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getExpression()
		 * @generated
		 */
		EClass EXPRESSION= eINSTANCE.getExpression();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXPRESSION__TYPE= eINSTANCE.getExpression_Type();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.FieldImpl <em>Field</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.FieldImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getField()
		 * @generated
		 */
		EClass FIELD= eINSTANCE.getField();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference FIELD__PARENT= eINSTANCE.getField_Parent();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FIELD__NAME= eINSTANCE.getField_Name();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.AssignmentImpl <em>Assignment</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.AssignmentImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getAssignment()
		 * @generated
		 */
		EClass ASSIGNMENT= eINSTANCE.getAssignment();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT__TARGET= eINSTANCE.getAssignment_Target();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT__SOURCE= eINSTANCE.getAssignment_Source();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DeclarationImpl <em>Declaration</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DeclarationImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getDeclaration()
		 * @generated
		 */
		EClass DECLARATION= eINSTANCE.getDeclaration();

		/**
		 * The meta object literal for the '<em><b>Declared Var</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference DECLARATION__DECLARED_VAR= eINSTANCE.getDeclaration_DeclaredVar();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.StatementImpl
		 * <em>Statement</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.StatementImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getStatement()
		 * @generated
		 */
		EClass STATEMENT= eINSTANCE.getStatement();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LiteralImpl
		 * <em>Literal</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LiteralImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getLiteral()
		 * @generated
		 */
		EClass LITERAL= eINSTANCE.getLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LITERAL__VALUE= eINSTANCE.getLiteral_Value();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OperationImpl
		 * <em>Operation</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OperationImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getOperation()
		 * @generated
		 */
		EClass OPERATION= eINSTANCE.getOperation();

		/**
		 * The meta object literal for the '<em><b>Operands</b></em>' reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__OPERANDS= eINSTANCE.getOperation_Operands();

		/**
		 * The meta object literal for the '<em><b>Operation Type</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPERATION__OPERATION_TYPE= eINSTANCE.getOperation_OperationType();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LeftHandSideExpressionImpl <em>Left Hand Side Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.LeftHandSideExpressionImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getLeftHandSideExpression()
		 * @generated
		 */
		EClass LEFT_HAND_SIDE_EXPRESSION= eINSTANCE.getLeftHandSideExpression();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.RightHandSideExpressionImpl <em>Right Hand Side Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.RightHandSideExpressionImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getRightHandSideExpression()
		 * @generated
		 */
		EClass RIGHT_HAND_SIDE_EXPRESSION= eINSTANCE.getRightHandSideExpression();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInterfaceImpl <em>Service Interface</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInterfaceImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceInterface()
		 * @generated
		 */
		EClass SERVICE_INTERFACE = eINSTANCE.getServiceInterface();

		/**
		 * The meta object literal for the '<em><b>Used</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_INTERFACE__USED = eINSTANCE.getServiceInterface_Used();

		/**
		 * The meta object literal for the '<em><b>Implemented</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_INTERFACE__IMPLEMENTED = eINSTANCE.getServiceInterface_Implemented();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServicePointImpl <em>Service Point</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServicePointImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServicePoint()
		 * @generated
		 */
		EClass SERVICE_POINT = eINSTANCE.getServicePoint();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.RequestPointImpl <em>Request Point</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.RequestPointImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getRequestPoint()
		 * @generated
		 */
		EClass REQUEST_POINT = eINSTANCE.getRequestPoint();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationParameterImpl <em>Service Operation Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationParameterImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getServiceOperationParameter()
		 * @generated
		 */
		EClass SERVICE_OPERATION_PARAMETER = eINSTANCE.getServiceOperationParameter();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE_OPERATION_PARAMETER__NAME = eINSTANCE.getServiceOperationParameter_Name();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_OPERATION_PARAMETER__TYPE = eINSTANCE.getServiceOperationParameter_Type();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_OPERATION_PARAMETER__OPERATION = eINSTANCE.getServiceOperationParameter_Operation();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.InParameterImpl <em>In Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.InParameterImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getInParameter()
		 * @generated
		 */
		EClass IN_PARAMETER = eINSTANCE.getInParameter();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OutParameterImpl <em>Out Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OutParameterImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getOutParameter()
		 * @generated
		 */
		EClass OUT_PARAMETER = eINSTANCE.getOutParameter();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.InteractionParameterImpl <em>Interaction Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.InteractionParameterImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getInteractionParameter()
		 * @generated
		 */
		EClass INTERACTION_PARAMETER = eINSTANCE.getInteractionParameter();

		/**
		 * The meta object literal for the '<em><b>Operation Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERACTION_PARAMETER__OPERATION_PARAMETER = eINSTANCE.getInteractionParameter_OperationParameter();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveParameterImpl <em>Receive Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ReceiveParameterImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getReceiveParameter()
		 * @generated
		 */
		EClass RECEIVE_PARAMETER = eINSTANCE.getReceiveParameter();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RECEIVE_PARAMETER__TARGET = eINSTANCE.getReceiveParameter_Target();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendParameterImpl <em>Send Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.SendParameterImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getSendParameter()
		 * @generated
		 */
		EClass SEND_PARAMETER = eINSTANCE.getSendParameter();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEND_PARAMETER__SOURCE = eINSTANCE.getSendParameter_Source();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.TerminateImpl <em>Terminate</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.TerminateImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getTerminate()
		 * @generated
		 */
		EClass TERMINATE = eINSTANCE.getTerminate();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ParticipantImpl <em>Participant</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ParticipantImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getParticipant()
		 * @generated
		 */
		EClass PARTICIPANT = eINSTANCE.getParticipant();

		/**
		 * The meta object literal for the '<em><b>Partners</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT__PARTNERS = eINSTANCE.getParticipant_Partners();

		/**
		 * The meta object literal for the '<em><b>Behaviours</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT__BEHAVIOURS = eINSTANCE.getParticipant_Behaviours();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARTICIPANT__NAME = eINSTANCE.getParticipant_Name();

		/**
		 * The meta object literal for the '<em><b>Root Package</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT__ROOT_PACKAGE = eINSTANCE.getParticipant_RootPackage();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType <em>Operation Type</em>}' enum.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.IOMPackageImpl#getOperationType()
		 * @generated
		 */
		EEnum OPERATION_TYPE= eINSTANCE.getOperationType();

	}

} // IOMPackage
