/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom;

import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Service Partner</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint#getName <em>Name</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint#getInterface <em>Interface</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getPartnerPoint()
 * @model abstract="true"
 * @generated
 */
public interface PartnerPoint extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServicePartner_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Interface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interface</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interface</em>' reference.
	 * @see #setInterface(ServiceInterface)
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getPartnerPoint_Interface()
	 * @model
	 * @generated
	 */
	ServiceInterface getInterface();

	/**
	 * Sets the value of the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint#getInterface <em>Interface</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interface</em>' reference.
	 * @see #getInterface()
	 * @generated
	 */
	void setInterface(ServiceInterface value);

	/**
	 * Gets all used operations of this partner point.
	 * The Operations are defined in the interfaces of 
	 * the ServiceInterface of the Port.
	 * 
	 * Subclasses need to override this.
	 * 
	 * @return List of all used operations.
	 */
	EList<ServiceOperation> getUsedOperations();
	
	/**
	 * Gets all implemented operations of this partner point.
	 * The Operations are defined in the interfaces of 
	 * the ServiceInterface of the Port.
	 * 
	 * Subclasses need to override this.
	 * 
	 * @return List of all used operations.
	 */
	EList<ServiceOperation> getImplementedOperations();

	/**
	 * Collects all operations of this partner point, both implemented and used.
	 * 
	 * @return all operations this partnerpoint is involved in
	 */
	List<ServiceOperation> getAllOperations();

} // PartnerPoint
