/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>ServiceActivity</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getVariables <em>Variables</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getHandlers <em>Handlers</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity#getInterruptingReceives <em>Interrupting Receives</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceActivity()
 * @model
 * @generated
 */
public interface ServiceActivity extends CompositeElement {
	/**
	 * Returns the value of the '<em><b>Variables</b></em>' containment
	 * reference list. The list contents are of type
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Variables</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Variables</em>' containment reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getScope_Variables()
	 * @model containment="true"
	 * @generated
	 */
	EList<Variable> getVariables();

	/**
	 * Returns the value of the '<em><b>Handlers</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Handlers</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Handlers</em>' containment reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getScope_Handlers()
	 * @model containment="true"
	 * @generated
	 */
	EList<Handler> getHandlers();

	/**
	 * Returns the value of the '<em><b>Interrupting Receives</b></em>' reference list.
	 * The list contents are of type {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive}.
	 * It is bidirectional and its opposite is '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive#getInterrupts <em>Interrupts</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interrupting Receives</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interrupting Receives</em>' reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceActivity_InterruptingReceives()
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive#getInterrupts
	 * @model opposite="interrupts"
	 * @generated
	 */
	EList<Receive> getInterruptingReceives();
} // ServiceActivity
