/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom;

import org.eclipse.emf.ecore.EObject;

import de.lmu.ifi.pst.mdd4soa.transform.exception.TransformationException;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>ServiceElement</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement#getName <em>Name</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement#getParent <em>Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceElement()
 * @model abstract="true"
 * @generated
 */
public interface ServiceElement extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getActivity_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Parent</em>' reference.
	 * @see #setParent(CompositeElement)
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getActivity_Parent()
	 * @model
	 * @generated
	 */
	CompositeElement getParent();

	/**
	 * Sets the value of the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement#getParent
	 * <em>Parent</em>}' reference. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value the new value of the '<em>Parent</em>' reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(CompositeElement value);

	/**
	 * <!-- begin-user-doc --> Searches for the next parent serviceActivity that is
	 * available. This is helpful, because the next serviceActivity is not necessarily the
	 * parent. The activity can be inside a partition of a serviceActivity or another
	 * partition...
	 * 
	 * @return a {@link ServiceActivity} that contains the activity directly.
	 * @throws TransformationException <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated NOT
	 */
	ServiceActivity getCurrentScope() throws TransformationException;

	/**
	 * <!-- begin-user-doc --> Searches all the parent scopes for one matching
	 * the parameter scopeName. Note: Only the scopes are accessible, that are
	 * in the hierarchy above the current one.
	 * 
	 * @param scopeName the name of the serviceActivity to search.
	 * @return a {@link ServiceActivity} that is a (direct or indirect) parent of this
	 *         activity.
	 * @throws TransformationException <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated NOT
	 */
	ServiceActivity getScope(String scopeName) throws TransformationException;

} // ServiceElement
