/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom;

import java.util.List;

import org.eclipse.emf.common.util.EList;


/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Partner Interaction</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getOperation <em>Operation</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getRcvParameters <em>Rcv Parameters</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getSndParameters <em>Snd Parameters</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getPartner <em>Partner</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceInteraction()
 * @model abstract="true"
 * @generated
 */
public interface ServiceInteraction extends SimpleElement {
	/**
	 * Returns the value of the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operation</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Operation</em>' reference.
	 * @see #setOperation(ServiceOperation)
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getPartnerInteraction_Operation()
	 * @model
	 * @generated
	 */
	ServiceOperation getOperation();

	/**
	 * Sets the value of the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getOperation
	 * <em>Operation</em>}' reference. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value the new value of the '<em>Operation</em>' reference.
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(ServiceOperation value);

	/**
	 * Returns the value of the '<em><b>Rcv Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Rcv Parameters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rcv Parameters</em>' containment reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceInteraction_RcvParameters()
	 * @model containment="true"
	 * @generated
	 */
	EList<InteractionParameter> getRcvParameters();

	/**
	 * Returns the value of the '<em><b>Snd Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Snd Parameters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Snd Parameters</em>' containment reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceInteraction_SndParameters()
	 * @model containment="true"
	 * @generated
	 */
	EList<InteractionParameter> getSndParameters();
	
	
	/**
	 * Returns the value of the '<em><b>Partner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Partner</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Partner</em>' reference.
	 * @see #setPartner(PartnerPoint)
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceInteraction_Partner()
	 * @model required="true"
	 * @generated
	 */
	PartnerPoint getPartner();

	/**
	 * Sets the value of the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getPartner <em>Partner</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Partner</em>' reference.
	 * @see #getPartner()
	 * @generated
	 */
	void setPartner(PartnerPoint value);

	/**
	 * Gets all {@link InteractionParameter}s (both snd and rcv).
	 * @see #getRcvParameters() and {@link #getSndParameters()}
	 * 
	 * @return List of all parameters on this interaction
	 */
	List<InteractionParameter> getAllParameters();

} // ServiceInteraction
