/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Service Operation</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getUsedIn <em>Used In</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getParameters <em>Parameters</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceOperation()
 * @model
 * @generated
 */
public interface ServiceOperation extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceOperation_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Used In</b></em>' reference list.
	 * The list contents are of type {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction}.
	 * It is bidirectional and its opposite is '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Used In</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Used In</em>' reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceOperation_UsedIn()
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction#getOperation
	 * @model opposite="operation"
	 * @generated
	 */
	EList<ServiceInteraction> getUsedIn();

	/**
	 * Returns the value of the '<em><b>Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter}.
	 * It is bidirectional and its opposite is '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parameters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parameters</em>' containment reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#getServiceOperation_Parameters()
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter#getOperation
	 * @model opposite="operation" containment="true"
	 * @generated
	 */
	EList<ServiceOperationParameter> getParameters();

//	/**
//	 * Query over all partner interactions used in ({@link #usedIn}). getting
//	 * the source type of the partner interaction.
//	 * 
//	 * @return the common source type of each interaction used in or
//	 *         <b>null</b>, if it is not defined
//	 * @throws TransformationException when the type of an expression cannot be
//	 *         resolved.
//	 */
//	Type getSourceType() throws TransformationException;
//
//	/**
//	 * Query over all partner interactions used in ({@link #usedIn}). getting
//	 * the target type of the partner interaction.
//	 * 
//	 * @return the common target type of each interaction used in or
//	 *         <b>null</b>, if it is not defined
//	 * @throws TransformationException when the type of an expression cannot be
//	 *         resolved.
//	 */
//	Type getTargetType() throws TransformationException;

} // ServiceOperation
