/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Data Handling</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.DataHandlingImpl#getStatements <em>Statements</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DataHandlingImpl extends SimpleElementImpl implements DataHandling {
	/**
	 * The cached value of the '{@link #getStatements() <em>Statements</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStatements()
	 * @generated
	 * @ordered
	 */
	protected EList<Statement> statements;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DataHandlingImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IOMPackage.Literals.DATA_HANDLING;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Statement> getStatements() {
		if (statements == null) {
			statements = new EObjectResolvingEList<Statement>(Statement.class, this, IOMPackage.DATA_HANDLING__STATEMENTS);
		}
		return statements;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IOMPackage.DATA_HANDLING__STATEMENTS:
				return getStatements();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IOMPackage.DATA_HANDLING__STATEMENTS:
				getStatements().clear();
				getStatements().addAll((Collection<? extends Statement>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IOMPackage.DATA_HANDLING__STATEMENTS:
				getStatements().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IOMPackage.DATA_HANDLING__STATEMENTS:
				return statements != null && !statements.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} // DataHandlingImpl
