/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensateAll;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensationHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Decision;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.EventHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Fork;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMFactory;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OutParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Pick;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveAndReply;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Reply;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RequestPoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Send;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendAndReceive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServicePoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Terminate;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class IOMFactoryImpl extends EFactoryImpl implements IOMFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public static IOMFactory init() {
		try {
			IOMFactory theIOMFactory = (IOMFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.pst.ifi.lmu.de/projekte/mdd4soa/iom"); 
			if (theIOMFactory != null) {
				return theIOMFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new IOMFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public IOMFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case IOMPackage.VARIABLE: return createVariable();
			case IOMPackage.SERVICE_OPERATION: return createServiceOperation();
			case IOMPackage.SERVICE_ACTIVITY: return createServiceActivity();
			case IOMPackage.SEND: return createSend();
			case IOMPackage.RECEIVE: return createReceive();
			case IOMPackage.SEND_AND_RECEIVE: return createSendAndReceive();
			case IOMPackage.RECEIVE_AND_REPLY: return createReceiveAndReply();
			case IOMPackage.COMPENSATE_ALL: return createCompensateAll();
			case IOMPackage.COMPENSATE: return createCompensate();
			case IOMPackage.EXCEPTION_HANDLER: return createExceptionHandler();
			case IOMPackage.COMPENSATION_HANDLER: return createCompensationHandler();
			case IOMPackage.PATH: return createPath();
			case IOMPackage.DECISION: return createDecision();
			case IOMPackage.FORK: return createFork();
			case IOMPackage.LOOP: return createLoop();
			case IOMPackage.EVENT_HANDLER: return createEventHandler();
			case IOMPackage.THROW: return createThrow();
			case IOMPackage.PICK: return createPick();
			case IOMPackage.REPLY: return createReply();
			case IOMPackage.DATA_HANDLING: return createDataHandling();
			case IOMPackage.FIELD: return createField();
			case IOMPackage.ASSIGNMENT: return createAssignment();
			case IOMPackage.DECLARATION: return createDeclaration();
			case IOMPackage.STATEMENT: return createStatement();
			case IOMPackage.LITERAL: return createLiteral();
			case IOMPackage.OPERATION: return createOperation();
			case IOMPackage.SERVICE_INTERFACE: return createServiceInterface();
			case IOMPackage.SERVICE_POINT: return createServicePoint();
			case IOMPackage.REQUEST_POINT: return createRequestPoint();
			case IOMPackage.IN_PARAMETER: return createInParameter();
			case IOMPackage.OUT_PARAMETER: return createOutParameter();
			case IOMPackage.RECEIVE_PARAMETER: return createReceiveParameter();
			case IOMPackage.SEND_PARAMETER: return createSendParameter();
			case IOMPackage.TERMINATE: return createTerminate();
			case IOMPackage.PARTICIPANT: return createParticipant();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case IOMPackage.OPERATION_TYPE:
				return createOperationTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case IOMPackage.OPERATION_TYPE:
				return convertOperationTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Variable createVariable() {
		VariableImpl variable = new VariableImpl();
		return variable;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceOperation createServiceOperation() {
		ServiceOperationImpl serviceOperation = new ServiceOperationImpl();
		return serviceOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceActivity createServiceActivity() {
		ServiceActivityImpl serviceActivity = new ServiceActivityImpl();
		return serviceActivity;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Send createSend() {
		SendImpl send = new SendImpl();
		return send;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Receive createReceive() {
		ReceiveImpl receive = new ReceiveImpl();
		return receive;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public SendAndReceive createSendAndReceive() {
		SendAndReceiveImpl sendAndReceive = new SendAndReceiveImpl();
		return sendAndReceive;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReceiveAndReply createReceiveAndReply() {
		ReceiveAndReplyImpl receiveAndReply = new ReceiveAndReplyImpl();
		return receiveAndReply;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompensateAll createCompensateAll() {
		CompensateAllImpl compensateAll = new CompensateAllImpl();
		return compensateAll;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Compensate createCompensate() {
		CompensateImpl compensate = new CompensateImpl();
		return compensate;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ExceptionHandler createExceptionHandler() {
		ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
		return exceptionHandler;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public CompensationHandler createCompensationHandler() {
		CompensationHandlerImpl compensationHandler = new CompensationHandlerImpl();
		return compensationHandler;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Path createPath() {
		PathImpl path = new PathImpl();
		return path;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Decision createDecision() {
		DecisionImpl decision = new DecisionImpl();
		return decision;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Fork createFork() {
		ForkImpl fork = new ForkImpl();
		return fork;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Loop createLoop() {
		LoopImpl loop = new LoopImpl();
		return loop;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EventHandler createEventHandler() {
		EventHandlerImpl eventHandler = new EventHandlerImpl();
		return eventHandler;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Throw createThrow() {
		ThrowImpl throw_ = new ThrowImpl();
		return throw_;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Pick createPick() {
		PickImpl pick = new PickImpl();
		return pick;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Reply createReply() {
		ReplyImpl reply = new ReplyImpl();
		return reply;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DataHandling createDataHandling() {
		DataHandlingImpl dataHandling = new DataHandlingImpl();
		return dataHandling;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Field createField() {
		FieldImpl field = new FieldImpl();
		return field;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Assignment createAssignment() {
		AssignmentImpl assignment = new AssignmentImpl();
		return assignment;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Declaration createDeclaration() {
		DeclarationImpl declaration = new DeclarationImpl();
		return declaration;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Statement createStatement() {
		StatementImpl statement = new StatementImpl();
		return statement;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Literal createLiteral() {
		LiteralImpl literal = new LiteralImpl();
		return literal;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Operation createOperation() {
		OperationImpl operation = new OperationImpl();
		return operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceInterface createServiceInterface() {
		ServiceInterfaceImpl serviceInterface = new ServiceInterfaceImpl();
		return serviceInterface;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServicePoint createServicePoint() {
		ServicePointImpl servicePoint = new ServicePointImpl();
		return servicePoint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RequestPoint createRequestPoint() {
		RequestPointImpl requestPoint = new RequestPointImpl();
		return requestPoint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InParameter createInParameter() {
		InParameterImpl inParameter = new InParameterImpl();
		return inParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutParameter createOutParameter() {
		OutParameterImpl outParameter = new OutParameterImpl();
		return outParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReceiveParameter createReceiveParameter() {
		ReceiveParameterImpl receiveParameter = new ReceiveParameterImpl();
		return receiveParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SendParameter createSendParameter() {
		SendParameterImpl sendParameter = new SendParameterImpl();
		return sendParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Terminate createTerminate() {
		TerminateImpl terminate = new TerminateImpl();
		return terminate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Participant createParticipant() {
		ParticipantImpl participant = new ParticipantImpl();
		return participant;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public OperationType createOperationTypeFromString(EDataType eDataType, String initialValue) {
		OperationType result = OperationType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String convertOperationTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public IOMPackage getIOMPackage() {
		return (IOMPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static IOMPackage getPackage() {
		return IOMPackage.eINSTANCE;
	}

} // IOMFactoryImpl
