/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensateAll;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensationHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Decision;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.EventHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Fork;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMFactory;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.LeftHandSideExpression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OutParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Pick;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveAndReply;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Reply;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RequestPoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RightHandSideExpression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Send;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendAndReceive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServicePoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SimpleElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Terminate;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class IOMPackageImpl extends EPackageImpl implements IOMPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceElementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass partnerPointEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass variableEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceOperationEClass= null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass simpleElementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceActivityEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass handlerEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sendEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass receiveEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sendAndReceiveEClass= null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass receiveAndReplyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass compensateAllEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass compensateEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass exceptionHandlerEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass compensationHandlerEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pathBasedPartitionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pathEClass= null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass decisionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass forkEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass loopEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass eventHandlerEClass= null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceInteractionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass throwEClass= null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass compositeElementEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pickEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass replyEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass dataHandlingEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass expressionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fieldEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass assignmentEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass declarationEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass statementEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass literalEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass operationEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass leftHandSideExpressionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rightHandSideExpressionEClass= null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceInterfaceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass servicePointEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass requestPointEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceOperationParameterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass inParameterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass outParameterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass interactionParameterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass receiveParameterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sendParameterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass terminateEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass participantEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum operationTypeEEnum= null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private IOMPackageImpl() {
		super(eNS_URI, IOMFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited= false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link IOMPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static IOMPackage init() {
		if (isInited) return (IOMPackage)EPackage.Registry.INSTANCE.getEPackage(IOMPackage.eNS_URI);

		// Obtain or create and register package
		IOMPackageImpl theIOMPackage = (IOMPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof IOMPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new IOMPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		TypePackageImpl theTypePackage = (TypePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(TypePackage.eNS_URI) instanceof TypePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(TypePackage.eNS_URI) : TypePackage.eINSTANCE);

		// Create package meta-data objects
		theIOMPackage.createPackageContents();
		theTypePackage.createPackageContents();

		// Initialize created meta-data
		theIOMPackage.initializePackageContents();
		theTypePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theIOMPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(IOMPackage.eNS_URI, theIOMPackage);
		return theIOMPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServiceElement() {
		return serviceElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServiceElement_Name() {
		return (EAttribute)serviceElementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceElement_Parent() {
		return (EReference)serviceElementEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPartnerPoint() {
		return partnerPointEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPartnerPoint_Name() {
		return (EAttribute)partnerPointEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPartnerPoint_Interface() {
		return (EReference)partnerPointEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVariable() {
		return variableEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getVariable_Name() {
		return (EAttribute)variableEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVariable_Scope() {
		return (EReference)variableEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServiceOperation() {
		return serviceOperationEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServiceOperation_Name() {
		return (EAttribute)serviceOperationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceOperation_UsedIn() {
		return (EReference)serviceOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceOperation_Parameters() {
		return (EReference)serviceOperationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSimpleElement() {
		return simpleElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServiceActivity() {
		return serviceActivityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceActivity_Variables() {
		return (EReference)serviceActivityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceActivity_Handlers() {
		return (EReference)serviceActivityEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceActivity_InterruptingReceives() {
		return (EReference)serviceActivityEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHandler() {
		return handlerEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHandler_Parameter() {
		return (EReference)handlerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSend() {
		return sendEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getReceive() {
		return receiveEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getReceive_Interrupts() {
		return (EReference)receiveEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSendAndReceive() {
		return sendAndReceiveEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getReceiveAndReply() {
		return receiveAndReplyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCompensateAll() {
		return compensateAllEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCompensate() {
		return compensateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCompensate_ServiceActivity() {
		return (EReference)compensateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExceptionHandler() {
		return exceptionHandlerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExceptionHandler_FaultName() {
		return (EAttribute)exceptionHandlerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCompensationHandler() {
		return compensationHandlerEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPathBasedPartition() {
		return pathBasedPartitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPathBasedPartition_Paths() {
		return (EReference)pathBasedPartitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPath() {
		return pathEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPath_Condition() {
		return (EReference)pathEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDecision() {
		return decisionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFork() {
		return forkEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLoop() {
		return loopEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLoop_LlCondition() {
		return (EReference)loopEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEventHandler() {
		return eventHandlerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServiceInteraction() {
		return serviceInteractionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceInteraction_Operation() {
		return (EReference)serviceInteractionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceInteraction_RcvParameters() {
		return (EReference)serviceInteractionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceInteraction_SndParameters() {
		return (EReference)serviceInteractionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceInteraction_Partner() {
		return (EReference)serviceInteractionEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getThrow() {
		return throwEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getThrow_Fault() {
		return (EReference)throwEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getThrow_FaultName() {
		return (EAttribute)throwEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCompositeElement() {
		return compositeElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCompositeElement_Children() {
		return (EReference)compositeElementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPick() {
		return pickEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getReply() {
		return replyEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDataHandling() {
		return dataHandlingEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDataHandling_Statements() {
		return (EReference)dataHandlingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExpression() {
		return expressionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExpression_Type() {
		return (EReference)expressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getField() {
		return fieldEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getField_Parent() {
		return (EReference)fieldEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getField_Name() {
		return (EAttribute)fieldEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAssignment() {
		return assignmentEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAssignment_Target() {
		return (EReference)assignmentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAssignment_Source() {
		return (EReference)assignmentEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDeclaration() {
		return declarationEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDeclaration_DeclaredVar() {
		return (EReference)declarationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStatement() {
		return statementEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLiteral() {
		return literalEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLiteral_Value() {
		return (EAttribute)literalEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOperation() {
		return operationEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOperation_Operands() {
		return (EReference)operationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOperation_OperationType() {
		return (EAttribute)operationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLeftHandSideExpression() {
		return leftHandSideExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRightHandSideExpression() {
		return rightHandSideExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServiceInterface() {
		return serviceInterfaceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceInterface_Used() {
		return (EReference)serviceInterfaceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceInterface_Implemented() {
		return (EReference)serviceInterfaceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServicePoint() {
		return servicePointEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRequestPoint() {
		return requestPointEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServiceOperationParameter() {
		return serviceOperationParameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServiceOperationParameter_Name() {
		return (EAttribute)serviceOperationParameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceOperationParameter_Type() {
		return (EReference)serviceOperationParameterEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceOperationParameter_Operation() {
		return (EReference)serviceOperationParameterEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getInParameter() {
		return inParameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOutParameter() {
		return outParameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getInteractionParameter() {
		return interactionParameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getInteractionParameter_OperationParameter() {
		return (EReference)interactionParameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getReceiveParameter() {
		return receiveParameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getReceiveParameter_Target() {
		return (EReference)receiveParameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSendParameter() {
		return sendParameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSendParameter_Source() {
		return (EReference)sendParameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTerminate() {
		return terminateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getParticipant() {
		return participantEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getParticipant_Partners() {
		return (EReference)participantEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getParticipant_Behaviours() {
		return (EReference)participantEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getParticipant_Name() {
		return (EAttribute)participantEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getParticipant_RootPackage() {
		return (EReference)participantEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getOperationType() {
		return operationTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public IOMFactory getIOMFactory() {
		return (IOMFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated= false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		serviceElementEClass = createEClass(SERVICE_ELEMENT);
		createEAttribute(serviceElementEClass, SERVICE_ELEMENT__NAME);
		createEReference(serviceElementEClass, SERVICE_ELEMENT__PARENT);

		partnerPointEClass = createEClass(PARTNER_POINT);
		createEAttribute(partnerPointEClass, PARTNER_POINT__NAME);
		createEReference(partnerPointEClass, PARTNER_POINT__INTERFACE);

		variableEClass = createEClass(VARIABLE);
		createEAttribute(variableEClass, VARIABLE__NAME);
		createEReference(variableEClass, VARIABLE__SCOPE);

		serviceOperationEClass = createEClass(SERVICE_OPERATION);
		createEReference(serviceOperationEClass, SERVICE_OPERATION__USED_IN);
		createEReference(serviceOperationEClass, SERVICE_OPERATION__PARAMETERS);
		createEAttribute(serviceOperationEClass, SERVICE_OPERATION__NAME);

		simpleElementEClass = createEClass(SIMPLE_ELEMENT);

		serviceActivityEClass = createEClass(SERVICE_ACTIVITY);
		createEReference(serviceActivityEClass, SERVICE_ACTIVITY__VARIABLES);
		createEReference(serviceActivityEClass, SERVICE_ACTIVITY__HANDLERS);
		createEReference(serviceActivityEClass, SERVICE_ACTIVITY__INTERRUPTING_RECEIVES);

		handlerEClass = createEClass(HANDLER);
		createEReference(handlerEClass, HANDLER__PARAMETER);

		sendEClass = createEClass(SEND);

		receiveEClass = createEClass(RECEIVE);
		createEReference(receiveEClass, RECEIVE__INTERRUPTS);

		sendAndReceiveEClass = createEClass(SEND_AND_RECEIVE);

		receiveAndReplyEClass = createEClass(RECEIVE_AND_REPLY);

		compensateAllEClass = createEClass(COMPENSATE_ALL);

		compensateEClass = createEClass(COMPENSATE);
		createEReference(compensateEClass, COMPENSATE__SERVICE_ACTIVITY);

		exceptionHandlerEClass = createEClass(EXCEPTION_HANDLER);
		createEAttribute(exceptionHandlerEClass, EXCEPTION_HANDLER__FAULT_NAME);

		compensationHandlerEClass = createEClass(COMPENSATION_HANDLER);

		pathBasedPartitionEClass = createEClass(PATH_BASED_PARTITION);
		createEReference(pathBasedPartitionEClass, PATH_BASED_PARTITION__PATHS);

		pathEClass = createEClass(PATH);
		createEReference(pathEClass, PATH__CONDITION);

		decisionEClass = createEClass(DECISION);

		forkEClass = createEClass(FORK);

		loopEClass = createEClass(LOOP);
		createEReference(loopEClass, LOOP__LL_CONDITION);

		eventHandlerEClass = createEClass(EVENT_HANDLER);

		serviceInteractionEClass = createEClass(SERVICE_INTERACTION);
		createEReference(serviceInteractionEClass, SERVICE_INTERACTION__OPERATION);
		createEReference(serviceInteractionEClass, SERVICE_INTERACTION__RCV_PARAMETERS);
		createEReference(serviceInteractionEClass, SERVICE_INTERACTION__SND_PARAMETERS);
		createEReference(serviceInteractionEClass, SERVICE_INTERACTION__PARTNER);

		throwEClass = createEClass(THROW);
		createEReference(throwEClass, THROW__FAULT);
		createEAttribute(throwEClass, THROW__FAULT_NAME);

		compositeElementEClass = createEClass(COMPOSITE_ELEMENT);
		createEReference(compositeElementEClass, COMPOSITE_ELEMENT__CHILDREN);

		pickEClass = createEClass(PICK);

		replyEClass = createEClass(REPLY);

		dataHandlingEClass = createEClass(DATA_HANDLING);
		createEReference(dataHandlingEClass, DATA_HANDLING__STATEMENTS);

		expressionEClass = createEClass(EXPRESSION);
		createEReference(expressionEClass, EXPRESSION__TYPE);

		fieldEClass = createEClass(FIELD);
		createEReference(fieldEClass, FIELD__PARENT);
		createEAttribute(fieldEClass, FIELD__NAME);

		assignmentEClass = createEClass(ASSIGNMENT);
		createEReference(assignmentEClass, ASSIGNMENT__TARGET);
		createEReference(assignmentEClass, ASSIGNMENT__SOURCE);

		declarationEClass = createEClass(DECLARATION);
		createEReference(declarationEClass, DECLARATION__DECLARED_VAR);

		statementEClass = createEClass(STATEMENT);

		literalEClass = createEClass(LITERAL);
		createEAttribute(literalEClass, LITERAL__VALUE);

		operationEClass = createEClass(OPERATION);
		createEReference(operationEClass, OPERATION__OPERANDS);
		createEAttribute(operationEClass, OPERATION__OPERATION_TYPE);

		leftHandSideExpressionEClass = createEClass(LEFT_HAND_SIDE_EXPRESSION);

		rightHandSideExpressionEClass = createEClass(RIGHT_HAND_SIDE_EXPRESSION);

		serviceInterfaceEClass = createEClass(SERVICE_INTERFACE);
		createEReference(serviceInterfaceEClass, SERVICE_INTERFACE__USED);
		createEReference(serviceInterfaceEClass, SERVICE_INTERFACE__IMPLEMENTED);

		servicePointEClass = createEClass(SERVICE_POINT);

		requestPointEClass = createEClass(REQUEST_POINT);

		serviceOperationParameterEClass = createEClass(SERVICE_OPERATION_PARAMETER);
		createEAttribute(serviceOperationParameterEClass, SERVICE_OPERATION_PARAMETER__NAME);
		createEReference(serviceOperationParameterEClass, SERVICE_OPERATION_PARAMETER__TYPE);
		createEReference(serviceOperationParameterEClass, SERVICE_OPERATION_PARAMETER__OPERATION);

		inParameterEClass = createEClass(IN_PARAMETER);

		outParameterEClass = createEClass(OUT_PARAMETER);

		interactionParameterEClass = createEClass(INTERACTION_PARAMETER);
		createEReference(interactionParameterEClass, INTERACTION_PARAMETER__OPERATION_PARAMETER);

		receiveParameterEClass = createEClass(RECEIVE_PARAMETER);
		createEReference(receiveParameterEClass, RECEIVE_PARAMETER__TARGET);

		sendParameterEClass = createEClass(SEND_PARAMETER);
		createEReference(sendParameterEClass, SEND_PARAMETER__SOURCE);

		terminateEClass = createEClass(TERMINATE);

		participantEClass = createEClass(PARTICIPANT);
		createEReference(participantEClass, PARTICIPANT__PARTNERS);
		createEReference(participantEClass, PARTICIPANT__BEHAVIOURS);
		createEAttribute(participantEClass, PARTICIPANT__NAME);
		createEReference(participantEClass, PARTICIPANT__ROOT_PACKAGE);

		// Create enums
		operationTypeEEnum = createEEnum(OPERATION_TYPE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized= false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		TypePackage theTypePackage = (TypePackage)EPackage.Registry.INSTANCE.getEPackage(TypePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		variableEClass.getESuperTypes().add(this.getLeftHandSideExpression());
		simpleElementEClass.getESuperTypes().add(this.getServiceElement());
		serviceActivityEClass.getESuperTypes().add(this.getCompositeElement());
		handlerEClass.getESuperTypes().add(this.getCompositeElement());
		sendEClass.getESuperTypes().add(this.getServiceInteraction());
		receiveEClass.getESuperTypes().add(this.getServiceInteraction());
		sendAndReceiveEClass.getESuperTypes().add(this.getSend());
		sendAndReceiveEClass.getESuperTypes().add(this.getReceive());
		receiveAndReplyEClass.getESuperTypes().add(this.getReceive());
		receiveAndReplyEClass.getESuperTypes().add(this.getReply());
		compensateAllEClass.getESuperTypes().add(this.getSimpleElement());
		compensateEClass.getESuperTypes().add(this.getSimpleElement());
		exceptionHandlerEClass.getESuperTypes().add(this.getHandler());
		compensationHandlerEClass.getESuperTypes().add(this.getHandler());
		pathBasedPartitionEClass.getESuperTypes().add(this.getCompositeElement());
		pathEClass.getESuperTypes().add(this.getCompositeElement());
		decisionEClass.getESuperTypes().add(this.getPathBasedPartition());
		forkEClass.getESuperTypes().add(this.getPathBasedPartition());
		loopEClass.getESuperTypes().add(this.getPathBasedPartition());
		eventHandlerEClass.getESuperTypes().add(this.getHandler());
		serviceInteractionEClass.getESuperTypes().add(this.getSimpleElement());
		throwEClass.getESuperTypes().add(this.getSimpleElement());
		compositeElementEClass.getESuperTypes().add(this.getServiceElement());
		pickEClass.getESuperTypes().add(this.getPathBasedPartition());
		replyEClass.getESuperTypes().add(this.getServiceInteraction());
		dataHandlingEClass.getESuperTypes().add(this.getSimpleElement());
		fieldEClass.getESuperTypes().add(this.getLeftHandSideExpression());
		assignmentEClass.getESuperTypes().add(this.getStatement());
		declarationEClass.getESuperTypes().add(this.getStatement());
		literalEClass.getESuperTypes().add(this.getRightHandSideExpression());
		operationEClass.getESuperTypes().add(this.getRightHandSideExpression());
		leftHandSideExpressionEClass.getESuperTypes().add(this.getRightHandSideExpression());
		rightHandSideExpressionEClass.getESuperTypes().add(this.getExpression());
		serviceInterfaceEClass.getESuperTypes().add(theTypePackage.getType());
		servicePointEClass.getESuperTypes().add(this.getPartnerPoint());
		requestPointEClass.getESuperTypes().add(this.getPartnerPoint());
		inParameterEClass.getESuperTypes().add(this.getServiceOperationParameter());
		outParameterEClass.getESuperTypes().add(this.getServiceOperationParameter());
		receiveParameterEClass.getESuperTypes().add(this.getInteractionParameter());
		sendParameterEClass.getESuperTypes().add(this.getInteractionParameter());
		terminateEClass.getESuperTypes().add(this.getSimpleElement());

		// Initialize classes and features; add operations and parameters
		initEClass(serviceElementEClass, ServiceElement.class, "ServiceElement", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getServiceElement_Name(), ecorePackage.getEString(), "name", null, 0, 1, ServiceElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceElement_Parent(), this.getCompositeElement(), null, "parent", null, 0, 1, ServiceElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(serviceElementEClass, this.getServiceActivity(), "getCurrentScope", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(partnerPointEClass, PartnerPoint.class, "PartnerPoint", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPartnerPoint_Name(), ecorePackage.getEString(), "name", null, 0, 1, PartnerPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPartnerPoint_Interface(), this.getServiceInterface(), null, "interface", null, 0, 1, PartnerPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(variableEClass, Variable.class, "Variable", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getVariable_Name(), ecorePackage.getEString(), "name", null, 0, 1, Variable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVariable_Scope(), this.getServiceActivity(), this.getServiceActivity_Variables(), "scope", null, 1, 1, Variable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(serviceOperationEClass, ServiceOperation.class, "ServiceOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceOperation_UsedIn(), this.getServiceInteraction(), this.getServiceInteraction_Operation(), "usedIn", null, 0, -1, ServiceOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceOperation_Parameters(), this.getServiceOperationParameter(), this.getServiceOperationParameter_Operation(), "parameters", null, 0, -1, ServiceOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServiceOperation_Name(), ecorePackage.getEString(), "name", null, 0, 1, ServiceOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(simpleElementEClass, SimpleElement.class, "SimpleElement", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(serviceActivityEClass, ServiceActivity.class, "ServiceActivity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceActivity_Variables(), this.getVariable(), this.getVariable_Scope(), "variables", null, 0, -1, ServiceActivity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceActivity_Handlers(), this.getHandler(), null, "handlers", null, 0, -1, ServiceActivity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceActivity_InterruptingReceives(), this.getReceive(), this.getReceive_Interrupts(), "interruptingReceives", null, 0, -1, ServiceActivity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(handlerEClass, Handler.class, "Handler", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getHandler_Parameter(), this.getVariable(), null, "parameter", null, 0, 1, Handler.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(sendEClass, Send.class, "Send", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(receiveEClass, Receive.class, "Receive", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getReceive_Interrupts(), this.getServiceActivity(), this.getServiceActivity_InterruptingReceives(), "interrupts", null, 1, 1, Receive.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(sendAndReceiveEClass, SendAndReceive.class, "SendAndReceive", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(receiveAndReplyEClass, ReceiveAndReply.class, "ReceiveAndReply", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(compensateAllEClass, CompensateAll.class, "CompensateAll", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(compensateEClass, Compensate.class, "Compensate", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCompensate_ServiceActivity(), this.getServiceActivity(), null, "serviceActivity", null, 0, 1, Compensate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(exceptionHandlerEClass, ExceptionHandler.class, "ExceptionHandler", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getExceptionHandler_FaultName(), ecorePackage.getEString(), "faultName", null, 0, 1, ExceptionHandler.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(compensationHandlerEClass, CompensationHandler.class, "CompensationHandler", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(pathBasedPartitionEClass, PathBasedPartition.class, "PathBasedPartition", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPathBasedPartition_Paths(), this.getPath(), null, "paths", null, 0, -1, PathBasedPartition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(pathEClass, Path.class, "Path", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPath_Condition(), this.getExpression(), null, "condition", null, 0, 1, Path.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(decisionEClass, Decision.class, "Decision", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(forkEClass, Fork.class, "Fork", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(loopEClass, Loop.class, "Loop", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getLoop_LlCondition(), this.getExpression(), null, "llCondition", null, 0, 1, Loop.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(eventHandlerEClass, EventHandler.class, "EventHandler", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(serviceInteractionEClass, ServiceInteraction.class, "ServiceInteraction", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceInteraction_Operation(), this.getServiceOperation(), this.getServiceOperation_UsedIn(), "operation", null, 0, 1, ServiceInteraction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceInteraction_RcvParameters(), this.getInteractionParameter(), null, "rcvParameters", null, 0, -1, ServiceInteraction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceInteraction_SndParameters(), this.getInteractionParameter(), null, "sndParameters", null, 0, -1, ServiceInteraction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceInteraction_Partner(), this.getPartnerPoint(), null, "partner", null, 1, 1, ServiceInteraction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(throwEClass, Throw.class, "Throw", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getThrow_Fault(), this.getRightHandSideExpression(), null, "fault", null, 0, 1, Throw.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getThrow_FaultName(), ecorePackage.getEString(), "faultName", null, 0, 1, Throw.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(compositeElementEClass, CompositeElement.class, "CompositeElement", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCompositeElement_Children(), this.getServiceElement(), null, "children", null, 0, -1, CompositeElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(pickEClass, Pick.class, "Pick", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(replyEClass, Reply.class, "Reply", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(dataHandlingEClass, DataHandling.class, "DataHandling", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDataHandling_Statements(), this.getStatement(), null, "statements", null, 0, -1, DataHandling.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(expressionEClass, Expression.class, "Expression", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExpression_Type(), theTypePackage.getType(), null, "type", null, 0, 1, Expression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(fieldEClass, Field.class, "Field", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getField_Parent(), this.getLeftHandSideExpression(), null, "parent", null, 1, 1, Field.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getField_Name(), ecorePackage.getEString(), "name", null, 0, 1, Field.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(assignmentEClass, Assignment.class, "Assignment", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAssignment_Target(), this.getLeftHandSideExpression(), null, "target", null, 1, 1, Assignment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAssignment_Source(), this.getRightHandSideExpression(), null, "source", null, 1, 1, Assignment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(declarationEClass, Declaration.class, "Declaration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDeclaration_DeclaredVar(), this.getVariable(), null, "declaredVar", null, 1, 1, Declaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(statementEClass, Statement.class, "Statement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(literalEClass, Literal.class, "Literal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLiteral_Value(), ecorePackage.getEJavaObject(), "value", null, 0, 1, Literal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(operationEClass, Operation.class, "Operation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOperation_Operands(), this.getExpression(), null, "operands", null, 1, -1, Operation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOperation_OperationType(), this.getOperationType(), "operationType", null, 0, 1, Operation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(leftHandSideExpressionEClass, LeftHandSideExpression.class, "LeftHandSideExpression", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(leftHandSideExpressionEClass, this.getVariable(), "getVariable", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(rightHandSideExpressionEClass, RightHandSideExpression.class, "RightHandSideExpression", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(serviceInterfaceEClass, ServiceInterface.class, "ServiceInterface", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceInterface_Used(), this.getServiceOperation(), null, "used", null, 0, -1, ServiceInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceInterface_Implemented(), this.getServiceOperation(), null, "implemented", null, 0, -1, ServiceInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(servicePointEClass, ServicePoint.class, "ServicePoint", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(requestPointEClass, RequestPoint.class, "RequestPoint", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(serviceOperationParameterEClass, ServiceOperationParameter.class, "ServiceOperationParameter", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getServiceOperationParameter_Name(), ecorePackage.getEString(), "name", null, 0, 1, ServiceOperationParameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceOperationParameter_Type(), theTypePackage.getType(), null, "type", null, 1, 1, ServiceOperationParameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceOperationParameter_Operation(), this.getServiceOperation(), this.getServiceOperation_Parameters(), "operation", null, 1, 1, ServiceOperationParameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(inParameterEClass, InParameter.class, "InParameter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(outParameterEClass, OutParameter.class, "OutParameter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(interactionParameterEClass, InteractionParameter.class, "InteractionParameter", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getInteractionParameter_OperationParameter(), this.getServiceOperationParameter(), null, "operationParameter", null, 1, 1, InteractionParameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(receiveParameterEClass, ReceiveParameter.class, "ReceiveParameter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getReceiveParameter_Target(), this.getLeftHandSideExpression(), null, "target", null, 0, 1, ReceiveParameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(sendParameterEClass, SendParameter.class, "SendParameter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSendParameter_Source(), this.getRightHandSideExpression(), null, "source", null, 0, 1, SendParameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(terminateEClass, Terminate.class, "Terminate", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(participantEClass, Participant.class, "Participant", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getParticipant_Partners(), this.getPartnerPoint(), null, "partners", null, 0, -1, Participant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getParticipant_Behaviours(), this.getServiceActivity(), null, "behaviours", null, 0, -1, Participant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getParticipant_Name(), ecorePackage.getEString(), "name", null, 0, 1, Participant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getParticipant_RootPackage(), theTypePackage.getPackage(), null, "rootPackage", null, 0, 1, Participant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(operationTypeEEnum, OperationType.class, "OperationType");
		addEEnumLiteral(operationTypeEEnum, OperationType.ADDITION);
		addEEnumLiteral(operationTypeEEnum, OperationType.SUBTRACTION);
		addEEnumLiteral(operationTypeEEnum, OperationType.MULTIPLICATION);
		addEEnumLiteral(operationTypeEEnum, OperationType.DIVISION);
		addEEnumLiteral(operationTypeEEnum, OperationType.MODULO);
		addEEnumLiteral(operationTypeEEnum, OperationType.AND);
		addEEnumLiteral(operationTypeEEnum, OperationType.OR);
		addEEnumLiteral(operationTypeEEnum, OperationType.NOT);
		addEEnumLiteral(operationTypeEEnum, OperationType.NEGATION);
		addEEnumLiteral(operationTypeEEnum, OperationType.EQUALS);
		addEEnumLiteral(operationTypeEEnum, OperationType.GREATER);
		addEEnumLiteral(operationTypeEEnum, OperationType.GREATER_EQUAL);
		addEEnumLiteral(operationTypeEEnum, OperationType.LESS);
		addEEnumLiteral(operationTypeEEnum, OperationType.LESS_EQUAL);
		addEEnumLiteral(operationTypeEEnum, OperationType.NOT_EQUALS);

		// Create resource
		createResource(eNS_URI);
	}

} // IOMPackageImpl
