/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import de.lmu.ifi.pst.mdd4soa.transform.exception.TransformationException;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OperationType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Operation</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OperationImpl#getOperands <em>Operands</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.OperationImpl#getOperationType <em>Operation Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OperationImpl extends RightHandSideExpressionImpl implements Operation {
	/**
	 * The cached value of the '{@link #getOperands() <em>Operands</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getOperands()
	 * @generated
	 * @ordered
	 */
	protected EList<Expression> operands;

	/**
	 * The default value of the '{@link #getOperationType() <em>Operation Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getOperationType()
	 * @generated
	 * @ordered
	 */
	protected static final OperationType OPERATION_TYPE_EDEFAULT= OperationType.ADDITION;

	/**
	 * The cached value of the '{@link #getOperationType() <em>Operation Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getOperationType()
	 * @generated
	 * @ordered
	 */
	protected OperationType operationType= OPERATION_TYPE_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IOMPackage.Literals.OPERATION;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Expression> getOperands() {
		if (operands == null) {
			operands = new EObjectResolvingEList<Expression>(Expression.class, this, IOMPackage.OPERATION__OPERANDS);
		}
		return operands;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public OperationType getOperationType() {
		return operationType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperationType(OperationType newOperationType) {
		OperationType oldOperationType = operationType;
		operationType = newOperationType == null ? OPERATION_TYPE_EDEFAULT : newOperationType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IOMPackage.OPERATION__OPERATION_TYPE, oldOperationType, operationType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IOMPackage.OPERATION__OPERANDS:
				return getOperands();
			case IOMPackage.OPERATION__OPERATION_TYPE:
				return getOperationType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IOMPackage.OPERATION__OPERANDS:
				getOperands().clear();
				getOperands().addAll((Collection<? extends Expression>)newValue);
				return;
			case IOMPackage.OPERATION__OPERATION_TYPE:
				setOperationType((OperationType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IOMPackage.OPERATION__OPERANDS:
				getOperands().clear();
				return;
			case IOMPackage.OPERATION__OPERATION_TYPE:
				setOperationType(OPERATION_TYPE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IOMPackage.OPERATION__OPERANDS:
				return operands != null && !operands.isEmpty();
			case IOMPackage.OPERATION__OPERATION_TYPE:
				return operationType != OPERATION_TYPE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer();
		result.append("operation ").append(operationType.getLiteral());
		result.append(" of ( ");
		for (Expression operand : getOperands()) {
			result.append(operand.toString()).append(", ");
		}
		result.append(" ) ");
		return result.toString();
	}

	@Override
	public Type getType() throws TransformationException {
		return operationType.getResultType(operands);
	}
} // OperationImpl
