/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>ServiceActivity</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceActivityImpl#getVariables <em>Variables</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceActivityImpl#getHandlers <em>Handlers</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceActivityImpl#getInterruptingReceives <em>Interrupting Receives</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ServiceActivityImpl extends CompositeElementImpl implements ServiceActivity {
	/**
	 * The cached value of the '{@link #getVariables() <em>Variables</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<Variable> variables;

	/**
	 * The cached value of the '{@link #getHandlers() <em>Handlers</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getHandlers()
	 * @generated
	 * @ordered
	 */
	protected EList<Handler> handlers;

	/**
	 * The cached value of the '{@link #getInterruptingReceives() <em>Interrupting Receives</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterruptingReceives()
	 * @generated
	 * @ordered
	 */
	protected EList<Receive> interruptingReceives;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceActivityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IOMPackage.Literals.SERVICE_ACTIVITY;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Variable> getVariables() {
		if (variables == null) {
			variables = new EObjectContainmentWithInverseEList<Variable>(Variable.class, this, IOMPackage.SERVICE_ACTIVITY__VARIABLES, IOMPackage.VARIABLE__SCOPE);
		}
		return variables;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Handler> getHandlers() {
		if (handlers == null) {
			handlers = new EObjectContainmentEList<Handler>(Handler.class, this, IOMPackage.SERVICE_ACTIVITY__HANDLERS);
		}
		return handlers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Receive> getInterruptingReceives() {
		if (interruptingReceives == null) {
			interruptingReceives = new EObjectWithInverseResolvingEList<Receive>(Receive.class, this, IOMPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES, IOMPackage.RECEIVE__INTERRUPTS);
		}
		return interruptingReceives;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IOMPackage.SERVICE_ACTIVITY__VARIABLES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getVariables()).basicAdd(otherEnd, msgs);
			case IOMPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInterruptingReceives()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IOMPackage.SERVICE_ACTIVITY__VARIABLES:
				return ((InternalEList<?>)getVariables()).basicRemove(otherEnd, msgs);
			case IOMPackage.SERVICE_ACTIVITY__HANDLERS:
				return ((InternalEList<?>)getHandlers()).basicRemove(otherEnd, msgs);
			case IOMPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				return ((InternalEList<?>)getInterruptingReceives()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IOMPackage.SERVICE_ACTIVITY__VARIABLES:
				return getVariables();
			case IOMPackage.SERVICE_ACTIVITY__HANDLERS:
				return getHandlers();
			case IOMPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				return getInterruptingReceives();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IOMPackage.SERVICE_ACTIVITY__VARIABLES:
				getVariables().clear();
				getVariables().addAll((Collection<? extends Variable>)newValue);
				return;
			case IOMPackage.SERVICE_ACTIVITY__HANDLERS:
				getHandlers().clear();
				getHandlers().addAll((Collection<? extends Handler>)newValue);
				return;
			case IOMPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				getInterruptingReceives().clear();
				getInterruptingReceives().addAll((Collection<? extends Receive>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IOMPackage.SERVICE_ACTIVITY__VARIABLES:
				getVariables().clear();
				return;
			case IOMPackage.SERVICE_ACTIVITY__HANDLERS:
				getHandlers().clear();
				return;
			case IOMPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				getInterruptingReceives().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IOMPackage.SERVICE_ACTIVITY__VARIABLES:
				return variables != null && !variables.isEmpty();
			case IOMPackage.SERVICE_ACTIVITY__HANDLERS:
				return handlers != null && !handlers.isEmpty();
			case IOMPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				return interruptingReceives != null && !interruptingReceives.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} // ServiceActivityImpl
