/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Partner Interaction</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInteractionImpl#getOperation <em>Operation</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInteractionImpl#getRcvParameters <em>Rcv Parameters</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInteractionImpl#getSndParameters <em>Snd Parameters</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceInteractionImpl#getPartner <em>Partner</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class ServiceInteractionImpl extends SimpleElementImpl implements ServiceInteraction {
	/**
	 * The cached value of the '{@link #getOperation() <em>Operation</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getOperation()
	 * @generated
	 * @ordered
	 */
	protected ServiceOperation operation;

	/**
	 * The cached value of the '{@link #getRcvParameters() <em>Rcv Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRcvParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<InteractionParameter> rcvParameters;

	/**
	 * The cached value of the '{@link #getSndParameters() <em>Snd Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSndParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<InteractionParameter> sndParameters;

	/**
	 * The cached value of the '{@link #getPartner() <em>Partner</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPartner()
	 * @generated
	 * @ordered
	 */
	protected PartnerPoint partner;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceInteractionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IOMPackage.Literals.SERVICE_INTERACTION;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceOperation getOperation() {
		if (operation != null && operation.eIsProxy()) {
			InternalEObject oldOperation = (InternalEObject)operation;
			operation = (ServiceOperation)eResolveProxy(oldOperation);
			if (operation != oldOperation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IOMPackage.SERVICE_INTERACTION__OPERATION, oldOperation, operation));
			}
		}
		return operation;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceOperation basicGetOperation() {
		return operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOperation(ServiceOperation newOperation, NotificationChain msgs) {
		ServiceOperation oldOperation = operation;
		operation = newOperation;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IOMPackage.SERVICE_INTERACTION__OPERATION, oldOperation, newOperation);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperation(ServiceOperation newOperation) {
		if (newOperation != operation) {
			NotificationChain msgs = null;
			if (operation != null)
				msgs = ((InternalEObject)operation).eInverseRemove(this, IOMPackage.SERVICE_OPERATION__USED_IN, ServiceOperation.class, msgs);
			if (newOperation != null)
				msgs = ((InternalEObject)newOperation).eInverseAdd(this, IOMPackage.SERVICE_OPERATION__USED_IN, ServiceOperation.class, msgs);
			msgs = basicSetOperation(newOperation, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IOMPackage.SERVICE_INTERACTION__OPERATION, newOperation, newOperation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<InteractionParameter> getRcvParameters() {
		if (rcvParameters == null) {
			rcvParameters = new EObjectContainmentEList<InteractionParameter>(InteractionParameter.class, this, IOMPackage.SERVICE_INTERACTION__RCV_PARAMETERS);
		}
		return rcvParameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<InteractionParameter> getSndParameters() {
		if (sndParameters == null) {
			sndParameters = new EObjectContainmentEList<InteractionParameter>(InteractionParameter.class, this, IOMPackage.SERVICE_INTERACTION__SND_PARAMETERS);
		}
		return sndParameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PartnerPoint getPartner() {
		if (partner != null && partner.eIsProxy()) {
			InternalEObject oldPartner = (InternalEObject)partner;
			partner = (PartnerPoint)eResolveProxy(oldPartner);
			if (partner != oldPartner) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IOMPackage.SERVICE_INTERACTION__PARTNER, oldPartner, partner));
			}
		}
		return partner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PartnerPoint basicGetPartner() {
		return partner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPartner(PartnerPoint newPartner) {
		PartnerPoint oldPartner = partner;
		partner = newPartner;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IOMPackage.SERVICE_INTERACTION__PARTNER, oldPartner, partner));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IOMPackage.SERVICE_INTERACTION__OPERATION:
				if (operation != null)
					msgs = ((InternalEObject)operation).eInverseRemove(this, IOMPackage.SERVICE_OPERATION__USED_IN, ServiceOperation.class, msgs);
				return basicSetOperation((ServiceOperation)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IOMPackage.SERVICE_INTERACTION__OPERATION:
				return basicSetOperation(null, msgs);
			case IOMPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				return ((InternalEList<?>)getRcvParameters()).basicRemove(otherEnd, msgs);
			case IOMPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				return ((InternalEList<?>)getSndParameters()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IOMPackage.SERVICE_INTERACTION__OPERATION:
				if (resolve) return getOperation();
				return basicGetOperation();
			case IOMPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				return getRcvParameters();
			case IOMPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				return getSndParameters();
			case IOMPackage.SERVICE_INTERACTION__PARTNER:
				if (resolve) return getPartner();
				return basicGetPartner();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IOMPackage.SERVICE_INTERACTION__OPERATION:
				setOperation((ServiceOperation)newValue);
				return;
			case IOMPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				getRcvParameters().clear();
				getRcvParameters().addAll((Collection<? extends InteractionParameter>)newValue);
				return;
			case IOMPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				getSndParameters().clear();
				getSndParameters().addAll((Collection<? extends InteractionParameter>)newValue);
				return;
			case IOMPackage.SERVICE_INTERACTION__PARTNER:
				setPartner((PartnerPoint)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IOMPackage.SERVICE_INTERACTION__OPERATION:
				setOperation((ServiceOperation)null);
				return;
			case IOMPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				getRcvParameters().clear();
				return;
			case IOMPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				getSndParameters().clear();
				return;
			case IOMPackage.SERVICE_INTERACTION__PARTNER:
				setPartner((PartnerPoint)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IOMPackage.SERVICE_INTERACTION__OPERATION:
				return operation != null;
			case IOMPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				return rcvParameters != null && !rcvParameters.isEmpty();
			case IOMPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				return sndParameters != null && !sndParameters.isEmpty();
			case IOMPackage.SERVICE_INTERACTION__PARTNER:
				return partner != null;
		}
		return super.eIsSet(featureID);
	}

	@Override
	public List<InteractionParameter> getAllParameters() {
		List<InteractionParameter> allParams = new LinkedList<InteractionParameter>();
		allParams.addAll(getSndParameters());
		allParams.addAll(getRcvParameters());
		return allParams;
	}

	
} // ServiceInteractionImpl
