/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Service Operation</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationImpl#getUsedIn <em>Used In</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationImpl#getParameters <em>Parameters</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.impl.ServiceOperationImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ServiceOperationImpl extends EObjectImpl implements ServiceOperation {
	/**
	 * The cached value of the '{@link #getUsedIn() <em>Used In</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getUsedIn()
	 * @generated
	 * @ordered
	 */
	protected EList<ServiceInteraction> usedIn;

	/**
	 * The cached value of the '{@link #getParameters() <em>Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<ServiceOperationParameter> parameters;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT= null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name= NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceOperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IOMPackage.Literals.SERVICE_OPERATION;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IOMPackage.SERVICE_OPERATION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ServiceInteraction> getUsedIn() {
		if (usedIn == null) {
			usedIn = new EObjectWithInverseResolvingEList<ServiceInteraction>(ServiceInteraction.class, this, IOMPackage.SERVICE_OPERATION__USED_IN, IOMPackage.SERVICE_INTERACTION__OPERATION);
		}
		return usedIn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ServiceOperationParameter> getParameters() {
		if (parameters == null) {
			parameters = new EObjectContainmentWithInverseEList<ServiceOperationParameter>(ServiceOperationParameter.class, this, IOMPackage.SERVICE_OPERATION__PARAMETERS, IOMPackage.SERVICE_OPERATION_PARAMETER__OPERATION);
		}
		return parameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IOMPackage.SERVICE_OPERATION__USED_IN:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getUsedIn()).basicAdd(otherEnd, msgs);
			case IOMPackage.SERVICE_OPERATION__PARAMETERS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getParameters()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IOMPackage.SERVICE_OPERATION__USED_IN:
				return ((InternalEList<?>)getUsedIn()).basicRemove(otherEnd, msgs);
			case IOMPackage.SERVICE_OPERATION__PARAMETERS:
				return ((InternalEList<?>)getParameters()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IOMPackage.SERVICE_OPERATION__USED_IN:
				return getUsedIn();
			case IOMPackage.SERVICE_OPERATION__PARAMETERS:
				return getParameters();
			case IOMPackage.SERVICE_OPERATION__NAME:
				return getName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IOMPackage.SERVICE_OPERATION__USED_IN:
				getUsedIn().clear();
				getUsedIn().addAll((Collection<? extends ServiceInteraction>)newValue);
				return;
			case IOMPackage.SERVICE_OPERATION__PARAMETERS:
				getParameters().clear();
				getParameters().addAll((Collection<? extends ServiceOperationParameter>)newValue);
				return;
			case IOMPackage.SERVICE_OPERATION__NAME:
				setName((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IOMPackage.SERVICE_OPERATION__USED_IN:
				getUsedIn().clear();
				return;
			case IOMPackage.SERVICE_OPERATION__PARAMETERS:
				getParameters().clear();
				return;
			case IOMPackage.SERVICE_OPERATION__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IOMPackage.SERVICE_OPERATION__USED_IN:
				return usedIn != null && !usedIn.isEmpty();
			case IOMPackage.SERVICE_OPERATION__PARAMETERS:
				return parameters != null && !parameters.isEmpty();
			case IOMPackage.SERVICE_OPERATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}


//	public Type getSourceType() throws TransformationException {
//		Type type= null;
//		for (ServiceInteraction pi : usedIn) {
//			type= getType(type, pi.getSource());
//		}
//		return type;
//	}
//
//
//	public Type getTargetType() throws TransformationException {
//		Type type= null;
//		for (ServiceInteraction pi : usedIn) {
//			type= getType(type, pi.getTarget());
//		}
//		return type;
//	}

//	private Type getType(Type type, Expression e) throws TransformationException {
//		if (e != null && e.getType() != null) {
//			type= e.getType();
//		}
//		return type;
//	}
} // ServiceOperationImpl
