/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type;

import org.eclipse.emf.common.util.EList;


/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Package</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getReferencedTypes <em>Referenced Types</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getParent <em>Parent</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getChildren <em>Children</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getTypes <em>Types</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage#getPackage()
 * @model
 * @generated
 */
public interface Package extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Referenced Types</b></em>' containment reference list.
	 * The list contents are of type {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Referenced Types</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Referenced Types</em>' containment reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage#getPackage_ReferencedTypes()
	 * @model containment="true"
	 * @generated
	 */
	EList<Type> getReferencedTypes();

	/**
	 * Returns the value of the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Parent</em>' reference.
	 * @see #setParent(Package)
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage#getPackage_Parent()
	 * @model
	 * @generated
	 */
	Package getParent();

	/**
	 * Sets the value of the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getParent
	 * <em>Parent</em>}' reference. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value the new value of the '<em>Parent</em>' reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(Package value);

	/**
	 * Returns the value of the '<em><b>Children</b></em>' containment reference list.
	 * The list contents are of type {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package}.
	 * It is bidirectional and its opposite is '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Children</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Children</em>' containment reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage#getPackage_Children()
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getParent
	 * @model opposite="parent" containment="true"
	 * @generated
	 */
	EList<Package> getChildren();

	/**
	 * Returns the value of the '<em><b>Types</b></em>' containment reference list.
	 * The list contents are of type {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type}.
	 * It is bidirectional and its opposite is '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Types</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Types</em>' containment reference list.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage#getPackage_Types()
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type#getPackage
	 * @model opposite="package" containment="true"
	 * @generated
	 */
	EList<Type> getTypes();

} // Package
