/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Structure Type</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StructureTypeImpl#getAttributes <em>Attributes</em>}</li>
 *   <li>{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StructureTypeImpl#getSuperStructure <em>Super Structure</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class StructureTypeImpl extends TypeImpl implements StructureType {
	/**
	 * The cached value of the '{@link #getAttributes() <em>Attributes</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<Attribute> attributes;

	/**
	 * The cached value of the '{@link #getSuperStructure() <em>Super Structure</em>}' reference.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSuperStructure()
	 * @generated
	 * @ordered
	 */
	protected StructureType superStructure;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected StructureTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TypePackage.Literals.STRUCTURE_TYPE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Attribute> getAttributes() {
		if (attributes == null) {
			attributes = new EObjectContainmentEList<Attribute>(Attribute.class, this, TypePackage.STRUCTURE_TYPE__ATTRIBUTES);
		}
		return attributes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public StructureType getSuperStructure() {
		if (superStructure != null && superStructure.eIsProxy()) {
			InternalEObject oldSuperStructure = (InternalEObject)superStructure;
			superStructure = (StructureType)eResolveProxy(oldSuperStructure);
			if (superStructure != oldSuperStructure) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TypePackage.STRUCTURE_TYPE__SUPER_STRUCTURE, oldSuperStructure, superStructure));
			}
		}
		return superStructure;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public StructureType basicGetSuperStructure() {
		return superStructure;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setSuperStructure(StructureType newSuperStructure) {
		StructureType oldSuperStructure = superStructure;
		superStructure = newSuperStructure;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TypePackage.STRUCTURE_TYPE__SUPER_STRUCTURE, oldSuperStructure, superStructure));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TypePackage.STRUCTURE_TYPE__ATTRIBUTES:
				return ((InternalEList<?>)getAttributes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TypePackage.STRUCTURE_TYPE__ATTRIBUTES:
				return getAttributes();
			case TypePackage.STRUCTURE_TYPE__SUPER_STRUCTURE:
				if (resolve) return getSuperStructure();
				return basicGetSuperStructure();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TypePackage.STRUCTURE_TYPE__ATTRIBUTES:
				getAttributes().clear();
				getAttributes().addAll((Collection<? extends Attribute>)newValue);
				return;
			case TypePackage.STRUCTURE_TYPE__SUPER_STRUCTURE:
				setSuperStructure((StructureType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TypePackage.STRUCTURE_TYPE__ATTRIBUTES:
				getAttributes().clear();
				return;
			case TypePackage.STRUCTURE_TYPE__SUPER_STRUCTURE:
				setSuperStructure((StructureType)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TypePackage.STRUCTURE_TYPE__ATTRIBUTES:
				return attributes != null && !attributes.isEmpty();
			case TypePackage.STRUCTURE_TYPE__SUPER_STRUCTURE:
				return superStructure != null;
		}
		return super.eIsSet(featureID);
	}

	@Override
	public List<Attribute> getAllAttributes() {
		List<Attribute> returnedList = new LinkedList<Attribute>();
		
		Map<String,Attribute> allAvailableAttributes = new HashMap<String, Attribute>();
		
		addAttributesToMap(this,allAvailableAttributes);

		returnedList.addAll(allAvailableAttributes.values());
		
		return returnedList;
	}

	/**
	 * Only adds attributes to the map, if not already present.
	 * Recurse through super structures, to add inherited attributes, too.
	 * 
	 * @param structureType
	 * @param allAvailableAttributes
	 */
	private void addAttributesToMap(StructureType structureType, Map<String, Attribute> allAvailableAttributes) {
		for (Attribute a : structureType.getAttributes()){
			if (!allAvailableAttributes.containsKey(a.getIdentifier())){
				allAvailableAttributes.put(a.getIdentifier(), a);
			}
		}
		if (structureType.getSuperStructure()!= null){
			addAttributesToMap(structureType.getSuperStructure(), allAvailableAttributes);
		}
	}

} // StructureTypeImpl
