/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.BooleanType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.CollectionType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.DateType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.IntegerType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.ListType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NullType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.PrimitiveType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.RealType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.SetType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StringType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypePackage
 * @generated
 */
public class TypeAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static TypePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public TypeAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = TypePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TypeSwitch<Adapter> modelSwitch= new TypeSwitch<Adapter>() {
			@Override
			public Adapter caseNamedElement(NamedElement object) {
				return createNamedElementAdapter();
			}
			@Override
			public Adapter caseType(Type object) {
				return createTypeAdapter();
			}
			@Override
			public Adapter casePrimitiveType(PrimitiveType object) {
				return createPrimitiveTypeAdapter();
			}
			@Override
			public Adapter caseStringType(StringType object) {
				return createStringTypeAdapter();
			}
			@Override
			public Adapter caseBooleanType(BooleanType object) {
				return createBooleanTypeAdapter();
			}
			@Override
			public Adapter caseIntegerType(IntegerType object) {
				return createIntegerTypeAdapter();
			}
			@Override
			public Adapter caseRealType(RealType object) {
				return createRealTypeAdapter();
			}
			@Override
			public Adapter caseDateType(DateType object) {
				return createDateTypeAdapter();
			}
			@Override
			public Adapter casePackage(de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package object) {
				return createPackageAdapter();
			}
			@Override
			public Adapter caseStructureType(StructureType object) {
				return createStructureTypeAdapter();
			}
			@Override
			public Adapter caseAttribute(Attribute object) {
				return createAttributeAdapter();
			}
			@Override
			public Adapter caseCollectionType(CollectionType object) {
				return createCollectionTypeAdapter();
			}
			@Override
			public Adapter caseSetType(SetType object) {
				return createSetTypeAdapter();
			}
			@Override
			public Adapter caseListType(ListType object) {
				return createListTypeAdapter();
			}
			@Override
			public Adapter caseNullType(NullType object) {
				return createNullTypeAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement <em>Named Element</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement
	 * @generated
	 */
	public Adapter createNamedElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type <em>Type</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so
	 * that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type
	 * @generated
	 */
	public Adapter createTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.PrimitiveType <em>Primitive Type</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.PrimitiveType
	 * @generated
	 */
	public Adapter createPrimitiveTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StringType <em>String Type</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StringType
	 * @generated
	 */
	public Adapter createStringTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.BooleanType <em>Boolean Type</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.BooleanType
	 * @generated
	 */
	public Adapter createBooleanTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.IntegerType <em>Integer Type</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.IntegerType
	 * @generated
	 */
	public Adapter createIntegerTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.RealType
	 * <em>Real Type</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.RealType
	 * @generated
	 */
	public Adapter createRealTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.DateType
	 * <em>Date Type</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.DateType
	 * @generated
	 */
	public Adapter createDateTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package
	 * <em>Package</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package
	 * @generated
	 */
	public Adapter createPackageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType <em>Structure Type</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType
	 * @generated
	 */
	public Adapter createStructureTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute
	 * <em>Attribute</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute
	 * @generated
	 */
	public Adapter createAttributeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.CollectionType <em>Collection Type</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.CollectionType
	 * @generated
	 */
	public Adapter createCollectionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.SetType
	 * <em>Set Type</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.SetType
	 * @generated
	 */
	public Adapter createSetTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.ListType
	 * <em>List Type</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.ListType
	 * @generated
	 */
	public Adapter createListTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NullType
	 * <em>Null Type</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NullType
	 * @generated
	 */
	public Adapter createNullTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // TypeAdapterFactory
