/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.util;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.*;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensateAll;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensationHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Decision;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.EventHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Fork;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.LeftHandSideExpression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OutParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Pick;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveAndReply;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Reply;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RequestPoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RightHandSideExpression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Send;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendAndReceive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServicePoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SimpleElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Terminate;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage
 * @generated
 */
public class IOMAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static IOMPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public IOMAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = IOMPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IOMSwitch<Adapter> modelSwitch= new IOMSwitch<Adapter>() {
			@Override
			public Adapter caseServiceElement(ServiceElement object) {
				return createServiceElementAdapter();
			}
			@Override
			public Adapter casePartnerPoint(PartnerPoint object) {
				return createPartnerPointAdapter();
			}
			@Override
			public Adapter caseVariable(Variable object) {
				return createVariableAdapter();
			}
			@Override
			public Adapter caseServiceOperation(ServiceOperation object) {
				return createServiceOperationAdapter();
			}
			@Override
			public Adapter caseSimpleElement(SimpleElement object) {
				return createSimpleElementAdapter();
			}
			@Override
			public Adapter caseServiceActivity(ServiceActivity object) {
				return createServiceActivityAdapter();
			}
			@Override
			public Adapter caseHandler(Handler object) {
				return createHandlerAdapter();
			}
			@Override
			public Adapter caseSend(Send object) {
				return createSendAdapter();
			}
			@Override
			public Adapter caseReceive(Receive object) {
				return createReceiveAdapter();
			}
			@Override
			public Adapter caseSendAndReceive(SendAndReceive object) {
				return createSendAndReceiveAdapter();
			}
			@Override
			public Adapter caseReceiveAndReply(ReceiveAndReply object) {
				return createReceiveAndReplyAdapter();
			}
			@Override
			public Adapter caseCompensateAll(CompensateAll object) {
				return createCompensateAllAdapter();
			}
			@Override
			public Adapter caseCompensate(Compensate object) {
				return createCompensateAdapter();
			}
			@Override
			public Adapter caseExceptionHandler(ExceptionHandler object) {
				return createExceptionHandlerAdapter();
			}
			@Override
			public Adapter caseCompensationHandler(CompensationHandler object) {
				return createCompensationHandlerAdapter();
			}
			@Override
			public Adapter casePathBasedPartition(PathBasedPartition object) {
				return createPathBasedPartitionAdapter();
			}
			@Override
			public Adapter casePath(Path object) {
				return createPathAdapter();
			}
			@Override
			public Adapter caseDecision(Decision object) {
				return createDecisionAdapter();
			}
			@Override
			public Adapter caseFork(Fork object) {
				return createForkAdapter();
			}
			@Override
			public Adapter caseLoop(Loop object) {
				return createLoopAdapter();
			}
			@Override
			public Adapter caseEventHandler(EventHandler object) {
				return createEventHandlerAdapter();
			}
			@Override
			public Adapter caseServiceInteraction(ServiceInteraction object) {
				return createServiceInteractionAdapter();
			}
			@Override
			public Adapter caseThrow(Throw object) {
				return createThrowAdapter();
			}
			@Override
			public Adapter caseCompositeElement(CompositeElement object) {
				return createCompositeElementAdapter();
			}
			@Override
			public Adapter casePick(Pick object) {
				return createPickAdapter();
			}
			@Override
			public Adapter caseReply(Reply object) {
				return createReplyAdapter();
			}
			@Override
			public Adapter caseDataHandling(DataHandling object) {
				return createDataHandlingAdapter();
			}
			@Override
			public Adapter caseExpression(Expression object) {
				return createExpressionAdapter();
			}
			@Override
			public Adapter caseField(Field object) {
				return createFieldAdapter();
			}
			@Override
			public Adapter caseAssignment(Assignment object) {
				return createAssignmentAdapter();
			}
			@Override
			public Adapter caseDeclaration(Declaration object) {
				return createDeclarationAdapter();
			}
			@Override
			public Adapter caseStatement(Statement object) {
				return createStatementAdapter();
			}
			@Override
			public Adapter caseLiteral(Literal object) {
				return createLiteralAdapter();
			}
			@Override
			public Adapter caseOperation(Operation object) {
				return createOperationAdapter();
			}
			@Override
			public Adapter caseLeftHandSideExpression(LeftHandSideExpression object) {
				return createLeftHandSideExpressionAdapter();
			}
			@Override
			public Adapter caseRightHandSideExpression(RightHandSideExpression object) {
				return createRightHandSideExpressionAdapter();
			}
			@Override
			public Adapter caseServiceInterface(ServiceInterface object) {
				return createServiceInterfaceAdapter();
			}
			@Override
			public Adapter caseServicePoint(ServicePoint object) {
				return createServicePointAdapter();
			}
			@Override
			public Adapter caseRequestPoint(RequestPoint object) {
				return createRequestPointAdapter();
			}
			@Override
			public Adapter caseServiceOperationParameter(ServiceOperationParameter object) {
				return createServiceOperationParameterAdapter();
			}
			@Override
			public Adapter caseInParameter(InParameter object) {
				return createInParameterAdapter();
			}
			@Override
			public Adapter caseOutParameter(OutParameter object) {
				return createOutParameterAdapter();
			}
			@Override
			public Adapter caseInteractionParameter(InteractionParameter object) {
				return createInteractionParameterAdapter();
			}
			@Override
			public Adapter caseReceiveParameter(ReceiveParameter object) {
				return createReceiveParameterAdapter();
			}
			@Override
			public Adapter caseSendParameter(SendParameter object) {
				return createSendParameterAdapter();
			}
			@Override
			public Adapter caseTerminate(Terminate object) {
				return createTerminateAdapter();
			}
			@Override
			public Adapter caseParticipant(Participant object) {
				return createParticipantAdapter();
			}
			@Override
			public Adapter caseNamedElement(NamedElement object) {
				return createNamedElementAdapter();
			}
			@Override
			public Adapter caseType(Type object) {
				return createTypeAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement <em>Service Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement
	 * @generated
	 */
	public Adapter createServiceElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint <em>Partner Point</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint
	 * @generated
	 */
	public Adapter createPartnerPointAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable
	 * <em>Variable</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable
	 * @generated
	 */
	public Adapter createVariableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation <em>Service Operation</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation
	 * @generated
	 */
	public Adapter createServiceOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SimpleElement <em>Simple Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SimpleElement
	 * @generated
	 */
	public Adapter createSimpleElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity <em>Service Activity</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity
	 * @generated
	 */
	public Adapter createServiceActivityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler
	 * <em>Handler</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler
	 * @generated
	 */
	public Adapter createHandlerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Send <em>Send</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Send
	 * @generated
	 */
	public Adapter createSendAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive
	 * <em>Receive</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive
	 * @generated
	 */
	public Adapter createReceiveAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendAndReceive <em>Send And Receive</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendAndReceive
	 * @generated
	 */
	public Adapter createSendAndReceiveAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveAndReply <em>Receive And Reply</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveAndReply
	 * @generated
	 */
	public Adapter createReceiveAndReplyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensateAll <em>Compensate All</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensateAll
	 * @generated
	 */
	public Adapter createCompensateAllAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate <em>Compensate</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate
	 * @generated
	 */
	public Adapter createCompensateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler <em>Exception Handler</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler
	 * @generated
	 */
	public Adapter createExceptionHandlerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensationHandler <em>Compensation Handler</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensationHandler
	 * @generated
	 */
	public Adapter createCompensationHandlerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition <em>Path Based Partition</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition
	 * @generated
	 */
	public Adapter createPathBasedPartitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path <em>Path</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path
	 * @generated
	 */
	public Adapter createPathAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Decision <em>Decision</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Decision
	 * @generated
	 */
	public Adapter createDecisionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Fork <em>Fork</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Fork
	 * @generated
	 */
	public Adapter createForkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop <em>Loop</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop
	 * @generated
	 */
	public Adapter createLoopAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.EventHandler <em>Event Handler</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.EventHandler
	 * @generated
	 */
	public Adapter createEventHandlerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction <em>Service Interaction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction
	 * @generated
	 */
	public Adapter createServiceInteractionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw <em>Throw</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw
	 * @generated
	 */
	public Adapter createThrowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement <em>Composite Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement
	 * @generated
	 */
	public Adapter createCompositeElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Pick <em>Pick</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Pick
	 * @generated
	 */
	public Adapter createPickAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Reply <em>Reply</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Reply
	 * @generated
	 */
	public Adapter createReplyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling <em>Data Handling</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling
	 * @generated
	 */
	public Adapter createDataHandlingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression
	 * @generated
	 */
	public Adapter createExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field <em>Field</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field
	 * @generated
	 */
	public Adapter createFieldAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment <em>Assignment</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment
	 * @generated
	 */
	public Adapter createAssignmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration <em>Declaration</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration
	 * @generated
	 */
	public Adapter createDeclarationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement
	 * <em>Statement</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement
	 * @generated
	 */
	public Adapter createStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal
	 * <em>Literal</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal
	 * @generated
	 */
	public Adapter createLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation
	 * <em>Operation</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation
	 * @generated
	 */
	public Adapter createOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.LeftHandSideExpression <em>Left Hand Side Expression</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.LeftHandSideExpression
	 * @generated
	 */
	public Adapter createLeftHandSideExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RightHandSideExpression <em>Right Hand Side Expression</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RightHandSideExpression
	 * @generated
	 */
	public Adapter createRightHandSideExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface <em>Service Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface
	 * @generated
	 */
	public Adapter createServiceInterfaceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServicePoint <em>Service Point</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServicePoint
	 * @generated
	 */
	public Adapter createServicePointAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RequestPoint <em>Request Point</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RequestPoint
	 * @generated
	 */
	public Adapter createRequestPointAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter <em>Service Operation Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter
	 * @generated
	 */
	public Adapter createServiceOperationParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InParameter <em>In Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InParameter
	 * @generated
	 */
	public Adapter createInParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OutParameter <em>Out Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OutParameter
	 * @generated
	 */
	public Adapter createOutParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter <em>Interaction Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter
	 * @generated
	 */
	public Adapter createInteractionParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter <em>Receive Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter
	 * @generated
	 */
	public Adapter createReceiveParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter <em>Send Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter
	 * @generated
	 */
	public Adapter createSendParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Terminate <em>Terminate</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Terminate
	 * @generated
	 */
	public Adapter createTerminateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant <em>Participant</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant
	 * @generated
	 */
	public Adapter createParticipantAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement <em>Named Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement
	 * @generated
	 */
	public Adapter createNamedElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type
	 * @generated
	 */
	public Adapter createTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // IOMAdapterFactory
