/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.util;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.*;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Assignment;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Compensate;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensateAll;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompensationHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.CompositeElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.DataHandling;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Decision;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Declaration;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.EventHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ExceptionHandler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Expression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Field;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Fork;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Handler;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.InteractionParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.LeftHandSideExpression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Literal;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Loop;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Operation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.OutParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Participant;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PartnerPoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Path;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.PathBasedPartition;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Pick;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Receive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveAndReply;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ReceiveParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Reply;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RequestPoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.RightHandSideExpression;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Send;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendAndReceive;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SendParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceActivity;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInteraction;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceInterface;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperation;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServiceOperationParameter;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.ServicePoint;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.SimpleElement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Statement;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Terminate;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Throw;
import de.lmu.ifi.pst.mdd4soa.transform.impl.iom.Variable;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.IOMPackage
 * @generated
 */
public class IOMSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static IOMPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public IOMSwitch() {
		if (modelPackage == null) {
			modelPackage = IOMPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case IOMPackage.SERVICE_ELEMENT: {
				ServiceElement serviceElement = (ServiceElement)theEObject;
				T result = caseServiceElement(serviceElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.PARTNER_POINT: {
				PartnerPoint partnerPoint = (PartnerPoint)theEObject;
				T result = casePartnerPoint(partnerPoint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.VARIABLE: {
				Variable variable = (Variable)theEObject;
				T result = caseVariable(variable);
				if (result == null) result = caseLeftHandSideExpression(variable);
				if (result == null) result = caseRightHandSideExpression(variable);
				if (result == null) result = caseExpression(variable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SERVICE_OPERATION: {
				ServiceOperation serviceOperation = (ServiceOperation)theEObject;
				T result = caseServiceOperation(serviceOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SIMPLE_ELEMENT: {
				SimpleElement simpleElement = (SimpleElement)theEObject;
				T result = caseSimpleElement(simpleElement);
				if (result == null) result = caseServiceElement(simpleElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SERVICE_ACTIVITY: {
				ServiceActivity serviceActivity = (ServiceActivity)theEObject;
				T result = caseServiceActivity(serviceActivity);
				if (result == null) result = caseCompositeElement(serviceActivity);
				if (result == null) result = caseServiceElement(serviceActivity);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.HANDLER: {
				Handler handler = (Handler)theEObject;
				T result = caseHandler(handler);
				if (result == null) result = caseCompositeElement(handler);
				if (result == null) result = caseServiceElement(handler);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SEND: {
				Send send = (Send)theEObject;
				T result = caseSend(send);
				if (result == null) result = caseServiceInteraction(send);
				if (result == null) result = caseSimpleElement(send);
				if (result == null) result = caseServiceElement(send);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.RECEIVE: {
				Receive receive = (Receive)theEObject;
				T result = caseReceive(receive);
				if (result == null) result = caseServiceInteraction(receive);
				if (result == null) result = caseSimpleElement(receive);
				if (result == null) result = caseServiceElement(receive);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SEND_AND_RECEIVE: {
				SendAndReceive sendAndReceive = (SendAndReceive)theEObject;
				T result = caseSendAndReceive(sendAndReceive);
				if (result == null) result = caseSend(sendAndReceive);
				if (result == null) result = caseReceive(sendAndReceive);
				if (result == null) result = caseServiceInteraction(sendAndReceive);
				if (result == null) result = caseSimpleElement(sendAndReceive);
				if (result == null) result = caseServiceElement(sendAndReceive);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.RECEIVE_AND_REPLY: {
				ReceiveAndReply receiveAndReply = (ReceiveAndReply)theEObject;
				T result = caseReceiveAndReply(receiveAndReply);
				if (result == null) result = caseReceive(receiveAndReply);
				if (result == null) result = caseReply(receiveAndReply);
				if (result == null) result = caseServiceInteraction(receiveAndReply);
				if (result == null) result = caseSimpleElement(receiveAndReply);
				if (result == null) result = caseServiceElement(receiveAndReply);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.COMPENSATE_ALL: {
				CompensateAll compensateAll = (CompensateAll)theEObject;
				T result = caseCompensateAll(compensateAll);
				if (result == null) result = caseSimpleElement(compensateAll);
				if (result == null) result = caseServiceElement(compensateAll);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.COMPENSATE: {
				Compensate compensate = (Compensate)theEObject;
				T result = caseCompensate(compensate);
				if (result == null) result = caseSimpleElement(compensate);
				if (result == null) result = caseServiceElement(compensate);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.EXCEPTION_HANDLER: {
				ExceptionHandler exceptionHandler = (ExceptionHandler)theEObject;
				T result = caseExceptionHandler(exceptionHandler);
				if (result == null) result = caseHandler(exceptionHandler);
				if (result == null) result = caseCompositeElement(exceptionHandler);
				if (result == null) result = caseServiceElement(exceptionHandler);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.COMPENSATION_HANDLER: {
				CompensationHandler compensationHandler = (CompensationHandler)theEObject;
				T result = caseCompensationHandler(compensationHandler);
				if (result == null) result = caseHandler(compensationHandler);
				if (result == null) result = caseCompositeElement(compensationHandler);
				if (result == null) result = caseServiceElement(compensationHandler);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.PATH_BASED_PARTITION: {
				PathBasedPartition pathBasedPartition = (PathBasedPartition)theEObject;
				T result = casePathBasedPartition(pathBasedPartition);
				if (result == null) result = caseCompositeElement(pathBasedPartition);
				if (result == null) result = caseServiceElement(pathBasedPartition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.PATH: {
				Path path = (Path)theEObject;
				T result = casePath(path);
				if (result == null) result = caseCompositeElement(path);
				if (result == null) result = caseServiceElement(path);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.DECISION: {
				Decision decision = (Decision)theEObject;
				T result = caseDecision(decision);
				if (result == null) result = casePathBasedPartition(decision);
				if (result == null) result = caseCompositeElement(decision);
				if (result == null) result = caseServiceElement(decision);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.FORK: {
				Fork fork = (Fork)theEObject;
				T result = caseFork(fork);
				if (result == null) result = casePathBasedPartition(fork);
				if (result == null) result = caseCompositeElement(fork);
				if (result == null) result = caseServiceElement(fork);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.LOOP: {
				Loop loop = (Loop)theEObject;
				T result = caseLoop(loop);
				if (result == null) result = casePathBasedPartition(loop);
				if (result == null) result = caseCompositeElement(loop);
				if (result == null) result = caseServiceElement(loop);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.EVENT_HANDLER: {
				EventHandler eventHandler = (EventHandler)theEObject;
				T result = caseEventHandler(eventHandler);
				if (result == null) result = caseHandler(eventHandler);
				if (result == null) result = caseCompositeElement(eventHandler);
				if (result == null) result = caseServiceElement(eventHandler);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SERVICE_INTERACTION: {
				ServiceInteraction serviceInteraction = (ServiceInteraction)theEObject;
				T result = caseServiceInteraction(serviceInteraction);
				if (result == null) result = caseSimpleElement(serviceInteraction);
				if (result == null) result = caseServiceElement(serviceInteraction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.THROW: {
				Throw throw_ = (Throw)theEObject;
				T result = caseThrow(throw_);
				if (result == null) result = caseSimpleElement(throw_);
				if (result == null) result = caseServiceElement(throw_);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.COMPOSITE_ELEMENT: {
				CompositeElement compositeElement = (CompositeElement)theEObject;
				T result = caseCompositeElement(compositeElement);
				if (result == null) result = caseServiceElement(compositeElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.PICK: {
				Pick pick = (Pick)theEObject;
				T result = casePick(pick);
				if (result == null) result = casePathBasedPartition(pick);
				if (result == null) result = caseCompositeElement(pick);
				if (result == null) result = caseServiceElement(pick);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.REPLY: {
				Reply reply = (Reply)theEObject;
				T result = caseReply(reply);
				if (result == null) result = caseServiceInteraction(reply);
				if (result == null) result = caseSimpleElement(reply);
				if (result == null) result = caseServiceElement(reply);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.DATA_HANDLING: {
				DataHandling dataHandling = (DataHandling)theEObject;
				T result = caseDataHandling(dataHandling);
				if (result == null) result = caseSimpleElement(dataHandling);
				if (result == null) result = caseServiceElement(dataHandling);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.EXPRESSION: {
				Expression expression = (Expression)theEObject;
				T result = caseExpression(expression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.FIELD: {
				Field field = (Field)theEObject;
				T result = caseField(field);
				if (result == null) result = caseLeftHandSideExpression(field);
				if (result == null) result = caseRightHandSideExpression(field);
				if (result == null) result = caseExpression(field);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.ASSIGNMENT: {
				Assignment assignment = (Assignment)theEObject;
				T result = caseAssignment(assignment);
				if (result == null) result = caseStatement(assignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.DECLARATION: {
				Declaration declaration = (Declaration)theEObject;
				T result = caseDeclaration(declaration);
				if (result == null) result = caseStatement(declaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.STATEMENT: {
				Statement statement = (Statement)theEObject;
				T result = caseStatement(statement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.LITERAL: {
				Literal literal = (Literal)theEObject;
				T result = caseLiteral(literal);
				if (result == null) result = caseRightHandSideExpression(literal);
				if (result == null) result = caseExpression(literal);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.OPERATION: {
				Operation operation = (Operation)theEObject;
				T result = caseOperation(operation);
				if (result == null) result = caseRightHandSideExpression(operation);
				if (result == null) result = caseExpression(operation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.LEFT_HAND_SIDE_EXPRESSION: {
				LeftHandSideExpression leftHandSideExpression = (LeftHandSideExpression)theEObject;
				T result = caseLeftHandSideExpression(leftHandSideExpression);
				if (result == null) result = caseRightHandSideExpression(leftHandSideExpression);
				if (result == null) result = caseExpression(leftHandSideExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.RIGHT_HAND_SIDE_EXPRESSION: {
				RightHandSideExpression rightHandSideExpression = (RightHandSideExpression)theEObject;
				T result = caseRightHandSideExpression(rightHandSideExpression);
				if (result == null) result = caseExpression(rightHandSideExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SERVICE_INTERFACE: {
				ServiceInterface serviceInterface = (ServiceInterface)theEObject;
				T result = caseServiceInterface(serviceInterface);
				if (result == null) result = caseType(serviceInterface);
				if (result == null) result = caseNamedElement(serviceInterface);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SERVICE_POINT: {
				ServicePoint servicePoint = (ServicePoint)theEObject;
				T result = caseServicePoint(servicePoint);
				if (result == null) result = casePartnerPoint(servicePoint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.REQUEST_POINT: {
				RequestPoint requestPoint = (RequestPoint)theEObject;
				T result = caseRequestPoint(requestPoint);
				if (result == null) result = casePartnerPoint(requestPoint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SERVICE_OPERATION_PARAMETER: {
				ServiceOperationParameter serviceOperationParameter = (ServiceOperationParameter)theEObject;
				T result = caseServiceOperationParameter(serviceOperationParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.IN_PARAMETER: {
				InParameter inParameter = (InParameter)theEObject;
				T result = caseInParameter(inParameter);
				if (result == null) result = caseServiceOperationParameter(inParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.OUT_PARAMETER: {
				OutParameter outParameter = (OutParameter)theEObject;
				T result = caseOutParameter(outParameter);
				if (result == null) result = caseServiceOperationParameter(outParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.INTERACTION_PARAMETER: {
				InteractionParameter interactionParameter = (InteractionParameter)theEObject;
				T result = caseInteractionParameter(interactionParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.RECEIVE_PARAMETER: {
				ReceiveParameter receiveParameter = (ReceiveParameter)theEObject;
				T result = caseReceiveParameter(receiveParameter);
				if (result == null) result = caseInteractionParameter(receiveParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.SEND_PARAMETER: {
				SendParameter sendParameter = (SendParameter)theEObject;
				T result = caseSendParameter(sendParameter);
				if (result == null) result = caseInteractionParameter(sendParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.TERMINATE: {
				Terminate terminate = (Terminate)theEObject;
				T result = caseTerminate(terminate);
				if (result == null) result = caseSimpleElement(terminate);
				if (result == null) result = caseServiceElement(terminate);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IOMPackage.PARTICIPANT: {
				Participant participant = (Participant)theEObject;
				T result = caseParticipant(participant);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceElement(ServiceElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Partner Point</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Partner Point</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePartnerPoint(PartnerPoint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variable</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariable(Variable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service Operation</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceOperation(ServiceOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Simple Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Simple Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSimpleElement(SimpleElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service Activity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service Activity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceActivity(ServiceActivity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Handler</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Handler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHandler(Handler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Send</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Send</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSend(Send object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Receive</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Receive</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReceive(Receive object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Send And Receive</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Send And Receive</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSendAndReceive(SendAndReceive object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Receive And Reply</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Receive And Reply</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReceiveAndReply(ReceiveAndReply object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Compensate All</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Compensate All</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompensateAll(CompensateAll object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Compensate</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Compensate</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompensate(Compensate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Exception Handler</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Exception Handler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExceptionHandler(ExceptionHandler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Compensation Handler</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Compensation Handler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompensationHandler(CompensationHandler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Path Based Partition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Path Based Partition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePathBasedPartition(PathBasedPartition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Path</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Path</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePath(Path object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Decision</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Decision</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDecision(Decision object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Fork</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Fork</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFork(Fork object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Loop</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Loop</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLoop(Loop object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Handler</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Handler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventHandler(EventHandler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service Interaction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service Interaction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceInteraction(ServiceInteraction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Throw</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Throw</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseThrow(Throw object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Composite Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Composite Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompositeElement(CompositeElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Pick</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Pick</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePick(Pick object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reply</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reply</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReply(Reply object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Handling</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Handling</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataHandling(DataHandling object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expression</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpression(Expression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Field</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Field</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseField(Field object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assignment</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssignment(Assignment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Declaration</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeclaration(Declaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Statement</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStatement(Statement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Literal</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLiteral(Literal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Operation</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOperation(Operation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Left Hand Side Expression</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Left Hand Side Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLeftHandSideExpression(LeftHandSideExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Right Hand Side Expression</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Right Hand Side Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRightHandSideExpression(RightHandSideExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service Interface</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service Interface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceInterface(ServiceInterface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service Point</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service Point</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServicePoint(ServicePoint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Request Point</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Request Point</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRequestPoint(RequestPoint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service Operation Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service Operation Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceOperationParameter(ServiceOperationParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>In Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>In Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInParameter(InParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Out Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Out Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOutParameter(OutParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Interaction Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Interaction Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInteractionParameter(InteractionParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Receive Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Receive Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReceiveParameter(ReceiveParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Send Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Send Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSendParameter(SendParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Terminate</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Terminate</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTerminate(Terminate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Participant</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Participant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParticipant(Participant object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedElement(NamedElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseType(Type object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch, but this is
	 * the last case anyway. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} // IOMSwitch
