/*
 *
 * This source file belongs to the MDD4SOA suite developed at the Institute of 
 * Computer Science, Programming and Software Engineering, of the Ludwig-Maximilians-
 * Universität München, Germany. 
 * 
 * http://www.pst.ifi.lmu.de/
 * http://www.mdd4soa.eu/
 *
 * See the enclosed LICENSE file for licensing information.
 *
 */
package de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.TypeFactory
 * @model kind="package"
 * @generated
 */
public interface TypePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME= "type";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI= "http://www.pst.ifi.lmu.de/projekte/mdd4soa/iom/type";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX= "type";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	TypePackage eINSTANCE= de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl.init();

	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.NamedElementImpl
	 * <em>Named Element</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.NamedElementImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getNamedElement()
	 * @generated
	 */
	int NAMED_ELEMENT= 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT__NAME= 0;

	/**
	 * The number of structural features of the '<em>Named Element</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT_FEATURE_COUNT= 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypeImpl <em>Type</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getType()
	 * @generated
	 */
	int TYPE= 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TYPE__NAME= NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TYPE__PACKAGE= NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TYPE_FEATURE_COUNT= NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.PrimitiveTypeImpl <em>Primitive Type</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.PrimitiveTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getPrimitiveType()
	 * @generated
	 */
	int PRIMITIVE_TYPE= 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE__NAME= TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE__PACKAGE= TYPE__PACKAGE;

	/**
	 * The number of structural features of the '<em>Primitive Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_FEATURE_COUNT= TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StringTypeImpl
	 * <em>String Type</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StringTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getStringType()
	 * @generated
	 */
	int STRING_TYPE= 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_TYPE__PACKAGE= PRIMITIVE_TYPE__PACKAGE;

	/**
	 * The number of structural features of the '<em>String Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.BooleanTypeImpl
	 * <em>Boolean Type</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.BooleanTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getBooleanType()
	 * @generated
	 */
	int BOOLEAN_TYPE= 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE__PACKAGE= PRIMITIVE_TYPE__PACKAGE;

	/**
	 * The number of structural features of the '<em>Boolean Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.IntegerTypeImpl
	 * <em>Integer Type</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.IntegerTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getIntegerType()
	 * @generated
	 */
	int INTEGER_TYPE= 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTEGER_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTEGER_TYPE__PACKAGE= PRIMITIVE_TYPE__PACKAGE;

	/**
	 * The number of structural features of the '<em>Integer Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.RealTypeImpl <em>Real Type</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.RealTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getRealType()
	 * @generated
	 */
	int REAL_TYPE= 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REAL_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REAL_TYPE__PACKAGE= PRIMITIVE_TYPE__PACKAGE;

	/**
	 * The number of structural features of the '<em>Real Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REAL_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.DateTypeImpl <em>Date Type</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.DateTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getDateType()
	 * @generated
	 */
	int DATE_TYPE= 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATE_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATE_TYPE__PACKAGE= PRIMITIVE_TYPE__PACKAGE;

	/**
	 * The number of structural features of the '<em>Date Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATE_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.PackageImpl <em>Package</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.PackageImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getPackage()
	 * @generated
	 */
	int PACKAGE= 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE__NAME= NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Referenced Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__REFERENCED_TYPES = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE__PARENT= NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__CHILDREN = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE__TYPES = NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Package</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_FEATURE_COUNT= NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StructureTypeImpl <em>Structure Type</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StructureTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getStructureType()
	 * @generated
	 */
	int STRUCTURE_TYPE= 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_TYPE__NAME= TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_TYPE__PACKAGE= TYPE__PACKAGE;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_TYPE__ATTRIBUTES= TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Super Structure</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_TYPE__SUPER_STRUCTURE= TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Structure Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_TYPE_FEATURE_COUNT= TYPE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.AttributeImpl <em>Attribute</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.AttributeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getAttribute()
	 * @generated
	 */
	int ATTRIBUTE= 10;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__IDENTIFIER= 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__TYPE= 1;

	/**
	 * The number of structural features of the '<em>Attribute</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_FEATURE_COUNT= 2;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.CollectionTypeImpl <em>Collection Type</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.CollectionTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getCollectionType()
	 * @generated
	 */
	int COLLECTION_TYPE= 11;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLECTION_TYPE__NAME= TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLECTION_TYPE__PACKAGE= TYPE__PACKAGE;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLECTION_TYPE__ELEM_TYPE= TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Collection Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_TYPE_FEATURE_COUNT= TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.SetTypeImpl <em>Set Type</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.SetTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getSetType()
	 * @generated
	 */
	int SET_TYPE= 12;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SET_TYPE__NAME= COLLECTION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SET_TYPE__PACKAGE= COLLECTION_TYPE__PACKAGE;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SET_TYPE__ELEM_TYPE= COLLECTION_TYPE__ELEM_TYPE;

	/**
	 * The number of structural features of the '<em>Set Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SET_TYPE_FEATURE_COUNT= COLLECTION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.ListTypeImpl <em>List Type</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.ListTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getListType()
	 * @generated
	 */
	int LIST_TYPE= 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_TYPE__NAME= COLLECTION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_TYPE__PACKAGE= COLLECTION_TYPE__PACKAGE;

	/**
	 * The feature id for the '<em><b>Elem Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_TYPE__ELEM_TYPE= COLLECTION_TYPE__ELEM_TYPE;

	/**
	 * The number of structural features of the '<em>List Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_TYPE_FEATURE_COUNT= COLLECTION_TYPE_FEATURE_COUNT + 0;


	/**
	 * The meta object id for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.NullTypeImpl <em>Null Type</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.NullTypeImpl
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getNullType()
	 * @generated
	 */
	int NULL_TYPE= 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NULL_TYPE__NAME= TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Package</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NULL_TYPE__PACKAGE= TYPE__PACKAGE;

	/**
	 * The number of structural features of the '<em>Null Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NULL_TYPE_FEATURE_COUNT= TYPE_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement <em>Named Element</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Named Element</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement
	 * @generated
	 */
	EClass getNamedElement();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NamedElement#getName()
	 * @see #getNamedElement()
	 * @generated
	 */
	EAttribute getNamedElement_Name();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type <em>Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type
	 * @generated
	 */
	EClass getType();

	/**
	 * Returns the meta object for the container reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Package</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Type#getPackage()
	 * @see #getType()
	 * @generated
	 */
	EReference getType_Package();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.PrimitiveType <em>Primitive Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Primitive Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.PrimitiveType
	 * @generated
	 */
	EClass getPrimitiveType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StringType <em>String Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StringType
	 * @generated
	 */
	EClass getStringType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.BooleanType <em>Boolean Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.BooleanType
	 * @generated
	 */
	EClass getBooleanType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.IntegerType <em>Integer Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Integer Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.IntegerType
	 * @generated
	 */
	EClass getIntegerType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.RealType <em>Real Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Real Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.RealType
	 * @generated
	 */
	EClass getRealType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.DateType <em>Date Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Date Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.DateType
	 * @generated
	 */
	EClass getDateType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package <em>Package</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Package</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package
	 * @generated
	 */
	EClass getPackage();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getReferencedTypes <em>Referenced Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Referenced Types</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getReferencedTypes()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_ReferencedTypes();

	/**
	 * Returns the meta object for the container reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Parent</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getParent()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_Parent();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Children</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getChildren()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_Children();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getTypes <em>Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Types</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Package#getTypes()
	 * @see #getPackage()
	 * @generated
	 */
	EReference getPackage_Types();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType <em>Structure Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Structure Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType
	 * @generated
	 */
	EClass getStructureType();

	/**
	 * Returns the meta object for the containment reference list '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType#getAttributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Attributes</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType#getAttributes()
	 * @see #getStructureType()
	 * @generated
	 */
	EReference getStructureType_Attributes();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType#getSuperStructure <em>Super Structure</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Super Structure</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.StructureType#getSuperStructure()
	 * @see #getStructureType()
	 * @generated
	 */
	EReference getStructureType_SuperStructure();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute
	 * @generated
	 */
	EClass getAttribute();

	/**
	 * Returns the meta object for the attribute '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Identifier</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute#getIdentifier()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Identifier();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute#getType <em>Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.Attribute#getType()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_Type();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.CollectionType <em>Collection Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collection Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.CollectionType
	 * @generated
	 */
	EClass getCollectionType();

	/**
	 * Returns the meta object for the reference '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.CollectionType#getElemType <em>Elem Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Elem Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.CollectionType#getElemType()
	 * @see #getCollectionType()
	 * @generated
	 */
	EReference getCollectionType_ElemType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.SetType <em>Set Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Set Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.SetType
	 * @generated
	 */
	EClass getSetType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.ListType <em>List Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>List Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.ListType
	 * @generated
	 */
	EClass getListType();

	/**
	 * Returns the meta object for class '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NullType <em>Null Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Null Type</em>'.
	 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.NullType
	 * @generated
	 */
	EClass getNullType();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	TypeFactory getTypeFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.NamedElementImpl <em>Named Element</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.NamedElementImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getNamedElement()
		 * @generated
		 */
		EClass NAMED_ELEMENT= eINSTANCE.getNamedElement();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NAMED_ELEMENT__NAME= eINSTANCE.getNamedElement_Name();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypeImpl <em>Type</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getType()
		 * @generated
		 */
		EClass TYPE= eINSTANCE.getType();

		/**
		 * The meta object literal for the '<em><b>Package</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE__PACKAGE= eINSTANCE.getType_Package();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.PrimitiveTypeImpl <em>Primitive Type</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.PrimitiveTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getPrimitiveType()
		 * @generated
		 */
		EClass PRIMITIVE_TYPE= eINSTANCE.getPrimitiveType();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StringTypeImpl <em>String Type</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StringTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getStringType()
		 * @generated
		 */
		EClass STRING_TYPE= eINSTANCE.getStringType();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.BooleanTypeImpl <em>Boolean Type</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.BooleanTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getBooleanType()
		 * @generated
		 */
		EClass BOOLEAN_TYPE= eINSTANCE.getBooleanType();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.IntegerTypeImpl <em>Integer Type</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.IntegerTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getIntegerType()
		 * @generated
		 */
		EClass INTEGER_TYPE= eINSTANCE.getIntegerType();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.RealTypeImpl
		 * <em>Real Type</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.RealTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getRealType()
		 * @generated
		 */
		EClass REAL_TYPE= eINSTANCE.getRealType();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.DateTypeImpl
		 * <em>Date Type</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.DateTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getDateType()
		 * @generated
		 */
		EClass DATE_TYPE= eINSTANCE.getDateType();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.PackageImpl
		 * <em>Package</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.PackageImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getPackage()
		 * @generated
		 */
		EClass PACKAGE= eINSTANCE.getPackage();

		/**
		 * The meta object literal for the '<em><b>Referenced Types</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__REFERENCED_TYPES = eINSTANCE.getPackage_ReferencedTypes();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__PARENT= eINSTANCE.getPackage_Parent();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__CHILDREN = eINSTANCE.getPackage_Children();

		/**
		 * The meta object literal for the '<em><b>Types</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PACKAGE__TYPES = eINSTANCE.getPackage_Types();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StructureTypeImpl <em>Structure Type</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.StructureTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getStructureType()
		 * @generated
		 */
		EClass STRUCTURE_TYPE= eINSTANCE.getStructureType();

		/**
		 * The meta object literal for the '<em><b>Attributes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURE_TYPE__ATTRIBUTES= eINSTANCE.getStructureType_Attributes();

		/**
		 * The meta object literal for the '<em><b>Super Structure</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURE_TYPE__SUPER_STRUCTURE= eINSTANCE.getStructureType_SuperStructure();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.AttributeImpl
		 * <em>Attribute</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.AttributeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getAttribute()
		 * @generated
		 */
		EClass ATTRIBUTE= eINSTANCE.getAttribute();

		/**
		 * The meta object literal for the '<em><b>Identifier</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__IDENTIFIER= eINSTANCE.getAttribute_Identifier();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__TYPE= eINSTANCE.getAttribute_Type();

		/**
		 * The meta object literal for the '{@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.CollectionTypeImpl <em>Collection Type</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.CollectionTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getCollectionType()
		 * @generated
		 */
		EClass COLLECTION_TYPE= eINSTANCE.getCollectionType();

		/**
		 * The meta object literal for the '<em><b>Elem Type</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference COLLECTION_TYPE__ELEM_TYPE= eINSTANCE.getCollectionType_ElemType();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.SetTypeImpl
		 * <em>Set Type</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.SetTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getSetType()
		 * @generated
		 */
		EClass SET_TYPE= eINSTANCE.getSetType();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.ListTypeImpl
		 * <em>List Type</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.ListTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getListType()
		 * @generated
		 */
		EClass LIST_TYPE= eINSTANCE.getListType();

		/**
		 * The meta object literal for the '
		 * {@link de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.NullTypeImpl
		 * <em>Null Type</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.NullTypeImpl
		 * @see de.lmu.ifi.pst.mdd4soa.transform.impl.iom.type.impl.TypePackageImpl#getNullType()
		 * @generated
		 */
		EClass NULL_TYPE= eINSTANCE.getNullType();

	}

} // TypePackage
