/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Composite Element</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.CompositeElement#getChildren <em>Children
 * </em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getCompositeElement()
 * @model abstract="true"
 * @generated
 */
public interface CompositeElement extends ServiceElement {
	/**
	 * Returns the value of the '<em><b>Children</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link eu.mdd4soa.smm.behaviour.ServiceElement}. It is bidirectional and
	 * its opposite is '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceElement#getParent <em>Parent</em>}
	 * '. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Children</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Children</em>' containment reference list.
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getCompositeElement_Children()
	 * @see eu.mdd4soa.smm.behaviour.ServiceElement#getParent
	 * @model opposite="parent" containment="true"
	 * @generated
	 */
	EList<ServiceElement> getChildren();

} // CompositeElement
