/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;

import eu.mdd4soa.smm.data.VariableReference;
import eu.mdd4soa.smm.statik.ExceptionType;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Exception Handler</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.ExceptionHandler#getExceptionType <em>
 * Exception Type</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ExceptionHandler#getCaughtException <em>
 * Caught Exception</em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getExceptionHandler()
 * @model
 * @generated
 */
public interface ExceptionHandler extends Handler {
	/**
	 * Returns the value of the '<em><b>Exception Type</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Exception Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Exception Type</em>' reference.
	 * @see #setExceptionType(ExceptionType)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getExceptionHandler_ExceptionType()
	 * @model
	 * @generated
	 */
	ExceptionType getExceptionType();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.ExceptionHandler#getExceptionType
	 * <em>Exception Type</em>}' reference. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Exception Type</em>' reference.
	 * @see #getExceptionType()
	 * @generated
	 */
	void setExceptionType(ExceptionType value);

	/**
	 * Returns the value of the '<em><b>Caught Exception</b></em>' containment
	 * reference. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Caught Exception</em>' containment reference
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Caught Exception</em>' containment
	 *         reference.
	 * @see #setCaughtException(VariableReference)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getExceptionHandler_CaughtException()
	 * @model containment="true"
	 * @generated
	 */
	VariableReference getCaughtException();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.ExceptionHandler#getCaughtException
	 * <em>Caught Exception</em>}' containment reference. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Caught Exception</em>' containment
	 *        reference.
	 * @see #getCaughtException()
	 * @generated
	 */
	void setCaughtException(VariableReference value);

} // ExceptionHandler
