/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;


/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Handler</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.Handler#getServiceActivity <em>Service
 * Activity</em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getHandler()
 * @model abstract="true"
 * @generated
 */
public interface Handler extends CompositeElement {
	/**
	 * Returns the value of the '<em><b>Service Activity</b></em>' container
	 * reference. It is bidirectional and its opposite is '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getHandlers
	 * <em>Handlers</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Service Activity</em>' container reference
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Service Activity</em>' container reference.
	 * @see #setServiceActivity(ServiceActivity)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getHandler_ServiceActivity()
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity#getHandlers
	 * @model opposite="handlers" transient="false"
	 * @generated
	 */
	ServiceActivity getServiceActivity();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.Handler#getServiceActivity
	 * <em>Service Activity</em>}' container reference. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Service Activity</em>' container
	 *        reference.
	 * @see #getServiceActivity()
	 * @generated
	 */
	void setServiceActivity(ServiceActivity value);

} // Handler
