/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc --> The <b>Factory</b> for the model. It provides a
 * create method for each non-abstract class of the model. <!-- end-user-doc -->
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage
 * @generated
 */
public interface ISMBehaviourFactory extends EFactory {
	/**
	 * The singleton instance of the factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	ISMBehaviourFactory eINSTANCE= eu.mdd4soa.smm.behaviour.impl.ISMBehaviourFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Service Activity</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Service Activity</em>'.
	 * @generated
	 */
	ServiceActivity createServiceActivity();

	/**
	 * Returns a new object of class '<em>Send</em>'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Send</em>'.
	 * @generated
	 */
	Send createSend();

	/**
	 * Returns a new object of class '<em>Receive</em>'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Receive</em>'.
	 * @generated
	 */
	Receive createReceive();

	/**
	 * Returns a new object of class '<em>Send And Receive</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Send And Receive</em>'.
	 * @generated
	 */
	SendAndReceive createSendAndReceive();

	/**
	 * Returns a new object of class '<em>Compensate All</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Compensate All</em>'.
	 * @generated
	 */
	CompensateAll createCompensateAll();

	/**
	 * Returns a new object of class '<em>Compensate</em>'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Compensate</em>'.
	 * @generated
	 */
	Compensate createCompensate();

	/**
	 * Returns a new object of class '<em>Exception Handler</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Exception Handler</em>'.
	 * @generated
	 */
	ExceptionHandler createExceptionHandler();

	/**
	 * Returns a new object of class '<em>Compensation Handler</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Compensation Handler</em>'.
	 * @generated
	 */
	CompensationHandler createCompensationHandler();

	/**
	 * Returns a new object of class '<em>Path</em>'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Path</em>'.
	 * @generated
	 */
	Path createPath();

	/**
	 * Returns a new object of class '<em>Decision</em>'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Decision</em>'.
	 * @generated
	 */
	Decision createDecision();

	/**
	 * Returns a new object of class '<em>Parallel</em>'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Parallel</em>'.
	 * @generated
	 */
	Parallel createParallel();

	/**
	 * Returns a new object of class '<em>Loop</em>'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Loop</em>'.
	 * @generated
	 */
	Loop createLoop();

	/**
	 * Returns a new object of class '<em>Event Handler</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Event Handler</em>'.
	 * @generated
	 */
	EventHandler createEventHandler();

	/**
	 * Returns a new object of class '<em>Throw</em>'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Throw</em>'.
	 * @generated
	 */
	Throw createThrow();

	/**
	 * Returns a new object of class '<em>Reply</em>'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Reply</em>'.
	 * @generated
	 */
	Reply createReply();

	/**
	 * Returns a new object of class '<em>Data Handling</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Data Handling</em>'.
	 * @generated
	 */
	DataHandling createDataHandling();

	/**
	 * Returns a new object of class '<em>Terminate</em>'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Terminate</em>'.
	 * @generated
	 */
	Terminate createTerminate();

	/**
	 * Returns a new object of class '<em>Service Protocol</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Service Protocol</em>'.
	 * @generated
	 */
	ServiceProtocol createServiceProtocol();

	/**
	 * Returns a new object of class '<em>Protocol State</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Protocol State</em>'.
	 * @generated
	 */
	ProtocolState createProtocolState();

	/**
	 * Returns a new object of class '<em>Receiving Transition</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Receiving Transition</em>'.
	 * @generated
	 */
	ReceivingTransition createReceivingTransition();

	/**
	 * Returns a new object of class '<em>Sending Transition</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Sending Transition</em>'.
	 * @generated
	 */
	SendingTransition createSendingTransition();

	/**
	 * Returns a new object of class '<em>Replying Transition</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Replying Transition</em>'.
	 * @generated
	 */
	ReplyingTransition createReplyingTransition();

	/**
	 * Returns a new object of class '<em>Receive Replying Transition</em>'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Receive Replying Transition</em>'.
	 * @generated
	 */
	ReceiveReplyingTransition createReceiveReplyingTransition();

	/**
	 * Returns a new object of class '<em>Noop Transition</em>'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return a new object of class '<em>Noop Transition</em>'.
	 * @generated
	 */
	NoopTransition createNoopTransition();

	/**
	 * Returns the package supported by this factory. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the package supported by this factory.
	 * @generated
	 */
	ISMBehaviourPackage getISMBehaviourPackage();

} // ISMBehaviourFactory
