/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourFactory
 * @model kind="package"
 * @generated
 */
public interface ISMBehaviourPackage extends EPackage {
	/**
	 * The package name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNAME= "behaviour";

	/**
	 * The package namespace URI. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_URI= "http://www.mdd4soa.eu/ism/behaviour";

	/**
	 * The package namespace name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_PREFIX= "ismBehaviour";

	/**
	 * The singleton instance of the package. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	ISMBehaviourPackage eINSTANCE= eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl.init();

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceElementImpl
	 * <em>Service Element</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ServiceElementImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getServiceElement()
	 * @generated
	 */
	int SERVICE_ELEMENT= 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ELEMENT__NAME= 0;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ELEMENT__PARENT= 1;

	/**
	 * The number of structural features of the '<em>Service Element</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ELEMENT_FEATURE_COUNT= 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.SimpleElementImpl
	 * <em>Simple Element</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.SimpleElementImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getSimpleElement()
	 * @generated
	 */
	int SIMPLE_ELEMENT= 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIMPLE_ELEMENT__NAME= SERVICE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIMPLE_ELEMENT__PARENT= SERVICE_ELEMENT__PARENT;

	/**
	 * The number of structural features of the '<em>Simple Element</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIMPLE_ELEMENT_FEATURE_COUNT= SERVICE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.CompositeElementImpl
	 * <em>Composite Element</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.CompositeElementImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getCompositeElement()
	 * @generated
	 */
	int COMPOSITE_ELEMENT= 19;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ELEMENT__NAME= SERVICE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ELEMENT__PARENT= SERVICE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ELEMENT__CHILDREN= SERVICE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Composite Element</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_ELEMENT_FEATURE_COUNT= SERVICE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceActivityImpl
	 * <em>Service Activity</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ServiceActivityImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getServiceActivity()
	 * @generated
	 */
	int SERVICE_ACTIVITY= 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__NAME= COMPOSITE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__PARENT= COMPOSITE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__CHILDREN= COMPOSITE_ELEMENT__CHILDREN;

	/**
	 * The feature id for the '<em><b>Variables</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__VARIABLES= COMPOSITE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Handlers</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__HANDLERS= COMPOSITE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Interrupting Receives</b></em>'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__INTERRUPTING_RECEIVES= COMPOSITE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Participant</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY__PARTICIPANT= COMPOSITE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Service Activity</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_ACTIVITY_FEATURE_COUNT= COMPOSITE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.HandlerImpl <em>Handler</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.HandlerImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getHandler()
	 * @generated
	 */
	int HANDLER= 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HANDLER__NAME= COMPOSITE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HANDLER__PARENT= COMPOSITE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HANDLER__CHILDREN= COMPOSITE_ELEMENT__CHILDREN;

	/**
	 * The feature id for the '<em><b>Service Activity</b></em>' container
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HANDLER__SERVICE_ACTIVITY= COMPOSITE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Handler</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int HANDLER_FEATURE_COUNT= COMPOSITE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceInteractionImpl
	 * <em>Service Interaction</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ServiceInteractionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getServiceInteraction()
	 * @generated
	 */
	int SERVICE_INTERACTION= 17;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__NAME= SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__PARENT= SIMPLE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__OPERATION= SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__RCV_PARAMETERS= SIMPLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__SND_PARAMETERS= SIMPLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION__PARTNER= SIMPLE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Service Interaction</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_INTERACTION_FEATURE_COUNT= SIMPLE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.SendImpl <em>Send</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.SendImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getSend()
	 * @generated
	 */
	int SEND= 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__NAME= SERVICE_INTERACTION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__PARENT= SERVICE_INTERACTION__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__OPERATION= SERVICE_INTERACTION__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__RCV_PARAMETERS= SERVICE_INTERACTION__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__SND_PARAMETERS= SERVICE_INTERACTION__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND__PARTNER= SERVICE_INTERACTION__PARTNER;

	/**
	 * The number of structural features of the '<em>Send</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_FEATURE_COUNT= SERVICE_INTERACTION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ReceiveImpl <em>Receive</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ReceiveImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReceive()
	 * @generated
	 */
	int RECEIVE= 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__NAME= SERVICE_INTERACTION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__PARENT= SERVICE_INTERACTION__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__OPERATION= SERVICE_INTERACTION__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__RCV_PARAMETERS= SERVICE_INTERACTION__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__SND_PARAMETERS= SERVICE_INTERACTION__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__PARTNER= SERVICE_INTERACTION__PARTNER;

	/**
	 * The feature id for the '<em><b>Reply</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__REPLY= SERVICE_INTERACTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interrupting</b></em>' container
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE__INTERRUPTING= SERVICE_INTERACTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Receive</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_FEATURE_COUNT= SERVICE_INTERACTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.SendAndReceiveImpl
	 * <em>Send And Receive</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.SendAndReceiveImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getSendAndReceive()
	 * @generated
	 */
	int SEND_AND_RECEIVE= 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__NAME= SEND__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__PARENT= SEND__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__OPERATION= SEND__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__RCV_PARAMETERS= SEND__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__SND_PARAMETERS= SEND__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__PARTNER= SEND__PARTNER;

	/**
	 * The feature id for the '<em><b>Reply</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__REPLY= SEND_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interrupting</b></em>' container
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE__INTERRUPTING= SEND_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Send And Receive</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_AND_RECEIVE_FEATURE_COUNT= SEND_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.CompensateAllImpl
	 * <em>Compensate All</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.CompensateAllImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getCompensateAll()
	 * @generated
	 */
	int COMPENSATE_ALL= 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATE_ALL__NAME= SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATE_ALL__PARENT= SIMPLE_ELEMENT__PARENT;

	/**
	 * The number of structural features of the '<em>Compensate All</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATE_ALL_FEATURE_COUNT= SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.CompensateImpl <em>Compensate</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.CompensateImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getCompensate()
	 * @generated
	 */
	int COMPENSATE= 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATE__NAME= SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATE__PARENT= SIMPLE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATE__TARGET= SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Compensate</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATE_FEATURE_COUNT= SIMPLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ExceptionHandlerImpl
	 * <em>Exception Handler</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ExceptionHandlerImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getExceptionHandler()
	 * @generated
	 */
	int EXCEPTION_HANDLER= 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__NAME= HANDLER__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__PARENT= HANDLER__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__CHILDREN= HANDLER__CHILDREN;

	/**
	 * The feature id for the '<em><b>Service Activity</b></em>' container
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__SERVICE_ACTIVITY= HANDLER__SERVICE_ACTIVITY;

	/**
	 * The feature id for the '<em><b>Exception Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__EXCEPTION_TYPE= HANDLER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Caught Exception</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__CAUGHT_EXCEPTION= HANDLER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Exception Handler</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER_FEATURE_COUNT= HANDLER_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.CompensationHandlerImpl
	 * <em>Compensation Handler</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.CompensationHandlerImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getCompensationHandler()
	 * @generated
	 */
	int COMPENSATION_HANDLER= 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER__NAME= HANDLER__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER__PARENT= HANDLER__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER__CHILDREN= HANDLER__CHILDREN;

	/**
	 * The feature id for the '<em><b>Service Activity</b></em>' container
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER__SERVICE_ACTIVITY= HANDLER__SERVICE_ACTIVITY;

	/**
	 * The number of structural features of the '<em>Compensation Handler</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPENSATION_HANDLER_FEATURE_COUNT= HANDLER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.PathBasedPartitionImpl
	 * <em>Path Based Partition</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.PathBasedPartitionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getPathBasedPartition()
	 * @generated
	 */
	int PATH_BASED_PARTITION= 11;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION__NAME= COMPOSITE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION__PARENT= COMPOSITE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION__CHILDREN= COMPOSITE_ELEMENT__CHILDREN;

	/**
	 * The number of structural features of the '<em>Path Based Partition</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH_BASED_PARTITION_FEATURE_COUNT= COMPOSITE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.PathImpl <em>Path</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.PathImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getPath()
	 * @generated
	 */
	int PATH= 12;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH__NAME= COMPOSITE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH__PARENT= COMPOSITE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH__CHILDREN= COMPOSITE_ELEMENT__CHILDREN;

	/**
	 * The feature id for the '<em><b>Enter Condition</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH__ENTER_CONDITION= COMPOSITE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Path</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PATH_FEATURE_COUNT= COMPOSITE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.DecisionImpl <em>Decision</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.DecisionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getDecision()
	 * @generated
	 */
	int DECISION= 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DECISION__NAME= PATH_BASED_PARTITION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DECISION__PARENT= PATH_BASED_PARTITION__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DECISION__CHILDREN= PATH_BASED_PARTITION__CHILDREN;

	/**
	 * The number of structural features of the '<em>Decision</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DECISION_FEATURE_COUNT= PATH_BASED_PARTITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ParallelImpl <em>Parallel</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ParallelImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getParallel()
	 * @generated
	 */
	int PARALLEL= 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARALLEL__NAME= PATH_BASED_PARTITION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARALLEL__PARENT= PATH_BASED_PARTITION__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARALLEL__CHILDREN= PATH_BASED_PARTITION__CHILDREN;

	/**
	 * The number of structural features of the '<em>Parallel</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARALLEL_FEATURE_COUNT= PATH_BASED_PARTITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.LoopImpl <em>Loop</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.LoopImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getLoop()
	 * @generated
	 */
	int LOOP= 15;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP__NAME= PATH_BASED_PARTITION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP__PARENT= PATH_BASED_PARTITION__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP__CHILDREN= PATH_BASED_PARTITION__CHILDREN;

	/**
	 * The feature id for the '<em><b>Leave Condition</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP__LEAVE_CONDITION= PATH_BASED_PARTITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Loop</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LOOP_FEATURE_COUNT= PATH_BASED_PARTITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.EventHandlerImpl
	 * <em>Event Handler</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.EventHandlerImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getEventHandler()
	 * @generated
	 */
	int EVENT_HANDLER= 16;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER__NAME= HANDLER__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER__PARENT= HANDLER__PARENT;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER__CHILDREN= HANDLER__CHILDREN;

	/**
	 * The feature id for the '<em><b>Service Activity</b></em>' container
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER__SERVICE_ACTIVITY= HANDLER__SERVICE_ACTIVITY;

	/**
	 * The number of structural features of the '<em>Event Handler</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EVENT_HANDLER_FEATURE_COUNT= HANDLER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ThrowImpl <em>Throw</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ThrowImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getThrow()
	 * @generated
	 */
	int THROW= 18;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int THROW__NAME= SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int THROW__PARENT= SIMPLE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Exception Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int THROW__EXCEPTION_TYPE= SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Throw</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int THROW_FEATURE_COUNT= SIMPLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ReplyImpl <em>Reply</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ReplyImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReply()
	 * @generated
	 */
	int REPLY= 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__NAME= SERVICE_INTERACTION__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__PARENT= SERVICE_INTERACTION__PARENT;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__OPERATION= SERVICE_INTERACTION__OPERATION;

	/**
	 * The feature id for the '<em><b>Rcv Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__RCV_PARAMETERS= SERVICE_INTERACTION__RCV_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Snd Parameters</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__SND_PARAMETERS= SERVICE_INTERACTION__SND_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Partner</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__PARTNER= SERVICE_INTERACTION__PARTNER;

	/**
	 * The feature id for the '<em><b>Receive</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY__RECEIVE= SERVICE_INTERACTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reply</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLY_FEATURE_COUNT= SERVICE_INTERACTION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.DataHandlingImpl
	 * <em>Data Handling</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.DataHandlingImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getDataHandling()
	 * @generated
	 */
	int DATA_HANDLING= 21;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_HANDLING__NAME= SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_HANDLING__PARENT= SIMPLE_ELEMENT__PARENT;

	/**
	 * The feature id for the '<em><b>Statements</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_HANDLING__STATEMENTS= SIMPLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Data Handling</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_HANDLING_FEATURE_COUNT= SIMPLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.TerminateImpl <em>Terminate</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.TerminateImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getTerminate()
	 * @generated
	 */
	int TERMINATE= 22;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TERMINATE__NAME= SIMPLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TERMINATE__PARENT= SIMPLE_ELEMENT__PARENT;

	/**
	 * The number of structural features of the '<em>Terminate</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TERMINATE_FEATURE_COUNT= SIMPLE_ELEMENT_FEATURE_COUNT + 0;


	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceProtocolImpl
	 * <em>Service Protocol</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ServiceProtocolImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getServiceProtocol()
	 * @generated
	 */
	int SERVICE_PROTOCOL= 23;

	/**
	 * The feature id for the '<em><b>States</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_PROTOCOL__STATES= 0;

	/**
	 * The feature id for the '<em><b>Transitions</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_PROTOCOL__TRANSITIONS= 1;

	/**
	 * The feature id for the '<em><b>Start State</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_PROTOCOL__START_STATE= 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_PROTOCOL__NAME= 3;

	/**
	 * The number of structural features of the '<em>Service Protocol</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_PROTOCOL_FEATURE_COUNT= 4;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ProtocolStateImpl
	 * <em>Protocol State</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ProtocolStateImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getProtocolState()
	 * @generated
	 */
	int PROTOCOL_STATE= 24;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STATE__NAME= 0;

	/**
	 * The feature id for the '<em><b>Protocol</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STATE__PROTOCOL= 1;

	/**
	 * The number of structural features of the '<em>Protocol State</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STATE_FEATURE_COUNT= 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ProtocolTransitionImpl
	 * <em>Protocol Transition</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ProtocolTransitionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getProtocolTransition()
	 * @generated
	 */
	int PROTOCOL_TRANSITION= 25;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_TRANSITION__OPERATION= 0;

	/**
	 * The feature id for the '<em><b>Is Optional</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_TRANSITION__IS_OPTIONAL= 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_TRANSITION__SOURCE= 2;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_TRANSITION__TARGET= 3;

	/**
	 * The number of structural features of the '<em>Protocol Transition</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_TRANSITION_FEATURE_COUNT= 4;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ReceivingTransitionImpl
	 * <em>Receiving Transition</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ReceivingTransitionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReceivingTransition()
	 * @generated
	 */
	int RECEIVING_TRANSITION= 26;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVING_TRANSITION__OPERATION= PROTOCOL_TRANSITION__OPERATION;

	/**
	 * The feature id for the '<em><b>Is Optional</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVING_TRANSITION__IS_OPTIONAL= PROTOCOL_TRANSITION__IS_OPTIONAL;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVING_TRANSITION__SOURCE= PROTOCOL_TRANSITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVING_TRANSITION__TARGET= PROTOCOL_TRANSITION__TARGET;

	/**
	 * The number of structural features of the '<em>Receiving Transition</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVING_TRANSITION_FEATURE_COUNT= PROTOCOL_TRANSITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.SendingTransitionImpl
	 * <em>Sending Transition</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.SendingTransitionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getSendingTransition()
	 * @generated
	 */
	int SENDING_TRANSITION= 27;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SENDING_TRANSITION__OPERATION= PROTOCOL_TRANSITION__OPERATION;

	/**
	 * The feature id for the '<em><b>Is Optional</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SENDING_TRANSITION__IS_OPTIONAL= PROTOCOL_TRANSITION__IS_OPTIONAL;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SENDING_TRANSITION__SOURCE= PROTOCOL_TRANSITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SENDING_TRANSITION__TARGET= PROTOCOL_TRANSITION__TARGET;

	/**
	 * The number of structural features of the '<em>Sending Transition</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SENDING_TRANSITION_FEATURE_COUNT= PROTOCOL_TRANSITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ReplyingTransitionImpl
	 * <em>Replying Transition</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ReplyingTransitionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReplyingTransition()
	 * @generated
	 */
	int REPLYING_TRANSITION= 28;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLYING_TRANSITION__OPERATION= PROTOCOL_TRANSITION__OPERATION;

	/**
	 * The feature id for the '<em><b>Is Optional</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLYING_TRANSITION__IS_OPTIONAL= PROTOCOL_TRANSITION__IS_OPTIONAL;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLYING_TRANSITION__SOURCE= PROTOCOL_TRANSITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLYING_TRANSITION__TARGET= PROTOCOL_TRANSITION__TARGET;

	/**
	 * The number of structural features of the '<em>Replying Transition</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPLYING_TRANSITION_FEATURE_COUNT= PROTOCOL_TRANSITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.ReceiveReplyingTransitionImpl
	 * <em>Receive Replying Transition</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.ReceiveReplyingTransitionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReceiveReplyingTransition()
	 * @generated
	 */
	int RECEIVE_REPLYING_TRANSITION= 29;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_REPLYING_TRANSITION__OPERATION= PROTOCOL_TRANSITION__OPERATION;

	/**
	 * The feature id for the '<em><b>Is Optional</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_REPLYING_TRANSITION__IS_OPTIONAL= PROTOCOL_TRANSITION__IS_OPTIONAL;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_REPLYING_TRANSITION__SOURCE= PROTOCOL_TRANSITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_REPLYING_TRANSITION__TARGET= PROTOCOL_TRANSITION__TARGET;

	/**
	 * The number of structural features of the '
	 * <em>Receive Replying Transition</em>' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_REPLYING_TRANSITION_FEATURE_COUNT= PROTOCOL_TRANSITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.behaviour.impl.NoopTransitionImpl
	 * <em>Noop Transition</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.behaviour.impl.NoopTransitionImpl
	 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getNoopTransition()
	 * @generated
	 */
	int NOOP_TRANSITION= 30;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NOOP_TRANSITION__OPERATION= PROTOCOL_TRANSITION__OPERATION;

	/**
	 * The feature id for the '<em><b>Is Optional</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NOOP_TRANSITION__IS_OPTIONAL= PROTOCOL_TRANSITION__IS_OPTIONAL;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NOOP_TRANSITION__SOURCE= PROTOCOL_TRANSITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NOOP_TRANSITION__TARGET= PROTOCOL_TRANSITION__TARGET;

	/**
	 * The number of structural features of the '<em>Noop Transition</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NOOP_TRANSITION_FEATURE_COUNT= PROTOCOL_TRANSITION_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceElement <em>Service Element</em>}
	 * '. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Service Element</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceElement
	 * @generated
	 */
	EClass getServiceElement();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceElement#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceElement#getName()
	 * @see #getServiceElement()
	 * @generated
	 */
	EAttribute getServiceElement_Name();

	/**
	 * Returns the meta object for the container reference '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceElement#getParent <em>Parent</em>}
	 * '. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the container reference '<em>Parent</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceElement#getParent()
	 * @see #getServiceElement()
	 * @generated
	 */
	EReference getServiceElement_Parent();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.SimpleElement <em>Simple Element</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Simple Element</em>'.
	 * @see eu.mdd4soa.smm.behaviour.SimpleElement
	 * @generated
	 */
	EClass getSimpleElement();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity
	 * <em>Service Activity</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Service Activity</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity
	 * @generated
	 */
	EClass getServiceActivity();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getVariables
	 * <em>Variables</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Variables</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity#getVariables()
	 * @see #getServiceActivity()
	 * @generated
	 */
	EReference getServiceActivity_Variables();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getHandlers
	 * <em>Handlers</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Handlers</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity#getHandlers()
	 * @see #getServiceActivity()
	 * @generated
	 */
	EReference getServiceActivity_Handlers();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getInterruptingReceives
	 * <em>Interrupting Receives</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Interrupting Receives</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity#getInterruptingReceives()
	 * @see #getServiceActivity()
	 * @generated
	 */
	EReference getServiceActivity_InterruptingReceives();

	/**
	 * Returns the meta object for the container reference '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getParticipant
	 * <em>Participant</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the container reference '<em>Participant</em>
	 *         '.
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity#getParticipant()
	 * @see #getServiceActivity()
	 * @generated
	 */
	EReference getServiceActivity_Participant();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.Handler <em>Handler</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Handler</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Handler
	 * @generated
	 */
	EClass getHandler();

	/**
	 * Returns the meta object for the container reference '
	 * {@link eu.mdd4soa.smm.behaviour.Handler#getServiceActivity
	 * <em>Service Activity</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the container reference '
	 *         <em>Service Activity</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Handler#getServiceActivity()
	 * @see #getHandler()
	 * @generated
	 */
	EReference getHandler_ServiceActivity();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.behaviour.Send
	 * <em>Send</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Send</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Send
	 * @generated
	 */
	EClass getSend();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.Receive <em>Receive</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Receive</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Receive
	 * @generated
	 */
	EClass getReceive();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.Receive#getReply <em>Reply</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Reply</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Receive#getReply()
	 * @see #getReceive()
	 * @generated
	 */
	EReference getReceive_Reply();

	/**
	 * Returns the meta object for the container reference '
	 * {@link eu.mdd4soa.smm.behaviour.Receive#getInterrupting
	 * <em>Interrupting</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the container reference '
	 *         <em>Interrupting</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Receive#getInterrupting()
	 * @see #getReceive()
	 * @generated
	 */
	EReference getReceive_Interrupting();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.SendAndReceive <em>Send And Receive</em>}
	 * '. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Send And Receive</em>'.
	 * @see eu.mdd4soa.smm.behaviour.SendAndReceive
	 * @generated
	 */
	EClass getSendAndReceive();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.CompensateAll <em>Compensate All</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Compensate All</em>'.
	 * @see eu.mdd4soa.smm.behaviour.CompensateAll
	 * @generated
	 */
	EClass getCompensateAll();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.Compensate <em>Compensate</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Compensate</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Compensate
	 * @generated
	 */
	EClass getCompensate();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.Compensate#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Compensate#getTarget()
	 * @see #getCompensate()
	 * @generated
	 */
	EReference getCompensate_Target();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ExceptionHandler
	 * <em>Exception Handler</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Exception Handler</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ExceptionHandler
	 * @generated
	 */
	EClass getExceptionHandler();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.ExceptionHandler#getExceptionType
	 * <em>Exception Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Exception Type</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ExceptionHandler#getExceptionType()
	 * @see #getExceptionHandler()
	 * @generated
	 */
	EReference getExceptionHandler_ExceptionType();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.behaviour.ExceptionHandler#getCaughtException
	 * <em>Caught Exception</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the containment reference '
	 *         <em>Caught Exception</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ExceptionHandler#getCaughtException()
	 * @see #getExceptionHandler()
	 * @generated
	 */
	EReference getExceptionHandler_CaughtException();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.CompensationHandler
	 * <em>Compensation Handler</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Compensation Handler</em>'.
	 * @see eu.mdd4soa.smm.behaviour.CompensationHandler
	 * @generated
	 */
	EClass getCompensationHandler();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.PathBasedPartition
	 * <em>Path Based Partition</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Path Based Partition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.PathBasedPartition
	 * @generated
	 */
	EClass getPathBasedPartition();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.behaviour.Path
	 * <em>Path</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Path</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Path
	 * @generated
	 */
	EClass getPath();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.behaviour.Path#getEnterCondition
	 * <em>Enter Condition</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '
	 *         <em>Enter Condition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Path#getEnterCondition()
	 * @see #getPath()
	 * @generated
	 */
	EReference getPath_EnterCondition();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.Decision <em>Decision</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Decision</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Decision
	 * @generated
	 */
	EClass getDecision();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.Parallel <em>Parallel</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Parallel</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Parallel
	 * @generated
	 */
	EClass getParallel();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.behaviour.Loop
	 * <em>Loop</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Loop</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Loop
	 * @generated
	 */
	EClass getLoop();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.behaviour.Loop#getLeaveCondition
	 * <em>Leave Condition</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '
	 *         <em>Leave Condition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Loop#getLeaveCondition()
	 * @see #getLoop()
	 * @generated
	 */
	EReference getLoop_LeaveCondition();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.EventHandler <em>Event Handler</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Event Handler</em>'.
	 * @see eu.mdd4soa.smm.behaviour.EventHandler
	 * @generated
	 */
	EClass getEventHandler();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction
	 * <em>Service Interaction</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Service Interaction</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceInteraction
	 * @generated
	 */
	EClass getServiceInteraction();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getOperation
	 * <em>Operation</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Operation</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceInteraction#getOperation()
	 * @see #getServiceInteraction()
	 * @generated
	 */
	EReference getServiceInteraction_Operation();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getRcvParameters
	 * <em>Rcv Parameters</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Rcv Parameters</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceInteraction#getRcvParameters()
	 * @see #getServiceInteraction()
	 * @generated
	 */
	EReference getServiceInteraction_RcvParameters();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getSndParameters
	 * <em>Snd Parameters</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Snd Parameters</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceInteraction#getSndParameters()
	 * @see #getServiceInteraction()
	 * @generated
	 */
	EReference getServiceInteraction_SndParameters();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getPartner
	 * <em>Partner</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Partner</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceInteraction#getPartner()
	 * @see #getServiceInteraction()
	 * @generated
	 */
	EReference getServiceInteraction_Partner();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.behaviour.Throw
	 * <em>Throw</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Throw</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Throw
	 * @generated
	 */
	EClass getThrow();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.Throw#getExceptionType
	 * <em>Exception Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Exception Type</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Throw#getExceptionType()
	 * @see #getThrow()
	 * @generated
	 */
	EReference getThrow_ExceptionType();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.CompositeElement
	 * <em>Composite Element</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Composite Element</em>'.
	 * @see eu.mdd4soa.smm.behaviour.CompositeElement
	 * @generated
	 */
	EClass getCompositeElement();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.CompositeElement#getChildren
	 * <em>Children</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Children</em>'.
	 * @see eu.mdd4soa.smm.behaviour.CompositeElement#getChildren()
	 * @see #getCompositeElement()
	 * @generated
	 */
	EReference getCompositeElement_Children();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.behaviour.Reply
	 * <em>Reply</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Reply</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Reply
	 * @generated
	 */
	EClass getReply();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.Reply#getReceive <em>Receive</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Receive</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Reply#getReceive()
	 * @see #getReply()
	 * @generated
	 */
	EReference getReply_Receive();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.DataHandling <em>Data Handling</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Data Handling</em>'.
	 * @see eu.mdd4soa.smm.behaviour.DataHandling
	 * @generated
	 */
	EClass getDataHandling();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.DataHandling#getStatements
	 * <em>Statements</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Statements</em>'.
	 * @see eu.mdd4soa.smm.behaviour.DataHandling#getStatements()
	 * @see #getDataHandling()
	 * @generated
	 */
	EReference getDataHandling_Statements();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.Terminate <em>Terminate</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Terminate</em>'.
	 * @see eu.mdd4soa.smm.behaviour.Terminate
	 * @generated
	 */
	EClass getTerminate();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceProtocol
	 * <em>Service Protocol</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Service Protocol</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceProtocol
	 * @generated
	 */
	EClass getServiceProtocol();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getStates
	 * <em>States</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>States</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceProtocol#getStates()
	 * @see #getServiceProtocol()
	 * @generated
	 */
	EReference getServiceProtocol_States();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getTransitions
	 * <em>Transitions</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Transitions</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceProtocol#getTransitions()
	 * @see #getServiceProtocol()
	 * @generated
	 */
	EReference getServiceProtocol_Transitions();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getStartState
	 * <em>Start State</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Start State</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceProtocol#getStartState()
	 * @see #getServiceProtocol()
	 * @generated
	 */
	EReference getServiceProtocol_StartState();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ServiceProtocol#getName()
	 * @see #getServiceProtocol()
	 * @generated
	 */
	EAttribute getServiceProtocol_Name();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolState <em>Protocol State</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Protocol State</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolState
	 * @generated
	 */
	EClass getProtocolState();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolState#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolState#getName()
	 * @see #getProtocolState()
	 * @generated
	 */
	EAttribute getProtocolState_Name();

	/**
	 * Returns the meta object for the container reference '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolState#getProtocol
	 * <em>Protocol</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the container reference '<em>Protocol</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolState#getProtocol()
	 * @see #getProtocolState()
	 * @generated
	 */
	EReference getProtocolState_Protocol();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolTransition
	 * <em>Protocol Transition</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Protocol Transition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolTransition
	 * @generated
	 */
	EClass getProtocolTransition();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolTransition#getOperation
	 * <em>Operation</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Operation</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolTransition#getOperation()
	 * @see #getProtocolTransition()
	 * @generated
	 */
	EReference getProtocolTransition_Operation();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolTransition#isIsOptional
	 * <em>Is Optional</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Is Optional</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolTransition#isIsOptional()
	 * @see #getProtocolTransition()
	 * @generated
	 */
	EAttribute getProtocolTransition_IsOptional();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolTransition#getSource
	 * <em>Source</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolTransition#getSource()
	 * @see #getProtocolTransition()
	 * @generated
	 */
	EReference getProtocolTransition_Source();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolTransition#getTarget
	 * <em>Target</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolTransition#getTarget()
	 * @see #getProtocolTransition()
	 * @generated
	 */
	EReference getProtocolTransition_Target();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ReceivingTransition
	 * <em>Receiving Transition</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Receiving Transition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ReceivingTransition
	 * @generated
	 */
	EClass getReceivingTransition();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.SendingTransition
	 * <em>Sending Transition</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Sending Transition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.SendingTransition
	 * @generated
	 */
	EClass getSendingTransition();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ReplyingTransition
	 * <em>Replying Transition</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Replying Transition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ReplyingTransition
	 * @generated
	 */
	EClass getReplyingTransition();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.ReceiveReplyingTransition
	 * <em>Receive Replying Transition</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Receive Replying Transition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.ReceiveReplyingTransition
	 * @generated
	 */
	EClass getReceiveReplyingTransition();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.behaviour.NoopTransition <em>Noop Transition</em>}
	 * '. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Noop Transition</em>'.
	 * @see eu.mdd4soa.smm.behaviour.NoopTransition
	 * @generated
	 */
	EClass getNoopTransition();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ISMBehaviourFactory getISMBehaviourFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceElementImpl
		 * <em>Service Element</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ServiceElementImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getServiceElement()
		 * @generated
		 */
		EClass SERVICE_ELEMENT= eINSTANCE.getServiceElement();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute SERVICE_ELEMENT__NAME= eINSTANCE.getServiceElement_Name();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' container
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_ELEMENT__PARENT= eINSTANCE.getServiceElement_Parent();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.SimpleElementImpl
		 * <em>Simple Element</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.SimpleElementImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getSimpleElement()
		 * @generated
		 */
		EClass SIMPLE_ELEMENT= eINSTANCE.getSimpleElement();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceActivityImpl
		 * <em>Service Activity</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ServiceActivityImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getServiceActivity()
		 * @generated
		 */
		EClass SERVICE_ACTIVITY= eINSTANCE.getServiceActivity();

		/**
		 * The meta object literal for the '<em><b>Variables</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_ACTIVITY__VARIABLES= eINSTANCE.getServiceActivity_Variables();

		/**
		 * The meta object literal for the '<em><b>Handlers</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_ACTIVITY__HANDLERS= eINSTANCE.getServiceActivity_Handlers();

		/**
		 * The meta object literal for the '
		 * <em><b>Interrupting Receives</b></em>' containment reference list
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_ACTIVITY__INTERRUPTING_RECEIVES= eINSTANCE.getServiceActivity_InterruptingReceives();

		/**
		 * The meta object literal for the '<em><b>Participant</b></em>'
		 * container reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_ACTIVITY__PARTICIPANT= eINSTANCE.getServiceActivity_Participant();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.HandlerImpl <em>Handler</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.HandlerImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getHandler()
		 * @generated
		 */
		EClass HANDLER= eINSTANCE.getHandler();

		/**
		 * The meta object literal for the '<em><b>Service Activity</b></em>'
		 * container reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference HANDLER__SERVICE_ACTIVITY= eINSTANCE.getHandler_ServiceActivity();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.SendImpl <em>Send</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.SendImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getSend()
		 * @generated
		 */
		EClass SEND= eINSTANCE.getSend();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ReceiveImpl <em>Receive</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ReceiveImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReceive()
		 * @generated
		 */
		EClass RECEIVE= eINSTANCE.getReceive();

		/**
		 * The meta object literal for the '<em><b>Reply</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference RECEIVE__REPLY= eINSTANCE.getReceive_Reply();

		/**
		 * The meta object literal for the '<em><b>Interrupting</b></em>'
		 * container reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference RECEIVE__INTERRUPTING= eINSTANCE.getReceive_Interrupting();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.SendAndReceiveImpl
		 * <em>Send And Receive</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.SendAndReceiveImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getSendAndReceive()
		 * @generated
		 */
		EClass SEND_AND_RECEIVE= eINSTANCE.getSendAndReceive();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.CompensateAllImpl
		 * <em>Compensate All</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.CompensateAllImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getCompensateAll()
		 * @generated
		 */
		EClass COMPENSATE_ALL= eINSTANCE.getCompensateAll();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.CompensateImpl
		 * <em>Compensate</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.CompensateImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getCompensate()
		 * @generated
		 */
		EClass COMPENSATE= eINSTANCE.getCompensate();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference COMPENSATE__TARGET= eINSTANCE.getCompensate_Target();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ExceptionHandlerImpl
		 * <em>Exception Handler</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ExceptionHandlerImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getExceptionHandler()
		 * @generated
		 */
		EClass EXCEPTION_HANDLER= eINSTANCE.getExceptionHandler();

		/**
		 * The meta object literal for the '<em><b>Exception Type</b></em>'
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference EXCEPTION_HANDLER__EXCEPTION_TYPE= eINSTANCE.getExceptionHandler_ExceptionType();

		/**
		 * The meta object literal for the '<em><b>Caught Exception</b></em>'
		 * containment reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference EXCEPTION_HANDLER__CAUGHT_EXCEPTION= eINSTANCE.getExceptionHandler_CaughtException();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.CompensationHandlerImpl
		 * <em>Compensation Handler</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.CompensationHandlerImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getCompensationHandler()
		 * @generated
		 */
		EClass COMPENSATION_HANDLER= eINSTANCE.getCompensationHandler();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.PathBasedPartitionImpl
		 * <em>Path Based Partition</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.PathBasedPartitionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getPathBasedPartition()
		 * @generated
		 */
		EClass PATH_BASED_PARTITION= eINSTANCE.getPathBasedPartition();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.PathImpl <em>Path</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.PathImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getPath()
		 * @generated
		 */
		EClass PATH= eINSTANCE.getPath();

		/**
		 * The meta object literal for the '<em><b>Enter Condition</b></em>'
		 * containment reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PATH__ENTER_CONDITION= eINSTANCE.getPath_EnterCondition();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.DecisionImpl <em>Decision</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.DecisionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getDecision()
		 * @generated
		 */
		EClass DECISION= eINSTANCE.getDecision();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ParallelImpl <em>Parallel</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ParallelImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getParallel()
		 * @generated
		 */
		EClass PARALLEL= eINSTANCE.getParallel();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.LoopImpl <em>Loop</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.LoopImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getLoop()
		 * @generated
		 */
		EClass LOOP= eINSTANCE.getLoop();

		/**
		 * The meta object literal for the '<em><b>Leave Condition</b></em>'
		 * containment reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference LOOP__LEAVE_CONDITION= eINSTANCE.getLoop_LeaveCondition();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.EventHandlerImpl
		 * <em>Event Handler</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.EventHandlerImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getEventHandler()
		 * @generated
		 */
		EClass EVENT_HANDLER= eINSTANCE.getEventHandler();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceInteractionImpl
		 * <em>Service Interaction</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ServiceInteractionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getServiceInteraction()
		 * @generated
		 */
		EClass SERVICE_INTERACTION= eINSTANCE.getServiceInteraction();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_INTERACTION__OPERATION= eINSTANCE.getServiceInteraction_Operation();

		/**
		 * The meta object literal for the '<em><b>Rcv Parameters</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_INTERACTION__RCV_PARAMETERS= eINSTANCE.getServiceInteraction_RcvParameters();

		/**
		 * The meta object literal for the '<em><b>Snd Parameters</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_INTERACTION__SND_PARAMETERS= eINSTANCE.getServiceInteraction_SndParameters();

		/**
		 * The meta object literal for the '<em><b>Partner</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_INTERACTION__PARTNER= eINSTANCE.getServiceInteraction_Partner();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ThrowImpl <em>Throw</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ThrowImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getThrow()
		 * @generated
		 */
		EClass THROW= eINSTANCE.getThrow();

		/**
		 * The meta object literal for the '<em><b>Exception Type</b></em>'
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference THROW__EXCEPTION_TYPE= eINSTANCE.getThrow_ExceptionType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.CompositeElementImpl
		 * <em>Composite Element</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.CompositeElementImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getCompositeElement()
		 * @generated
		 */
		EClass COMPOSITE_ELEMENT= eINSTANCE.getCompositeElement();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference COMPOSITE_ELEMENT__CHILDREN= eINSTANCE.getCompositeElement_Children();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ReplyImpl <em>Reply</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ReplyImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReply()
		 * @generated
		 */
		EClass REPLY= eINSTANCE.getReply();

		/**
		 * The meta object literal for the '<em><b>Receive</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference REPLY__RECEIVE= eINSTANCE.getReply_Receive();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.DataHandlingImpl
		 * <em>Data Handling</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.DataHandlingImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getDataHandling()
		 * @generated
		 */
		EClass DATA_HANDLING= eINSTANCE.getDataHandling();

		/**
		 * The meta object literal for the '<em><b>Statements</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference DATA_HANDLING__STATEMENTS= eINSTANCE.getDataHandling_Statements();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.TerminateImpl
		 * <em>Terminate</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.TerminateImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getTerminate()
		 * @generated
		 */
		EClass TERMINATE= eINSTANCE.getTerminate();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceProtocolImpl
		 * <em>Service Protocol</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ServiceProtocolImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getServiceProtocol()
		 * @generated
		 */
		EClass SERVICE_PROTOCOL= eINSTANCE.getServiceProtocol();

		/**
		 * The meta object literal for the '<em><b>States</b></em>' containment
		 * reference list feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_PROTOCOL__STATES= eINSTANCE.getServiceProtocol_States();

		/**
		 * The meta object literal for the '<em><b>Transitions</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_PROTOCOL__TRANSITIONS= eINSTANCE.getServiceProtocol_Transitions();

		/**
		 * The meta object literal for the '<em><b>Start State</b></em>'
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE_PROTOCOL__START_STATE= eINSTANCE.getServiceProtocol_StartState();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute SERVICE_PROTOCOL__NAME= eINSTANCE.getServiceProtocol_Name();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ProtocolStateImpl
		 * <em>Protocol State</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ProtocolStateImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getProtocolState()
		 * @generated
		 */
		EClass PROTOCOL_STATE= eINSTANCE.getProtocolState();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute PROTOCOL_STATE__NAME= eINSTANCE.getProtocolState_Name();

		/**
		 * The meta object literal for the '<em><b>Protocol</b></em>' container
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PROTOCOL_STATE__PROTOCOL= eINSTANCE.getProtocolState_Protocol();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ProtocolTransitionImpl
		 * <em>Protocol Transition</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ProtocolTransitionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getProtocolTransition()
		 * @generated
		 */
		EClass PROTOCOL_TRANSITION= eINSTANCE.getProtocolTransition();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PROTOCOL_TRANSITION__OPERATION= eINSTANCE.getProtocolTransition_Operation();

		/**
		 * The meta object literal for the '<em><b>Is Optional</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute PROTOCOL_TRANSITION__IS_OPTIONAL= eINSTANCE.getProtocolTransition_IsOptional();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PROTOCOL_TRANSITION__SOURCE= eINSTANCE.getProtocolTransition_Source();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PROTOCOL_TRANSITION__TARGET= eINSTANCE.getProtocolTransition_Target();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ReceivingTransitionImpl
		 * <em>Receiving Transition</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ReceivingTransitionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReceivingTransition()
		 * @generated
		 */
		EClass RECEIVING_TRANSITION= eINSTANCE.getReceivingTransition();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.SendingTransitionImpl
		 * <em>Sending Transition</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.SendingTransitionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getSendingTransition()
		 * @generated
		 */
		EClass SENDING_TRANSITION= eINSTANCE.getSendingTransition();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ReplyingTransitionImpl
		 * <em>Replying Transition</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ReplyingTransitionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReplyingTransition()
		 * @generated
		 */
		EClass REPLYING_TRANSITION= eINSTANCE.getReplyingTransition();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.ReceiveReplyingTransitionImpl
		 * <em>Receive Replying Transition</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.ReceiveReplyingTransitionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getReceiveReplyingTransition()
		 * @generated
		 */
		EClass RECEIVE_REPLYING_TRANSITION= eINSTANCE.getReceiveReplyingTransition();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.behaviour.impl.NoopTransitionImpl
		 * <em>Noop Transition</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.behaviour.impl.NoopTransitionImpl
		 * @see eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl#getNoopTransition()
		 * @generated
		 */
		EClass NOOP_TRANSITION= eINSTANCE.getNoopTransition();

	}

} // ISMBehaviourPackage
