/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;


/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Receive</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.Receive#getReply <em>Reply</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.Receive#getInterrupting <em>Interrupting
 * </em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getReceive()
 * @model
 * @generated
 */
public interface Receive extends ServiceInteraction {

	/**
	 * Returns the value of the '<em><b>Reply</b></em>' reference. It is
	 * bidirectional and its opposite is '
	 * {@link eu.mdd4soa.smm.behaviour.Reply#getReceive <em>Receive</em>}'. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reply</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Reply</em>' reference.
	 * @see #setReply(Reply)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getReceive_Reply()
	 * @see eu.mdd4soa.smm.behaviour.Reply#getReceive
	 * @model opposite="receive"
	 * @generated
	 */
	Reply getReply();

	/**
	 * Sets the value of the '{@link eu.mdd4soa.smm.behaviour.Receive#getReply
	 * <em>Reply</em>}' reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Reply</em>' reference.
	 * @see #getReply()
	 * @generated
	 */
	void setReply(Reply value);

	/**
	 * Returns the value of the '<em><b>Interrupting</b></em>' container
	 * reference. It is bidirectional and its opposite is '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getInterruptingReceives
	 * <em>Interrupting Receives</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interrupting</em>' container reference isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Interrupting</em>' container reference.
	 * @see #setInterrupting(ServiceActivity)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getReceive_Interrupting()
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity#getInterruptingReceives
	 * @model opposite="interruptingReceives" transient="false"
	 * @generated
	 */
	ServiceActivity getInterrupting();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.Receive#getInterrupting
	 * <em>Interrupting</em>}' container reference. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Interrupting</em>' container
	 *        reference.
	 * @see #getInterrupting()
	 * @generated
	 */
	void setInterrupting(ServiceActivity value);
} // Receive
