/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;

import org.eclipse.emf.common.util.EList;

import eu.mdd4soa.smm.data.Variable;
import eu.mdd4soa.smm.statik.Participant;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Service Activity</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceActivity#getVariables <em>
 * Variables</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceActivity#getHandlers <em>Handlers
 * </em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceActivity#getInterruptingReceives
 * <em>Interrupting Receives</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceActivity#getParticipant <em>
 * Participant</em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceActivity()
 * @model
 * @generated
 */
public interface ServiceActivity extends CompositeElement {
	/**
	 * Returns the value of the '<em><b>Variables</b></em>' containment
	 * reference list. The list contents are of type
	 * {@link eu.mdd4soa.smm.data.Variable}. It is bidirectional and its
	 * opposite is '{@link eu.mdd4soa.smm.data.Variable#getServiceActivity
	 * <em>Service Activity</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Variables</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Variables</em>' containment reference list.
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceActivity_Variables()
	 * @see eu.mdd4soa.smm.data.Variable#getServiceActivity
	 * @model opposite="serviceActivity" containment="true"
	 * @generated
	 */
	EList<Variable> getVariables();

	/**
	 * Returns the value of the '<em><b>Handlers</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link eu.mdd4soa.smm.behaviour.Handler}. It is bidirectional and its
	 * opposite is '{@link eu.mdd4soa.smm.behaviour.Handler#getServiceActivity
	 * <em>Service Activity</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Handlers</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Handlers</em>' containment reference list.
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceActivity_Handlers()
	 * @see eu.mdd4soa.smm.behaviour.Handler#getServiceActivity
	 * @model opposite="serviceActivity" containment="true"
	 * @generated
	 */
	EList<Handler> getHandlers();

	/**
	 * Returns the value of the '<em><b>Interrupting Receives</b></em>'
	 * containment reference list. The list contents are of type
	 * {@link eu.mdd4soa.smm.behaviour.Receive}. It is bidirectional and its
	 * opposite is '{@link eu.mdd4soa.smm.behaviour.Receive#getInterrupting
	 * <em>Interrupting</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interrupting Receives</em>' containment
	 * reference list isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Interrupting Receives</em>' containment
	 *         reference list.
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceActivity_InterruptingReceives()
	 * @see eu.mdd4soa.smm.behaviour.Receive#getInterrupting
	 * @model opposite="interrupting" containment="true"
	 * @generated
	 */
	EList<Receive> getInterruptingReceives();

	/**
	 * Returns the value of the '<em><b>Participant</b></em>' container
	 * reference. It is bidirectional and its opposite is '
	 * {@link eu.mdd4soa.smm.statik.Participant#getBehaviours
	 * <em>Behaviours</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Participant</em>' container reference isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Participant</em>' container reference.
	 * @see #setParticipant(Participant)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceActivity_Participant()
	 * @see eu.mdd4soa.smm.statik.Participant#getBehaviours
	 * @model opposite="behaviours" transient="false"
	 * @generated
	 */
	Participant getParticipant();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getParticipant
	 * <em>Participant</em>}' container reference. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Participant</em>' container
	 *        reference.
	 * @see #getParticipant()
	 * @generated
	 */
	void setParticipant(Participant value);

} // ServiceActivity
