/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;

import org.eclipse.emf.common.util.EList;

import eu.mdd4soa.smm.data.InteractionParameter;
import eu.mdd4soa.smm.statik.InterfaceOperation;
import eu.mdd4soa.smm.statik.Service;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Service Interaction</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getOperation <em>
 * Operation</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getRcvParameters <em>
 * Rcv Parameters</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getSndParameters <em>
 * Snd Parameters</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getPartner <em>Partner
 * </em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceInteraction()
 * @model abstract="true"
 * @generated
 */
public interface ServiceInteraction extends SimpleElement {
	/**
	 * Returns the value of the '<em><b>Operation</b></em>' reference. It is
	 * bidirectional and its opposite is '
	 * {@link eu.mdd4soa.smm.statik.InterfaceOperation#getUsedIn
	 * <em>Used In</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operation</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Operation</em>' reference.
	 * @see #setOperation(InterfaceOperation)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceInteraction_Operation()
	 * @see eu.mdd4soa.smm.statik.InterfaceOperation#getUsedIn
	 * @model opposite="usedIn"
	 * @generated
	 */
	InterfaceOperation getOperation();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getOperation
	 * <em>Operation</em>}' reference. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value the new value of the '<em>Operation</em>' reference.
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(InterfaceOperation value);

	/**
	 * Returns the value of the '<em><b>Rcv Parameters</b></em>' containment
	 * reference list. The list contents are of type
	 * {@link eu.mdd4soa.smm.data.InteractionParameter}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Rcv Parameters</em>' containment reference
	 * list isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Rcv Parameters</em>' containment reference
	 *         list.
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceInteraction_RcvParameters()
	 * @model containment="true"
	 * @generated
	 */
	EList<InteractionParameter> getRcvParameters();

	/**
	 * Returns the value of the '<em><b>Snd Parameters</b></em>' containment
	 * reference list. The list contents are of type
	 * {@link eu.mdd4soa.smm.data.InteractionParameter}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Snd Parameters</em>' containment reference
	 * list isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Snd Parameters</em>' containment reference
	 *         list.
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceInteraction_SndParameters()
	 * @model containment="true"
	 * @generated
	 */
	EList<InteractionParameter> getSndParameters();

	/**
	 * Returns the value of the '<em><b>Partner</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Partner</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Partner</em>' reference.
	 * @see #setPartner(Service)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceInteraction_Partner()
	 * @model required="true"
	 * @generated
	 */
	Service getPartner();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getPartner
	 * <em>Partner</em>}' reference. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value the new value of the '<em>Partner</em>' reference.
	 * @see #getPartner()
	 * @generated
	 */
	void setPartner(Service value);

} // ServiceInteraction
