/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Service Protocol</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getStates <em>States
 * </em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getTransitions <em>
 * Transitions</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getStartState <em>Start
 * State</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceProtocol()
 * @model
 * @generated
 */
public interface ServiceProtocol extends EObject {
	/**
	 * Returns the value of the '<em><b>States</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolState}. It is bidirectional and
	 * its opposite is '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolState#getProtocol
	 * <em>Protocol</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>States</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>States</em>' containment reference list.
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceProtocol_States()
	 * @see eu.mdd4soa.smm.behaviour.ProtocolState#getProtocol
	 * @model opposite="protocol" containment="true"
	 * @generated
	 */
	EList<ProtocolState> getStates();

	/**
	 * Returns the value of the '<em><b>Transitions</b></em>' containment
	 * reference list. The list contents are of type
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolTransition}. <!-- begin-user-doc
	 * -->
	 * <p>
	 * If the meaning of the '<em>Transitions</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Transitions</em>' containment reference
	 *         list.
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceProtocol_Transitions()
	 * @model containment="true"
	 * @generated
	 */
	EList<ProtocolTransition> getTransitions();

	/**
	 * Returns the value of the '<em><b>Start State</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Start State</em>' containment reference isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Start State</em>' reference.
	 * @see #setStartState(ProtocolState)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceProtocol_StartState()
	 * @model
	 * @generated
	 */
	ProtocolState getStartState();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getStartState
	 * <em>Start State</em>}' reference. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Start State</em>' reference.
	 * @see #getStartState()
	 * @generated
	 */
	void setStartState(ProtocolState value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#getServiceProtocol_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceProtocol#getName <em>Name</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

} // ServiceProtocol
