/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.mdd4soa.smm.behaviour.ExceptionHandler;
import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.data.VariableReference;
import eu.mdd4soa.smm.statik.ExceptionType;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Exception Handler</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link eu.mdd4soa.smm.behaviour.impl.ExceptionHandlerImpl#getExceptionType
 * <em>Exception Type</em>}</li>
 * <li>
 * {@link eu.mdd4soa.smm.behaviour.impl.ExceptionHandlerImpl#getCaughtException
 * <em>Caught Exception</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ExceptionHandlerImpl extends HandlerImpl implements ExceptionHandler {
	/**
	 * The cached value of the '{@link #getExceptionType()
	 * <em>Exception Type</em>}' reference. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getExceptionType()
	 * @generated
	 * @ordered
	 */
	protected ExceptionType exceptionType;

	/**
	 * The cached value of the '{@link #getCaughtException()
	 * <em>Caught Exception</em>}' containment reference. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getCaughtException()
	 * @generated
	 * @ordered
	 */
	protected VariableReference caughtException;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExceptionHandlerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMBehaviourPackage.Literals.EXCEPTION_HANDLER;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ExceptionType getExceptionType() {
		if (exceptionType != null && exceptionType.eIsProxy()) {
			InternalEObject oldExceptionType= (InternalEObject) exceptionType;
			exceptionType= (ExceptionType) eResolveProxy(oldExceptionType);
			if (exceptionType != oldExceptionType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMBehaviourPackage.EXCEPTION_HANDLER__EXCEPTION_TYPE,
							oldExceptionType, exceptionType));
			}
		}
		return exceptionType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ExceptionType basicGetExceptionType() {
		return exceptionType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setExceptionType(ExceptionType newExceptionType) {
		ExceptionType oldExceptionType= exceptionType;
		exceptionType= newExceptionType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.EXCEPTION_HANDLER__EXCEPTION_TYPE, oldExceptionType,
					exceptionType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public VariableReference getCaughtException() {
		return caughtException;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetCaughtException(VariableReference newCaughtException, NotificationChain msgs) {
		VariableReference oldCaughtException= caughtException;
		caughtException= newCaughtException;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION,
					oldCaughtException, newCaughtException);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setCaughtException(VariableReference newCaughtException) {
		if (newCaughtException != caughtException) {
			NotificationChain msgs= null;
			if (caughtException != null)
				msgs= ((InternalEObject) caughtException).eInverseRemove(this, EOPPOSITE_FEATURE_BASE
						- ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION, null, msgs);
			if (newCaughtException != null)
				msgs= ((InternalEObject) newCaughtException).eInverseAdd(this, EOPPOSITE_FEATURE_BASE
						- ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION, null, msgs);
			msgs= basicSetCaughtException(newCaughtException, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION, newCaughtException,
					newCaughtException));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION:
				return basicSetCaughtException(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMBehaviourPackage.EXCEPTION_HANDLER__EXCEPTION_TYPE:
				if (resolve)
					return getExceptionType();
				return basicGetExceptionType();
			case ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION:
				return getCaughtException();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMBehaviourPackage.EXCEPTION_HANDLER__EXCEPTION_TYPE:
				setExceptionType((ExceptionType) newValue);
				return;
			case ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION:
				setCaughtException((VariableReference) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.EXCEPTION_HANDLER__EXCEPTION_TYPE:
				setExceptionType((ExceptionType) null);
				return;
			case ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION:
				setCaughtException((VariableReference) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.EXCEPTION_HANDLER__EXCEPTION_TYPE:
				return exceptionType != null;
			case ISMBehaviourPackage.EXCEPTION_HANDLER__CAUGHT_EXCEPTION:
				return caughtException != null;
		}
		return super.eIsSet(featureID);
	}

} // ExceptionHandlerImpl
