/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import eu.mdd4soa.smm.behaviour.Compensate;
import eu.mdd4soa.smm.behaviour.CompensateAll;
import eu.mdd4soa.smm.behaviour.CompensationHandler;
import eu.mdd4soa.smm.behaviour.DataHandling;
import eu.mdd4soa.smm.behaviour.Decision;
import eu.mdd4soa.smm.behaviour.EventHandler;
import eu.mdd4soa.smm.behaviour.ExceptionHandler;
import eu.mdd4soa.smm.behaviour.ISMBehaviourFactory;
import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.Loop;
import eu.mdd4soa.smm.behaviour.NoopTransition;
import eu.mdd4soa.smm.behaviour.Parallel;
import eu.mdd4soa.smm.behaviour.Path;
import eu.mdd4soa.smm.behaviour.ProtocolState;
import eu.mdd4soa.smm.behaviour.Receive;
import eu.mdd4soa.smm.behaviour.ReceiveReplyingTransition;
import eu.mdd4soa.smm.behaviour.ReceivingTransition;
import eu.mdd4soa.smm.behaviour.Reply;
import eu.mdd4soa.smm.behaviour.ReplyingTransition;
import eu.mdd4soa.smm.behaviour.Send;
import eu.mdd4soa.smm.behaviour.SendAndReceive;
import eu.mdd4soa.smm.behaviour.SendingTransition;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.behaviour.ServiceProtocol;
import eu.mdd4soa.smm.behaviour.Terminate;
import eu.mdd4soa.smm.behaviour.Throw;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class ISMBehaviourFactoryImpl extends EFactoryImpl implements ISMBehaviourFactory {
	/**
	 * Creates the default factory implementation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static ISMBehaviourFactory init() {
		try {
			ISMBehaviourFactory theISMBehaviourFactory= (ISMBehaviourFactory) EPackage.Registry.INSTANCE
					.getEFactory("http://www.mdd4soa.eu/ism/behaviour");
			if (theISMBehaviourFactory != null) {
				return theISMBehaviourFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new ISMBehaviourFactoryImpl();
	}

	/**
	 * Creates an instance of the factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMBehaviourFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ISMBehaviourPackage.SERVICE_ACTIVITY:
				return createServiceActivity();
			case ISMBehaviourPackage.SEND:
				return createSend();
			case ISMBehaviourPackage.RECEIVE:
				return createReceive();
			case ISMBehaviourPackage.SEND_AND_RECEIVE:
				return createSendAndReceive();
			case ISMBehaviourPackage.COMPENSATE_ALL:
				return createCompensateAll();
			case ISMBehaviourPackage.COMPENSATE:
				return createCompensate();
			case ISMBehaviourPackage.EXCEPTION_HANDLER:
				return createExceptionHandler();
			case ISMBehaviourPackage.COMPENSATION_HANDLER:
				return createCompensationHandler();
			case ISMBehaviourPackage.PATH:
				return createPath();
			case ISMBehaviourPackage.DECISION:
				return createDecision();
			case ISMBehaviourPackage.PARALLEL:
				return createParallel();
			case ISMBehaviourPackage.LOOP:
				return createLoop();
			case ISMBehaviourPackage.EVENT_HANDLER:
				return createEventHandler();
			case ISMBehaviourPackage.THROW:
				return createThrow();
			case ISMBehaviourPackage.REPLY:
				return createReply();
			case ISMBehaviourPackage.DATA_HANDLING:
				return createDataHandling();
			case ISMBehaviourPackage.TERMINATE:
				return createTerminate();
			case ISMBehaviourPackage.SERVICE_PROTOCOL:
				return createServiceProtocol();
			case ISMBehaviourPackage.PROTOCOL_STATE:
				return createProtocolState();
			case ISMBehaviourPackage.RECEIVING_TRANSITION:
				return createReceivingTransition();
			case ISMBehaviourPackage.SENDING_TRANSITION:
				return createSendingTransition();
			case ISMBehaviourPackage.REPLYING_TRANSITION:
				return createReplyingTransition();
			case ISMBehaviourPackage.RECEIVE_REPLYING_TRANSITION:
				return createReceiveReplyingTransition();
			case ISMBehaviourPackage.NOOP_TRANSITION:
				return createNoopTransition();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ServiceActivity createServiceActivity() {
		ServiceActivityImpl serviceActivity= new ServiceActivityImpl();
		return serviceActivity;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Send createSend() {
		SendImpl send= new SendImpl();
		return send;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Receive createReceive() {
		ReceiveImpl receive= new ReceiveImpl();
		return receive;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public SendAndReceive createSendAndReceive() {
		SendAndReceiveImpl sendAndReceive= new SendAndReceiveImpl();
		return sendAndReceive;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public CompensateAll createCompensateAll() {
		CompensateAllImpl compensateAll= new CompensateAllImpl();
		return compensateAll;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Compensate createCompensate() {
		CompensateImpl compensate= new CompensateImpl();
		return compensate;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ExceptionHandler createExceptionHandler() {
		ExceptionHandlerImpl exceptionHandler= new ExceptionHandlerImpl();
		return exceptionHandler;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public CompensationHandler createCompensationHandler() {
		CompensationHandlerImpl compensationHandler= new CompensationHandlerImpl();
		return compensationHandler;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Path createPath() {
		PathImpl path= new PathImpl();
		return path;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Decision createDecision() {
		DecisionImpl decision= new DecisionImpl();
		return decision;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Parallel createParallel() {
		ParallelImpl parallel= new ParallelImpl();
		return parallel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Loop createLoop() {
		LoopImpl loop= new LoopImpl();
		return loop;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EventHandler createEventHandler() {
		EventHandlerImpl eventHandler= new EventHandlerImpl();
		return eventHandler;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Throw createThrow() {
		ThrowImpl throw_= new ThrowImpl();
		return throw_;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Reply createReply() {
		ReplyImpl reply= new ReplyImpl();
		return reply;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public DataHandling createDataHandling() {
		DataHandlingImpl dataHandling= new DataHandlingImpl();
		return dataHandling;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Terminate createTerminate() {
		TerminateImpl terminate= new TerminateImpl();
		return terminate;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ServiceProtocol createServiceProtocol() {
		ServiceProtocolImpl serviceProtocol= new ServiceProtocolImpl();
		return serviceProtocol;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProtocolState createProtocolState() {
		ProtocolStateImpl protocolState= new ProtocolStateImpl();
		return protocolState;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ReceivingTransition createReceivingTransition() {
		ReceivingTransitionImpl receivingTransition= new ReceivingTransitionImpl();
		return receivingTransition;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public SendingTransition createSendingTransition() {
		SendingTransitionImpl sendingTransition= new SendingTransitionImpl();
		return sendingTransition;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ReplyingTransition createReplyingTransition() {
		ReplyingTransitionImpl replyingTransition= new ReplyingTransitionImpl();
		return replyingTransition;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ReceiveReplyingTransition createReceiveReplyingTransition() {
		ReceiveReplyingTransitionImpl receiveReplyingTransition= new ReceiveReplyingTransitionImpl();
		return receiveReplyingTransition;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NoopTransition createNoopTransition() {
		NoopTransitionImpl noopTransition= new NoopTransitionImpl();
		return noopTransition;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMBehaviourPackage getISMBehaviourPackage() {
		return (ISMBehaviourPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ISMBehaviourPackage getPackage() {
		return ISMBehaviourPackage.eINSTANCE;
	}

} // ISMBehaviourFactoryImpl
