/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import eu.mdd4soa.smm.behaviour.Compensate;
import eu.mdd4soa.smm.behaviour.CompensateAll;
import eu.mdd4soa.smm.behaviour.CompensationHandler;
import eu.mdd4soa.smm.behaviour.CompositeElement;
import eu.mdd4soa.smm.behaviour.DataHandling;
import eu.mdd4soa.smm.behaviour.Decision;
import eu.mdd4soa.smm.behaviour.EventHandler;
import eu.mdd4soa.smm.behaviour.ExceptionHandler;
import eu.mdd4soa.smm.behaviour.Handler;
import eu.mdd4soa.smm.behaviour.ISMBehaviourFactory;
import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.Loop;
import eu.mdd4soa.smm.behaviour.NoopTransition;
import eu.mdd4soa.smm.behaviour.Parallel;
import eu.mdd4soa.smm.behaviour.Path;
import eu.mdd4soa.smm.behaviour.PathBasedPartition;
import eu.mdd4soa.smm.behaviour.ProtocolState;
import eu.mdd4soa.smm.behaviour.ProtocolTransition;
import eu.mdd4soa.smm.behaviour.Receive;
import eu.mdd4soa.smm.behaviour.ReceiveReplyingTransition;
import eu.mdd4soa.smm.behaviour.ReceivingTransition;
import eu.mdd4soa.smm.behaviour.Reply;
import eu.mdd4soa.smm.behaviour.ReplyingTransition;
import eu.mdd4soa.smm.behaviour.Send;
import eu.mdd4soa.smm.behaviour.SendAndReceive;
import eu.mdd4soa.smm.behaviour.SendingTransition;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.behaviour.ServiceElement;
import eu.mdd4soa.smm.behaviour.ServiceInteraction;
import eu.mdd4soa.smm.behaviour.ServiceProtocol;
import eu.mdd4soa.smm.behaviour.SimpleElement;
import eu.mdd4soa.smm.behaviour.Terminate;
import eu.mdd4soa.smm.behaviour.Throw;
import eu.mdd4soa.smm.data.ISMDataPackage;
import eu.mdd4soa.smm.data.impl.ISMDataPackageImpl;
import eu.mdd4soa.smm.statik.ISMStatikPackage;
import eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class ISMBehaviourPackageImpl extends EPackageImpl implements ISMBehaviourPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass serviceElementEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass simpleElementEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass serviceActivityEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass handlerEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass sendEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass receiveEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass sendAndReceiveEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass compensateAllEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass compensateEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass exceptionHandlerEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass compensationHandlerEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass pathBasedPartitionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass pathEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass decisionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass parallelEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass loopEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass eventHandlerEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass serviceInteractionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass throwEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass compositeElementEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass replyEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass dataHandlingEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass terminateEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass serviceProtocolEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass protocolStateEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass protocolTransitionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass receivingTransitionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass sendingTransitionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass replyingTransitionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass receiveReplyingTransitionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass noopTransitionEClass= null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ISMBehaviourPackageImpl() {
		super(eNS_URI, ISMBehaviourFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static boolean isInited= false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link ISMBehaviourPackage#eINSTANCE}
	 * when that field is accessed. Clients should not invoke it directly.
	 * Instead, they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ISMBehaviourPackage init() {
		if (isInited)
			return (ISMBehaviourPackage) EPackage.Registry.INSTANCE.getEPackage(ISMBehaviourPackage.eNS_URI);

		// Obtain or create and register package
		ISMBehaviourPackageImpl theISMBehaviourPackage= (ISMBehaviourPackageImpl) (EPackage.Registry.INSTANCE.get(eNS_URI) instanceof ISMBehaviourPackageImpl
				? EPackage.Registry.INSTANCE.get(eNS_URI)
				: new ISMBehaviourPackageImpl());

		isInited= true;

		// Obtain or create and register interdependencies
		ISMStatikPackageImpl theISMStatikPackage= (ISMStatikPackageImpl) (EPackage.Registry.INSTANCE.getEPackage(ISMStatikPackage.eNS_URI) instanceof ISMStatikPackageImpl
				? EPackage.Registry.INSTANCE.getEPackage(ISMStatikPackage.eNS_URI)
				: ISMStatikPackage.eINSTANCE);
		ISMDataPackageImpl theISMDataPackage= (ISMDataPackageImpl) (EPackage.Registry.INSTANCE.getEPackage(ISMDataPackage.eNS_URI) instanceof ISMDataPackageImpl
				? EPackage.Registry.INSTANCE.getEPackage(ISMDataPackage.eNS_URI)
				: ISMDataPackage.eINSTANCE);

		// Create package meta-data objects
		theISMBehaviourPackage.createPackageContents();
		theISMStatikPackage.createPackageContents();
		theISMDataPackage.createPackageContents();

		// Initialize created meta-data
		theISMBehaviourPackage.initializePackageContents();
		theISMStatikPackage.initializePackageContents();
		theISMDataPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theISMBehaviourPackage.freeze();


		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ISMBehaviourPackage.eNS_URI, theISMBehaviourPackage);
		return theISMBehaviourPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getServiceElement() {
		return serviceElementEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getServiceElement_Name() {
		return (EAttribute) serviceElementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceElement_Parent() {
		return (EReference) serviceElementEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getSimpleElement() {
		return simpleElementEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getServiceActivity() {
		return serviceActivityEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceActivity_Variables() {
		return (EReference) serviceActivityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceActivity_Handlers() {
		return (EReference) serviceActivityEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceActivity_InterruptingReceives() {
		return (EReference) serviceActivityEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceActivity_Participant() {
		return (EReference) serviceActivityEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getHandler() {
		return handlerEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getHandler_ServiceActivity() {
		return (EReference) handlerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getSend() {
		return sendEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getReceive() {
		return receiveEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getReceive_Reply() {
		return (EReference) receiveEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getReceive_Interrupting() {
		return (EReference) receiveEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getSendAndReceive() {
		return sendAndReceiveEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getCompensateAll() {
		return compensateAllEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getCompensate() {
		return compensateEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getCompensate_Target() {
		return (EReference) compensateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getExceptionHandler() {
		return exceptionHandlerEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getExceptionHandler_ExceptionType() {
		return (EReference) exceptionHandlerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getExceptionHandler_CaughtException() {
		return (EReference) exceptionHandlerEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getCompensationHandler() {
		return compensationHandlerEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getPathBasedPartition() {
		return pathBasedPartitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getPath() {
		return pathEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getPath_EnterCondition() {
		return (EReference) pathEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getDecision() {
		return decisionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getParallel() {
		return parallelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getLoop() {
		return loopEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getLoop_LeaveCondition() {
		return (EReference) loopEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getEventHandler() {
		return eventHandlerEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getServiceInteraction() {
		return serviceInteractionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceInteraction_Operation() {
		return (EReference) serviceInteractionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceInteraction_RcvParameters() {
		return (EReference) serviceInteractionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceInteraction_SndParameters() {
		return (EReference) serviceInteractionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceInteraction_Partner() {
		return (EReference) serviceInteractionEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getThrow() {
		return throwEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getThrow_ExceptionType() {
		return (EReference) throwEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getCompositeElement() {
		return compositeElementEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getCompositeElement_Children() {
		return (EReference) compositeElementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getReply() {
		return replyEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getReply_Receive() {
		return (EReference) replyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getDataHandling() {
		return dataHandlingEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getDataHandling_Statements() {
		return (EReference) dataHandlingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getTerminate() {
		return terminateEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getServiceProtocol() {
		return serviceProtocolEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceProtocol_States() {
		return (EReference) serviceProtocolEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceProtocol_Transitions() {
		return (EReference) serviceProtocolEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getServiceProtocol_StartState() {
		return (EReference) serviceProtocolEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getServiceProtocol_Name() {
		return (EAttribute) serviceProtocolEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getProtocolState() {
		return protocolStateEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getProtocolState_Name() {
		return (EAttribute) protocolStateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getProtocolState_Protocol() {
		return (EReference) protocolStateEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getProtocolTransition() {
		return protocolTransitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getProtocolTransition_Operation() {
		return (EReference) protocolTransitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getProtocolTransition_IsOptional() {
		return (EAttribute) protocolTransitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getProtocolTransition_Source() {
		return (EReference) protocolTransitionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getProtocolTransition_Target() {
		return (EReference) protocolTransitionEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getReceivingTransition() {
		return receivingTransitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getSendingTransition() {
		return sendingTransitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getReplyingTransition() {
		return replyingTransitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getReceiveReplyingTransition() {
		return receiveReplyingTransitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getNoopTransition() {
		return noopTransitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMBehaviourFactory getISMBehaviourFactory() {
		return (ISMBehaviourFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isCreated= false;

	/**
	 * Creates the meta-model objects for the package. This method is guarded to
	 * have no affect on any invocation but its first. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated)
			return;
		isCreated= true;

		// Create classes and their features
		serviceElementEClass= createEClass(SERVICE_ELEMENT);
		createEAttribute(serviceElementEClass, SERVICE_ELEMENT__NAME);
		createEReference(serviceElementEClass, SERVICE_ELEMENT__PARENT);

		simpleElementEClass= createEClass(SIMPLE_ELEMENT);

		serviceActivityEClass= createEClass(SERVICE_ACTIVITY);
		createEReference(serviceActivityEClass, SERVICE_ACTIVITY__VARIABLES);
		createEReference(serviceActivityEClass, SERVICE_ACTIVITY__HANDLERS);
		createEReference(serviceActivityEClass, SERVICE_ACTIVITY__INTERRUPTING_RECEIVES);
		createEReference(serviceActivityEClass, SERVICE_ACTIVITY__PARTICIPANT);

		handlerEClass= createEClass(HANDLER);
		createEReference(handlerEClass, HANDLER__SERVICE_ACTIVITY);

		sendEClass= createEClass(SEND);

		receiveEClass= createEClass(RECEIVE);
		createEReference(receiveEClass, RECEIVE__REPLY);
		createEReference(receiveEClass, RECEIVE__INTERRUPTING);

		sendAndReceiveEClass= createEClass(SEND_AND_RECEIVE);

		compensateAllEClass= createEClass(COMPENSATE_ALL);

		compensateEClass= createEClass(COMPENSATE);
		createEReference(compensateEClass, COMPENSATE__TARGET);

		exceptionHandlerEClass= createEClass(EXCEPTION_HANDLER);
		createEReference(exceptionHandlerEClass, EXCEPTION_HANDLER__EXCEPTION_TYPE);
		createEReference(exceptionHandlerEClass, EXCEPTION_HANDLER__CAUGHT_EXCEPTION);

		compensationHandlerEClass= createEClass(COMPENSATION_HANDLER);

		pathBasedPartitionEClass= createEClass(PATH_BASED_PARTITION);

		pathEClass= createEClass(PATH);
		createEReference(pathEClass, PATH__ENTER_CONDITION);

		decisionEClass= createEClass(DECISION);

		parallelEClass= createEClass(PARALLEL);

		loopEClass= createEClass(LOOP);
		createEReference(loopEClass, LOOP__LEAVE_CONDITION);

		eventHandlerEClass= createEClass(EVENT_HANDLER);

		serviceInteractionEClass= createEClass(SERVICE_INTERACTION);
		createEReference(serviceInteractionEClass, SERVICE_INTERACTION__OPERATION);
		createEReference(serviceInteractionEClass, SERVICE_INTERACTION__RCV_PARAMETERS);
		createEReference(serviceInteractionEClass, SERVICE_INTERACTION__SND_PARAMETERS);
		createEReference(serviceInteractionEClass, SERVICE_INTERACTION__PARTNER);

		throwEClass= createEClass(THROW);
		createEReference(throwEClass, THROW__EXCEPTION_TYPE);

		compositeElementEClass= createEClass(COMPOSITE_ELEMENT);
		createEReference(compositeElementEClass, COMPOSITE_ELEMENT__CHILDREN);

		replyEClass= createEClass(REPLY);
		createEReference(replyEClass, REPLY__RECEIVE);

		dataHandlingEClass= createEClass(DATA_HANDLING);
		createEReference(dataHandlingEClass, DATA_HANDLING__STATEMENTS);

		terminateEClass= createEClass(TERMINATE);

		serviceProtocolEClass= createEClass(SERVICE_PROTOCOL);
		createEReference(serviceProtocolEClass, SERVICE_PROTOCOL__STATES);
		createEReference(serviceProtocolEClass, SERVICE_PROTOCOL__TRANSITIONS);
		createEReference(serviceProtocolEClass, SERVICE_PROTOCOL__START_STATE);
		createEAttribute(serviceProtocolEClass, SERVICE_PROTOCOL__NAME);

		protocolStateEClass= createEClass(PROTOCOL_STATE);
		createEAttribute(protocolStateEClass, PROTOCOL_STATE__NAME);
		createEReference(protocolStateEClass, PROTOCOL_STATE__PROTOCOL);

		protocolTransitionEClass= createEClass(PROTOCOL_TRANSITION);
		createEReference(protocolTransitionEClass, PROTOCOL_TRANSITION__OPERATION);
		createEAttribute(protocolTransitionEClass, PROTOCOL_TRANSITION__IS_OPTIONAL);
		createEReference(protocolTransitionEClass, PROTOCOL_TRANSITION__SOURCE);
		createEReference(protocolTransitionEClass, PROTOCOL_TRANSITION__TARGET);

		receivingTransitionEClass= createEClass(RECEIVING_TRANSITION);

		sendingTransitionEClass= createEClass(SENDING_TRANSITION);

		replyingTransitionEClass= createEClass(REPLYING_TRANSITION);

		receiveReplyingTransitionEClass= createEClass(RECEIVE_REPLYING_TRANSITION);

		noopTransitionEClass= createEClass(NOOP_TRANSITION);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isInitialized= false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized)
			return;
		isInitialized= true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		ISMDataPackage theISMDataPackage= (ISMDataPackage) EPackage.Registry.INSTANCE.getEPackage(ISMDataPackage.eNS_URI);
		ISMStatikPackage theISMStatikPackage= (ISMStatikPackage) EPackage.Registry.INSTANCE.getEPackage(ISMStatikPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		simpleElementEClass.getESuperTypes().add(this.getServiceElement());
		serviceActivityEClass.getESuperTypes().add(this.getCompositeElement());
		handlerEClass.getESuperTypes().add(this.getCompositeElement());
		sendEClass.getESuperTypes().add(this.getServiceInteraction());
		receiveEClass.getESuperTypes().add(this.getServiceInteraction());
		sendAndReceiveEClass.getESuperTypes().add(this.getSend());
		sendAndReceiveEClass.getESuperTypes().add(this.getReceive());
		compensateAllEClass.getESuperTypes().add(this.getSimpleElement());
		compensateEClass.getESuperTypes().add(this.getSimpleElement());
		exceptionHandlerEClass.getESuperTypes().add(this.getHandler());
		compensationHandlerEClass.getESuperTypes().add(this.getHandler());
		pathBasedPartitionEClass.getESuperTypes().add(this.getCompositeElement());
		pathEClass.getESuperTypes().add(this.getCompositeElement());
		decisionEClass.getESuperTypes().add(this.getPathBasedPartition());
		parallelEClass.getESuperTypes().add(this.getPathBasedPartition());
		loopEClass.getESuperTypes().add(this.getPathBasedPartition());
		eventHandlerEClass.getESuperTypes().add(this.getHandler());
		serviceInteractionEClass.getESuperTypes().add(this.getSimpleElement());
		throwEClass.getESuperTypes().add(this.getSimpleElement());
		compositeElementEClass.getESuperTypes().add(this.getServiceElement());
		replyEClass.getESuperTypes().add(this.getServiceInteraction());
		dataHandlingEClass.getESuperTypes().add(this.getSimpleElement());
		terminateEClass.getESuperTypes().add(this.getSimpleElement());
		receivingTransitionEClass.getESuperTypes().add(this.getProtocolTransition());
		sendingTransitionEClass.getESuperTypes().add(this.getProtocolTransition());
		replyingTransitionEClass.getESuperTypes().add(this.getProtocolTransition());
		receiveReplyingTransitionEClass.getESuperTypes().add(this.getProtocolTransition());
		noopTransitionEClass.getESuperTypes().add(this.getProtocolTransition());

		// Initialize classes and features; add operations and parameters
		initEClass(serviceElementEClass, ServiceElement.class, "ServiceElement", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getServiceElement_Name(), ecorePackage.getEString(), "name", null, 0, 1, ServiceElement.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceElement_Parent(), this.getCompositeElement(), this.getCompositeElement_Children(), "parent", null, 0, 1,
				ServiceElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(simpleElementEClass, SimpleElement.class, "SimpleElement", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(serviceActivityEClass, ServiceActivity.class, "ServiceActivity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceActivity_Variables(), theISMDataPackage.getVariable(), theISMDataPackage.getVariable_ServiceActivity(), "variables",
				null, 0, -1, ServiceActivity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceActivity_Handlers(), this.getHandler(), this.getHandler_ServiceActivity(), "handlers", null, 0, -1,
				ServiceActivity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getServiceActivity_InterruptingReceives(), this.getReceive(), this.getReceive_Interrupting(), "interruptingReceives", null, 0,
				-1, ServiceActivity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getServiceActivity_Participant(), theISMStatikPackage.getParticipant(), theISMStatikPackage.getParticipant_Behaviours(),
				"participant", null, 0, 1, ServiceActivity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(handlerEClass, Handler.class, "Handler", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getHandler_ServiceActivity(), this.getServiceActivity(), this.getServiceActivity_Handlers(), "serviceActivity", null, 0, 1,
				Handler.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(sendEClass, Send.class, "Send", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(receiveEClass, Receive.class, "Receive", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getReceive_Reply(), this.getReply(), this.getReply_Receive(), "reply", null, 0, 1, Receive.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getReceive_Interrupting(), this.getServiceActivity(), this.getServiceActivity_InterruptingReceives(), "interrupting", null, 0,
				1, Receive.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(sendAndReceiveEClass, SendAndReceive.class, "SendAndReceive", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(compensateAllEClass, CompensateAll.class, "CompensateAll", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(compensateEClass, Compensate.class, "Compensate", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCompensate_Target(), this.getServiceActivity(), null, "target", null, 0, 1, Compensate.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(exceptionHandlerEClass, ExceptionHandler.class, "ExceptionHandler", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExceptionHandler_ExceptionType(), theISMStatikPackage.getExceptionType(), null, "exceptionType", null, 0, 1,
				ExceptionHandler.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getExceptionHandler_CaughtException(), theISMDataPackage.getVariableReference(), null, "caughtException", null, 0, 1,
				ExceptionHandler.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(compensationHandlerEClass, CompensationHandler.class, "CompensationHandler", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(pathBasedPartitionEClass, PathBasedPartition.class, "PathBasedPartition", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(pathEClass, Path.class, "Path", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPath_EnterCondition(), theISMDataPackage.getExpression(), null, "enterCondition", null, 0, 1, Path.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(decisionEClass, Decision.class, "Decision", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(parallelEClass, Parallel.class, "Parallel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(loopEClass, Loop.class, "Loop", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getLoop_LeaveCondition(), theISMDataPackage.getExpression(), null, "leaveCondition", null, 0, 1, Loop.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(eventHandlerEClass, EventHandler.class, "EventHandler", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(serviceInteractionEClass, ServiceInteraction.class, "ServiceInteraction", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceInteraction_Operation(), theISMStatikPackage.getInterfaceOperation(),
				theISMStatikPackage.getInterfaceOperation_UsedIn(), "operation", null, 0, 1, ServiceInteraction.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceInteraction_RcvParameters(), theISMDataPackage.getInteractionParameter(), null, "rcvParameters", null, 0, -1,
				ServiceInteraction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getServiceInteraction_SndParameters(), theISMDataPackage.getInteractionParameter(), null, "sndParameters", null, 0, -1,
				ServiceInteraction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getServiceInteraction_Partner(), theISMStatikPackage.getService(), null, "partner", null, 1, 1, ServiceInteraction.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(throwEClass, Throw.class, "Throw", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getThrow_ExceptionType(), theISMStatikPackage.getExceptionType(), null, "exceptionType", null, 0, 1, Throw.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(compositeElementEClass, CompositeElement.class, "CompositeElement", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCompositeElement_Children(), this.getServiceElement(), this.getServiceElement_Parent(), "children", null, 0, -1,
				CompositeElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(replyEClass, Reply.class, "Reply", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getReply_Receive(), this.getReceive(), this.getReceive_Reply(), "receive", null, 0, 1, Reply.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(dataHandlingEClass, DataHandling.class, "DataHandling", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDataHandling_Statements(), theISMDataPackage.getStatement(), null, "statements", null, 0, -1, DataHandling.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(terminateEClass, Terminate.class, "Terminate", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(serviceProtocolEClass, ServiceProtocol.class, "ServiceProtocol", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceProtocol_States(), this.getProtocolState(), this.getProtocolState_Protocol(), "states", null, 0, -1,
				ServiceProtocol.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getServiceProtocol_Transitions(), this.getProtocolTransition(), null, "transitions", null, 0, -1, ServiceProtocol.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getServiceProtocol_StartState(), this.getProtocolState(), null, "startState", null, 0, 1, ServiceProtocol.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServiceProtocol_Name(), ecorePackage.getEString(), "name", null, 0, 1, ServiceProtocol.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(protocolStateEClass, ProtocolState.class, "ProtocolState", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProtocolState_Name(), ecorePackage.getEString(), "name", null, 0, 1, ProtocolState.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProtocolState_Protocol(), this.getServiceProtocol(), this.getServiceProtocol_States(), "protocol", null, 0, 1,
				ProtocolState.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(protocolTransitionEClass, ProtocolTransition.class, "ProtocolTransition", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProtocolTransition_Operation(), theISMStatikPackage.getInterfaceOperation(), null, "operation", null, 0, 1,
				ProtocolTransition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getProtocolTransition_IsOptional(), ecorePackage.getEBoolean(), "isOptional", null, 0, 1, ProtocolTransition.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProtocolTransition_Source(), this.getProtocolState(), null, "source", null, 0, 1, ProtocolTransition.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProtocolTransition_Target(), this.getProtocolState(), null, "target", null, 0, 1, ProtocolTransition.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(receivingTransitionEClass, ReceivingTransition.class, "ReceivingTransition", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(sendingTransitionEClass, SendingTransition.class, "SendingTransition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(replyingTransitionEClass, ReplyingTransition.class, "ReplyingTransition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(receiveReplyingTransitionEClass, ReceiveReplyingTransition.class, "ReceiveReplyingTransition", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(noopTransitionEClass, NoopTransition.class, "NoopTransition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} // ISMBehaviourPackageImpl
