/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.Path;
import eu.mdd4soa.smm.data.Expression;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Path</b></em>'.
 * 
 * @extends Comparable<Path> <!-- end-user-doc -->
 *          <p>
 *          The following features are implemented:
 *          <ul>
 *          <li>{@link eu.mdd4soa.smm.behaviour.impl.PathImpl#getEnterCondition
 *          <em>Enter Condition</em>}</li>
 *          </ul>
 *          </p>
 * 
 * @generated
 */
public class PathImpl extends CompositeElementImpl implements Path, Comparable<Path> {
	/**
	 * The cached value of the '{@link #getEnterCondition()
	 * <em>Enter Condition</em>}' containment reference. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getEnterCondition()
	 * @generated
	 * @ordered
	 */
	protected Expression enterCondition;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PathImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMBehaviourPackage.Literals.PATH;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Expression getEnterCondition() {
		return enterCondition;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetEnterCondition(Expression newEnterCondition, NotificationChain msgs) {
		Expression oldEnterCondition= enterCondition;
		enterCondition= newEnterCondition;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.PATH__ENTER_CONDITION,
					oldEnterCondition, newEnterCondition);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setEnterCondition(Expression newEnterCondition) {
		if (newEnterCondition != enterCondition) {
			NotificationChain msgs= null;
			if (enterCondition != null)
				msgs= ((InternalEObject) enterCondition).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ISMBehaviourPackage.PATH__ENTER_CONDITION,
						null, msgs);
			if (newEnterCondition != null)
				msgs= ((InternalEObject) newEnterCondition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ISMBehaviourPackage.PATH__ENTER_CONDITION,
						null, msgs);
			msgs= basicSetEnterCondition(newEnterCondition, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.PATH__ENTER_CONDITION, newEnterCondition, newEnterCondition));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.PATH__ENTER_CONDITION:
				return basicSetEnterCondition(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMBehaviourPackage.PATH__ENTER_CONDITION:
				return getEnterCondition();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMBehaviourPackage.PATH__ENTER_CONDITION:
				setEnterCondition((Expression) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.PATH__ENTER_CONDITION:
				setEnterCondition((Expression) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.PATH__ENTER_CONDITION:
				return enterCondition != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * @generated NOT
	 */
	@Override
	public int compareTo(Path o) {

		if (o == null)
			return 0;

		if (getName() == null)
			return 0;

		return getName().compareTo(o.getName());
	}

} // PathImpl
