/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.ProtocolState;
import eu.mdd4soa.smm.behaviour.ServiceProtocol;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Protocol State</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ProtocolStateImpl#getName <em>Name
 * </em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ProtocolStateImpl#getProtocol <em>
 * Protocol</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ProtocolStateImpl extends EObjectImpl implements ProtocolState {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT= null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name= NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ProtocolStateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMBehaviourPackage.Literals.PROTOCOL_STATE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setName(String newName) {
		String oldName= name;
		name= newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.PROTOCOL_STATE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ServiceProtocol getProtocol() {
		if (eContainerFeatureID() != ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL)
			return null;
		return (ServiceProtocol) eContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetProtocol(ServiceProtocol newProtocol, NotificationChain msgs) {
		msgs= eBasicSetContainer((InternalEObject) newProtocol, ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setProtocol(ServiceProtocol newProtocol) {
		if (newProtocol != eInternalContainer() || (eContainerFeatureID() != ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL && newProtocol != null)) {
			if (EcoreUtil.isAncestor(this, newProtocol))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs= null;
			if (eInternalContainer() != null)
				msgs= eBasicRemoveFromContainer(msgs);
			if (newProtocol != null)
				msgs= ((InternalEObject) newProtocol).eInverseAdd(this, ISMBehaviourPackage.SERVICE_PROTOCOL__STATES, ServiceProtocol.class, msgs);
			msgs= basicSetProtocol(newProtocol, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL, newProtocol, newProtocol));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL:
				if (eInternalContainer() != null)
					msgs= eBasicRemoveFromContainer(msgs);
				return basicSetProtocol((ServiceProtocol) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL:
				return basicSetProtocol(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL:
				return eInternalContainer().eInverseRemove(this, ISMBehaviourPackage.SERVICE_PROTOCOL__STATES, ServiceProtocol.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_STATE__NAME:
				return getName();
			case ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL:
				return getProtocol();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_STATE__NAME:
				setName((String) newValue);
				return;
			case ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL:
				setProtocol((ServiceProtocol) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_STATE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL:
				setProtocol((ServiceProtocol) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_STATE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL:
				return getProtocol() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} // ProtocolStateImpl
