/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;


import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.ProtocolState;
import eu.mdd4soa.smm.behaviour.ProtocolTransition;
import eu.mdd4soa.smm.statik.InterfaceOperation;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Protocol Transition</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ProtocolTransitionImpl#getOperation
 * <em>Operation</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ProtocolTransitionImpl#isIsOptional
 * <em>Is Optional</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ProtocolTransitionImpl#getSource
 * <em>Source</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ProtocolTransitionImpl#getTarget
 * <em>Target</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public abstract class ProtocolTransitionImpl extends EObjectImpl implements ProtocolTransition {
	/**
	 * The cached value of the '{@link #getOperation() <em>Operation</em>}'
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getOperation()
	 * @generated
	 * @ordered
	 */
	protected InterfaceOperation operation;

	/**
	 * The default value of the '{@link #isIsOptional() <em>Is Optional</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #isIsOptional()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_OPTIONAL_EDEFAULT= false;

	/**
	 * The cached value of the '{@link #isIsOptional() <em>Is Optional</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #isIsOptional()
	 * @generated
	 * @ordered
	 */
	protected boolean isOptional= IS_OPTIONAL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSource() <em>Source</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getSource()
	 * @generated
	 * @ordered
	 */
	protected ProtocolState source;

	/**
	 * The cached value of the '{@link #getTarget() <em>Target</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getTarget()
	 * @generated
	 * @ordered
	 */
	protected ProtocolState target;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ProtocolTransitionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMBehaviourPackage.Literals.PROTOCOL_TRANSITION;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public InterfaceOperation getOperation() {
		if (operation != null && operation.eIsProxy()) {
			InternalEObject oldOperation= (InternalEObject) operation;
			operation= (InterfaceOperation) eResolveProxy(oldOperation);
			if (operation != oldOperation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMBehaviourPackage.PROTOCOL_TRANSITION__OPERATION, oldOperation,
							operation));
			}
		}
		return operation;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public InterfaceOperation basicGetOperation() {
		return operation;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setOperation(InterfaceOperation newOperation) {
		InterfaceOperation oldOperation= operation;
		operation= newOperation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.PROTOCOL_TRANSITION__OPERATION, oldOperation, operation));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean isIsOptional() {
		return isOptional;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setIsOptional(boolean newIsOptional) {
		boolean oldIsOptional= isOptional;
		isOptional= newIsOptional;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.PROTOCOL_TRANSITION__IS_OPTIONAL, oldIsOptional, isOptional));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProtocolState getSource() {
		if (source != null && source.eIsProxy()) {
			InternalEObject oldSource= (InternalEObject) source;
			source= (ProtocolState) eResolveProxy(oldSource);
			if (source != oldSource) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMBehaviourPackage.PROTOCOL_TRANSITION__SOURCE, oldSource, source));
			}
		}
		return source;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProtocolState basicGetSource() {
		return source;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setSource(ProtocolState newSource) {
		ProtocolState oldSource= source;
		source= newSource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.PROTOCOL_TRANSITION__SOURCE, oldSource, source));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProtocolState getTarget() {
		if (target != null && target.eIsProxy()) {
			InternalEObject oldTarget= (InternalEObject) target;
			target= (ProtocolState) eResolveProxy(oldTarget);
			if (target != oldTarget) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMBehaviourPackage.PROTOCOL_TRANSITION__TARGET, oldTarget, target));
			}
		}
		return target;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProtocolState basicGetTarget() {
		return target;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setTarget(ProtocolState newTarget) {
		ProtocolState oldTarget= target;
		target= newTarget;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.PROTOCOL_TRANSITION__TARGET, oldTarget, target));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__OPERATION:
				if (resolve)
					return getOperation();
				return basicGetOperation();
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__IS_OPTIONAL:
				return isIsOptional();
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__SOURCE:
				if (resolve)
					return getSource();
				return basicGetSource();
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__TARGET:
				if (resolve)
					return getTarget();
				return basicGetTarget();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__OPERATION:
				setOperation((InterfaceOperation) newValue);
				return;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__IS_OPTIONAL:
				setIsOptional((Boolean) newValue);
				return;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__SOURCE:
				setSource((ProtocolState) newValue);
				return;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__TARGET:
				setTarget((ProtocolState) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__OPERATION:
				setOperation((InterfaceOperation) null);
				return;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__IS_OPTIONAL:
				setIsOptional(IS_OPTIONAL_EDEFAULT);
				return;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__SOURCE:
				setSource((ProtocolState) null);
				return;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__TARGET:
				setTarget((ProtocolState) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__OPERATION:
				return operation != null;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__IS_OPTIONAL:
				return isOptional != IS_OPTIONAL_EDEFAULT;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__SOURCE:
				return source != null;
			case ISMBehaviourPackage.PROTOCOL_TRANSITION__TARGET:
				return target != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer(super.toString());
		result.append(" (isOptional: ");
		result.append(isOptional);
		result.append(')');
		return result.toString();
	}

} // ProtocolTransitionImpl
