/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.Receive;
import eu.mdd4soa.smm.behaviour.Reply;
import eu.mdd4soa.smm.behaviour.ServiceActivity;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Receive</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ReceiveImpl#getReply <em>Reply</em>}
 * </li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ReceiveImpl#getInterrupting <em>
 * Interrupting</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ReceiveImpl extends ServiceInteractionImpl implements Receive {
	/**
	 * The cached value of the '{@link #getReply() <em>Reply</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getReply()
	 * @generated
	 * @ordered
	 */
	protected Reply reply;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ReceiveImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMBehaviourPackage.Literals.RECEIVE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Reply getReply() {
		if (reply != null && reply.eIsProxy()) {
			InternalEObject oldReply= (InternalEObject) reply;
			reply= (Reply) eResolveProxy(oldReply);
			if (reply != oldReply) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMBehaviourPackage.RECEIVE__REPLY, oldReply, reply));
			}
		}
		return reply;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Reply basicGetReply() {
		return reply;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetReply(Reply newReply, NotificationChain msgs) {
		Reply oldReply= reply;
		reply= newReply;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.RECEIVE__REPLY, oldReply, newReply);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setReply(Reply newReply) {
		if (newReply != reply) {
			NotificationChain msgs= null;
			if (reply != null)
				msgs= ((InternalEObject) reply).eInverseRemove(this, ISMBehaviourPackage.REPLY__RECEIVE, Reply.class, msgs);
			if (newReply != null)
				msgs= ((InternalEObject) newReply).eInverseAdd(this, ISMBehaviourPackage.REPLY__RECEIVE, Reply.class, msgs);
			msgs= basicSetReply(newReply, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.RECEIVE__REPLY, newReply, newReply));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ServiceActivity getInterrupting() {
		if (eContainerFeatureID() != ISMBehaviourPackage.RECEIVE__INTERRUPTING)
			return null;
		return (ServiceActivity) eContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetInterrupting(ServiceActivity newInterrupting, NotificationChain msgs) {
		msgs= eBasicSetContainer((InternalEObject) newInterrupting, ISMBehaviourPackage.RECEIVE__INTERRUPTING, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setInterrupting(ServiceActivity newInterrupting) {
		if (newInterrupting != eInternalContainer()
				|| (eContainerFeatureID() != ISMBehaviourPackage.RECEIVE__INTERRUPTING && newInterrupting != null)) {
			if (EcoreUtil.isAncestor(this, newInterrupting))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs= null;
			if (eInternalContainer() != null)
				msgs= eBasicRemoveFromContainer(msgs);
			if (newInterrupting != null)
				msgs= ((InternalEObject) newInterrupting).eInverseAdd(this, ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES,
						ServiceActivity.class, msgs);
			msgs= basicSetInterrupting(newInterrupting, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.RECEIVE__INTERRUPTING, newInterrupting, newInterrupting));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.RECEIVE__REPLY:
				if (reply != null)
					msgs= ((InternalEObject) reply).eInverseRemove(this, ISMBehaviourPackage.REPLY__RECEIVE, Reply.class, msgs);
				return basicSetReply((Reply) otherEnd, msgs);
			case ISMBehaviourPackage.RECEIVE__INTERRUPTING:
				if (eInternalContainer() != null)
					msgs= eBasicRemoveFromContainer(msgs);
				return basicSetInterrupting((ServiceActivity) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.RECEIVE__REPLY:
				return basicSetReply(null, msgs);
			case ISMBehaviourPackage.RECEIVE__INTERRUPTING:
				return basicSetInterrupting(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ISMBehaviourPackage.RECEIVE__INTERRUPTING:
				return eInternalContainer().eInverseRemove(this, ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES, ServiceActivity.class,
						msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMBehaviourPackage.RECEIVE__REPLY:
				if (resolve)
					return getReply();
				return basicGetReply();
			case ISMBehaviourPackage.RECEIVE__INTERRUPTING:
				return getInterrupting();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMBehaviourPackage.RECEIVE__REPLY:
				setReply((Reply) newValue);
				return;
			case ISMBehaviourPackage.RECEIVE__INTERRUPTING:
				setInterrupting((ServiceActivity) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.RECEIVE__REPLY:
				setReply((Reply) null);
				return;
			case ISMBehaviourPackage.RECEIVE__INTERRUPTING:
				setInterrupting((ServiceActivity) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.RECEIVE__REPLY:
				return reply != null;
			case ISMBehaviourPackage.RECEIVE__INTERRUPTING:
				return getInterrupting() != null;
		}
		return super.eIsSet(featureID);
	}

} // ReceiveImpl
