/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.mdd4soa.smm.behaviour.Handler;
import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.Receive;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.data.ISMDataPackage;
import eu.mdd4soa.smm.data.Variable;
import eu.mdd4soa.smm.statik.ISMStatikPackage;
import eu.mdd4soa.smm.statik.Participant;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Service Activity</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceActivityImpl#getVariables
 * <em>Variables</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceActivityImpl#getHandlers <em>
 * Handlers</em>}</li>
 * <li>
 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceActivityImpl#getInterruptingReceives
 * <em>Interrupting Receives</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceActivityImpl#getParticipant
 * <em>Participant</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ServiceActivityImpl extends CompositeElementImpl implements ServiceActivity {
	/**
	 * The cached value of the '{@link #getVariables() <em>Variables</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<Variable> variables;

	/**
	 * The cached value of the '{@link #getHandlers() <em>Handlers</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getHandlers()
	 * @generated
	 * @ordered
	 */
	protected EList<Handler> handlers;

	/**
	 * The cached value of the '{@link #getInterruptingReceives()
	 * <em>Interrupting Receives</em>}' containment reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getInterruptingReceives()
	 * @generated
	 * @ordered
	 */
	protected EList<Receive> interruptingReceives;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ServiceActivityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMBehaviourPackage.Literals.SERVICE_ACTIVITY;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<Variable> getVariables() {
		if (variables == null) {
			variables= new EObjectContainmentWithInverseEList<Variable>(Variable.class, this, ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES,
					ISMDataPackage.VARIABLE__SERVICE_ACTIVITY);
		}
		return variables;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<Handler> getHandlers() {
		if (handlers == null) {
			handlers= new EObjectContainmentWithInverseEList<Handler>(Handler.class, this, ISMBehaviourPackage.SERVICE_ACTIVITY__HANDLERS,
					ISMBehaviourPackage.HANDLER__SERVICE_ACTIVITY);
		}
		return handlers;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<Receive> getInterruptingReceives() {
		if (interruptingReceives == null) {
			interruptingReceives= new EObjectContainmentWithInverseEList<Receive>(Receive.class, this,
					ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES, ISMBehaviourPackage.RECEIVE__INTERRUPTING);
		}
		return interruptingReceives;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Participant getParticipant() {
		if (eContainerFeatureID() != ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT)
			return null;
		return (Participant) eContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetParticipant(Participant newParticipant, NotificationChain msgs) {
		msgs= eBasicSetContainer((InternalEObject) newParticipant, ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParticipant(Participant newParticipant) {
		if (newParticipant != eInternalContainer()
				|| (eContainerFeatureID() != ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT && newParticipant != null)) {
			if (EcoreUtil.isAncestor(this, newParticipant))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs= null;
			if (eInternalContainer() != null)
				msgs= eBasicRemoveFromContainer(msgs);
			if (newParticipant != null)
				msgs= ((InternalEObject) newParticipant).eInverseAdd(this, ISMStatikPackage.PARTICIPANT__BEHAVIOURS, Participant.class, msgs);
			msgs= basicSetParticipant(newParticipant, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT, newParticipant, newParticipant));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES:
				return ((InternalEList<InternalEObject>) (InternalEList<?>) getVariables()).basicAdd(otherEnd, msgs);
			case ISMBehaviourPackage.SERVICE_ACTIVITY__HANDLERS:
				return ((InternalEList<InternalEObject>) (InternalEList<?>) getHandlers()).basicAdd(otherEnd, msgs);
			case ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				return ((InternalEList<InternalEObject>) (InternalEList<?>) getInterruptingReceives()).basicAdd(otherEnd, msgs);
			case ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT:
				if (eInternalContainer() != null)
					msgs= eBasicRemoveFromContainer(msgs);
				return basicSetParticipant((Participant) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES:
				return ((InternalEList<?>) getVariables()).basicRemove(otherEnd, msgs);
			case ISMBehaviourPackage.SERVICE_ACTIVITY__HANDLERS:
				return ((InternalEList<?>) getHandlers()).basicRemove(otherEnd, msgs);
			case ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				return ((InternalEList<?>) getInterruptingReceives()).basicRemove(otherEnd, msgs);
			case ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT:
				return basicSetParticipant(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT:
				return eInternalContainer().eInverseRemove(this, ISMStatikPackage.PARTICIPANT__BEHAVIOURS, Participant.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES:
				return getVariables();
			case ISMBehaviourPackage.SERVICE_ACTIVITY__HANDLERS:
				return getHandlers();
			case ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				return getInterruptingReceives();
			case ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT:
				return getParticipant();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES:
				getVariables().clear();
				getVariables().addAll((Collection<? extends Variable>) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_ACTIVITY__HANDLERS:
				getHandlers().clear();
				getHandlers().addAll((Collection<? extends Handler>) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				getInterruptingReceives().clear();
				getInterruptingReceives().addAll((Collection<? extends Receive>) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT:
				setParticipant((Participant) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES:
				getVariables().clear();
				return;
			case ISMBehaviourPackage.SERVICE_ACTIVITY__HANDLERS:
				getHandlers().clear();
				return;
			case ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				getInterruptingReceives().clear();
				return;
			case ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT:
				setParticipant((Participant) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES:
				return variables != null && !variables.isEmpty();
			case ISMBehaviourPackage.SERVICE_ACTIVITY__HANDLERS:
				return handlers != null && !handlers.isEmpty();
			case ISMBehaviourPackage.SERVICE_ACTIVITY__INTERRUPTING_RECEIVES:
				return interruptingReceives != null && !interruptingReceives.isEmpty();
			case ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT:
				return getParticipant() != null;
		}
		return super.eIsSet(featureID);
	}

} // ServiceActivityImpl
