/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.ServiceInteraction;
import eu.mdd4soa.smm.data.InteractionParameter;
import eu.mdd4soa.smm.statik.ISMStatikPackage;
import eu.mdd4soa.smm.statik.InterfaceOperation;
import eu.mdd4soa.smm.statik.Service;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Service Interaction</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceInteractionImpl#getOperation
 * <em>Operation</em>}</li>
 * <li>
 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceInteractionImpl#getRcvParameters
 * <em>Rcv Parameters</em>}</li>
 * <li>
 * {@link eu.mdd4soa.smm.behaviour.impl.ServiceInteractionImpl#getSndParameters
 * <em>Snd Parameters</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceInteractionImpl#getPartner
 * <em>Partner</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public abstract class ServiceInteractionImpl extends SimpleElementImpl implements ServiceInteraction {
	/**
	 * The cached value of the '{@link #getOperation() <em>Operation</em>}'
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getOperation()
	 * @generated
	 * @ordered
	 */
	protected InterfaceOperation operation;

	/**
	 * The cached value of the '{@link #getRcvParameters()
	 * <em>Rcv Parameters</em>}' containment reference list. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getRcvParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<InteractionParameter> rcvParameters;

	/**
	 * The cached value of the '{@link #getSndParameters()
	 * <em>Snd Parameters</em>}' containment reference list. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getSndParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<InteractionParameter> sndParameters;

	/**
	 * The cached value of the '{@link #getPartner() <em>Partner</em>}'
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getPartner()
	 * @generated
	 * @ordered
	 */
	protected Service partner;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ServiceInteractionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMBehaviourPackage.Literals.SERVICE_INTERACTION;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public InterfaceOperation getOperation() {
		if (operation != null && operation.eIsProxy()) {
			InternalEObject oldOperation= (InternalEObject) operation;
			operation= (InterfaceOperation) eResolveProxy(oldOperation);
			if (operation != oldOperation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION, oldOperation,
							operation));
			}
		}
		return operation;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public InterfaceOperation basicGetOperation() {
		return operation;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetOperation(InterfaceOperation newOperation, NotificationChain msgs) {
		InterfaceOperation oldOperation= operation;
		operation= newOperation;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION,
					oldOperation, newOperation);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setOperation(InterfaceOperation newOperation) {
		if (newOperation != operation) {
			NotificationChain msgs= null;
			if (operation != null)
				msgs= ((InternalEObject) operation).eInverseRemove(this, ISMStatikPackage.INTERFACE_OPERATION__USED_IN, InterfaceOperation.class,
						msgs);
			if (newOperation != null)
				msgs= ((InternalEObject) newOperation).eInverseAdd(this, ISMStatikPackage.INTERFACE_OPERATION__USED_IN, InterfaceOperation.class,
						msgs);
			msgs= basicSetOperation(newOperation, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION, newOperation, newOperation));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<InteractionParameter> getRcvParameters() {
		if (rcvParameters == null) {
			rcvParameters= new EObjectContainmentEList<InteractionParameter>(InteractionParameter.class, this,
					ISMBehaviourPackage.SERVICE_INTERACTION__RCV_PARAMETERS);
		}
		return rcvParameters;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<InteractionParameter> getSndParameters() {
		if (sndParameters == null) {
			sndParameters= new EObjectContainmentEList<InteractionParameter>(InteractionParameter.class, this,
					ISMBehaviourPackage.SERVICE_INTERACTION__SND_PARAMETERS);
		}
		return sndParameters;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Service getPartner() {
		if (partner != null && partner.eIsProxy()) {
			InternalEObject oldPartner= (InternalEObject) partner;
			partner= (Service) eResolveProxy(oldPartner);
			if (partner != oldPartner) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMBehaviourPackage.SERVICE_INTERACTION__PARTNER, oldPartner, partner));
			}
		}
		return partner;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Service basicGetPartner() {
		return partner;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setPartner(Service newPartner) {
		Service oldPartner= partner;
		partner= newPartner;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.SERVICE_INTERACTION__PARTNER, oldPartner, partner));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION:
				if (operation != null)
					msgs= ((InternalEObject) operation).eInverseRemove(this, ISMStatikPackage.INTERFACE_OPERATION__USED_IN, InterfaceOperation.class,
							msgs);
				return basicSetOperation((InterfaceOperation) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION:
				return basicSetOperation(null, msgs);
			case ISMBehaviourPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				return ((InternalEList<?>) getRcvParameters()).basicRemove(otherEnd, msgs);
			case ISMBehaviourPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				return ((InternalEList<?>) getSndParameters()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION:
				if (resolve)
					return getOperation();
				return basicGetOperation();
			case ISMBehaviourPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				return getRcvParameters();
			case ISMBehaviourPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				return getSndParameters();
			case ISMBehaviourPackage.SERVICE_INTERACTION__PARTNER:
				if (resolve)
					return getPartner();
				return basicGetPartner();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION:
				setOperation((InterfaceOperation) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				getRcvParameters().clear();
				getRcvParameters().addAll((Collection<? extends InteractionParameter>) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				getSndParameters().clear();
				getSndParameters().addAll((Collection<? extends InteractionParameter>) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_INTERACTION__PARTNER:
				setPartner((Service) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION:
				setOperation((InterfaceOperation) null);
				return;
			case ISMBehaviourPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				getRcvParameters().clear();
				return;
			case ISMBehaviourPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				getSndParameters().clear();
				return;
			case ISMBehaviourPackage.SERVICE_INTERACTION__PARTNER:
				setPartner((Service) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION:
				return operation != null;
			case ISMBehaviourPackage.SERVICE_INTERACTION__RCV_PARAMETERS:
				return rcvParameters != null && !rcvParameters.isEmpty();
			case ISMBehaviourPackage.SERVICE_INTERACTION__SND_PARAMETERS:
				return sndParameters != null && !sndParameters.isEmpty();
			case ISMBehaviourPackage.SERVICE_INTERACTION__PARTNER:
				return partner != null;
		}
		return super.eIsSet(featureID);
	}

} // ServiceInteractionImpl
