/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.ProtocolState;
import eu.mdd4soa.smm.behaviour.ProtocolTransition;
import eu.mdd4soa.smm.behaviour.ServiceProtocol;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Service Protocol</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceProtocolImpl#getStates <em>
 * States</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceProtocolImpl#getTransitions
 * <em>Transitions</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceProtocolImpl#getStartState
 * <em>Start State</em>}</li>
 * <li>{@link eu.mdd4soa.smm.behaviour.impl.ServiceProtocolImpl#getName <em>Name
 * </em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ServiceProtocolImpl extends EObjectImpl implements ServiceProtocol {
	/**
	 * The cached value of the '{@link #getStates() <em>States</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getStates()
	 * @generated
	 * @ordered
	 */
	protected EList<ProtocolState> states;

	/**
	 * The cached value of the '{@link #getTransitions() <em>Transitions</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getTransitions()
	 * @generated
	 * @ordered
	 */
	protected EList<ProtocolTransition> transitions;

	/**
	 * The cached value of the '{@link #getStartState() <em>Start State</em>}'
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getStartState()
	 * @generated
	 * @ordered
	 */
	protected ProtocolState startState;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT= null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name= NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ServiceProtocolImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMBehaviourPackage.Literals.SERVICE_PROTOCOL;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<ProtocolState> getStates() {
		if (states == null) {
			states= new EObjectContainmentWithInverseEList<ProtocolState>(ProtocolState.class, this, ISMBehaviourPackage.SERVICE_PROTOCOL__STATES,
					ISMBehaviourPackage.PROTOCOL_STATE__PROTOCOL);
		}
		return states;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<ProtocolTransition> getTransitions() {
		if (transitions == null) {
			transitions= new EObjectContainmentEList<ProtocolTransition>(ProtocolTransition.class, this,
					ISMBehaviourPackage.SERVICE_PROTOCOL__TRANSITIONS);
		}
		return transitions;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProtocolState getStartState() {
		if (startState != null && startState.eIsProxy()) {
			InternalEObject oldStartState= (InternalEObject) startState;
			startState= (ProtocolState) eResolveProxy(oldStartState);
			if (startState != oldStartState) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMBehaviourPackage.SERVICE_PROTOCOL__START_STATE, oldStartState,
							startState));
			}
		}
		return startState;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProtocolState basicGetStartState() {
		return startState;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setStartState(ProtocolState newStartState) {
		ProtocolState oldStartState= startState;
		startState= newStartState;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.SERVICE_PROTOCOL__START_STATE, oldStartState, startState));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setName(String newName) {
		String oldName= name;
		name= newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMBehaviourPackage.SERVICE_PROTOCOL__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_PROTOCOL__STATES:
				return ((InternalEList<InternalEObject>) (InternalEList<?>) getStates()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_PROTOCOL__STATES:
				return ((InternalEList<?>) getStates()).basicRemove(otherEnd, msgs);
			case ISMBehaviourPackage.SERVICE_PROTOCOL__TRANSITIONS:
				return ((InternalEList<?>) getTransitions()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_PROTOCOL__STATES:
				return getStates();
			case ISMBehaviourPackage.SERVICE_PROTOCOL__TRANSITIONS:
				return getTransitions();
			case ISMBehaviourPackage.SERVICE_PROTOCOL__START_STATE:
				if (resolve)
					return getStartState();
				return basicGetStartState();
			case ISMBehaviourPackage.SERVICE_PROTOCOL__NAME:
				return getName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_PROTOCOL__STATES:
				getStates().clear();
				getStates().addAll((Collection<? extends ProtocolState>) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_PROTOCOL__TRANSITIONS:
				getTransitions().clear();
				getTransitions().addAll((Collection<? extends ProtocolTransition>) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_PROTOCOL__START_STATE:
				setStartState((ProtocolState) newValue);
				return;
			case ISMBehaviourPackage.SERVICE_PROTOCOL__NAME:
				setName((String) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_PROTOCOL__STATES:
				getStates().clear();
				return;
			case ISMBehaviourPackage.SERVICE_PROTOCOL__TRANSITIONS:
				getTransitions().clear();
				return;
			case ISMBehaviourPackage.SERVICE_PROTOCOL__START_STATE:
				setStartState((ProtocolState) null);
				return;
			case ISMBehaviourPackage.SERVICE_PROTOCOL__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMBehaviourPackage.SERVICE_PROTOCOL__STATES:
				return states != null && !states.isEmpty();
			case ISMBehaviourPackage.SERVICE_PROTOCOL__TRANSITIONS:
				return transitions != null && !transitions.isEmpty();
			case ISMBehaviourPackage.SERVICE_PROTOCOL__START_STATE:
				return startState != null;
			case ISMBehaviourPackage.SERVICE_PROTOCOL__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} // ServiceProtocolImpl
