/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import eu.mdd4soa.smm.behaviour.Compensate;
import eu.mdd4soa.smm.behaviour.CompensateAll;
import eu.mdd4soa.smm.behaviour.CompensationHandler;
import eu.mdd4soa.smm.behaviour.CompositeElement;
import eu.mdd4soa.smm.behaviour.DataHandling;
import eu.mdd4soa.smm.behaviour.Decision;
import eu.mdd4soa.smm.behaviour.EventHandler;
import eu.mdd4soa.smm.behaviour.ExceptionHandler;
import eu.mdd4soa.smm.behaviour.Handler;
import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.Loop;
import eu.mdd4soa.smm.behaviour.NoopTransition;
import eu.mdd4soa.smm.behaviour.Parallel;
import eu.mdd4soa.smm.behaviour.Path;
import eu.mdd4soa.smm.behaviour.PathBasedPartition;
import eu.mdd4soa.smm.behaviour.ProtocolState;
import eu.mdd4soa.smm.behaviour.ProtocolTransition;
import eu.mdd4soa.smm.behaviour.Receive;
import eu.mdd4soa.smm.behaviour.ReceiveReplyingTransition;
import eu.mdd4soa.smm.behaviour.ReceivingTransition;
import eu.mdd4soa.smm.behaviour.Reply;
import eu.mdd4soa.smm.behaviour.ReplyingTransition;
import eu.mdd4soa.smm.behaviour.Send;
import eu.mdd4soa.smm.behaviour.SendAndReceive;
import eu.mdd4soa.smm.behaviour.SendingTransition;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.behaviour.ServiceElement;
import eu.mdd4soa.smm.behaviour.ServiceInteraction;
import eu.mdd4soa.smm.behaviour.ServiceProtocol;
import eu.mdd4soa.smm.behaviour.SimpleElement;
import eu.mdd4soa.smm.behaviour.Terminate;
import eu.mdd4soa.smm.behaviour.Throw;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage
 * @generated
 */
public class ISMBehaviourAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static ISMBehaviourPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMBehaviourAdapterFactory() {
		if (modelPackage == null) {
			modelPackage= ISMBehaviourPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * 
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ISMBehaviourSwitch<Adapter> modelSwitch= new ISMBehaviourSwitch<Adapter>() {
		@Override
		public Adapter caseServiceElement(ServiceElement object) {
			return createServiceElementAdapter();
		}

		@Override
		public Adapter caseSimpleElement(SimpleElement object) {
			return createSimpleElementAdapter();
		}

		@Override
		public Adapter caseServiceActivity(ServiceActivity object) {
			return createServiceActivityAdapter();
		}

		@Override
		public Adapter caseHandler(Handler object) {
			return createHandlerAdapter();
		}

		@Override
		public Adapter caseSend(Send object) {
			return createSendAdapter();
		}

		@Override
		public Adapter caseReceive(Receive object) {
			return createReceiveAdapter();
		}

		@Override
		public Adapter caseSendAndReceive(SendAndReceive object) {
			return createSendAndReceiveAdapter();
		}

		@Override
		public Adapter caseCompensateAll(CompensateAll object) {
			return createCompensateAllAdapter();
		}

		@Override
		public Adapter caseCompensate(Compensate object) {
			return createCompensateAdapter();
		}

		@Override
		public Adapter caseExceptionHandler(ExceptionHandler object) {
			return createExceptionHandlerAdapter();
		}

		@Override
		public Adapter caseCompensationHandler(CompensationHandler object) {
			return createCompensationHandlerAdapter();
		}

		@Override
		public Adapter casePathBasedPartition(PathBasedPartition object) {
			return createPathBasedPartitionAdapter();
		}

		@Override
		public Adapter casePath(Path object) {
			return createPathAdapter();
		}

		@Override
		public Adapter caseDecision(Decision object) {
			return createDecisionAdapter();
		}

		@Override
		public Adapter caseParallel(Parallel object) {
			return createParallelAdapter();
		}

		@Override
		public Adapter caseLoop(Loop object) {
			return createLoopAdapter();
		}

		@Override
		public Adapter caseEventHandler(EventHandler object) {
			return createEventHandlerAdapter();
		}

		@Override
		public Adapter caseServiceInteraction(ServiceInteraction object) {
			return createServiceInteractionAdapter();
		}

		@Override
		public Adapter caseThrow(Throw object) {
			return createThrowAdapter();
		}

		@Override
		public Adapter caseCompositeElement(CompositeElement object) {
			return createCompositeElementAdapter();
		}

		@Override
		public Adapter caseReply(Reply object) {
			return createReplyAdapter();
		}

		@Override
		public Adapter caseDataHandling(DataHandling object) {
			return createDataHandlingAdapter();
		}

		@Override
		public Adapter caseTerminate(Terminate object) {
			return createTerminateAdapter();
		}

		@Override
		public Adapter caseServiceProtocol(ServiceProtocol object) {
			return createServiceProtocolAdapter();
		}

		@Override
		public Adapter caseProtocolState(ProtocolState object) {
			return createProtocolStateAdapter();
		}

		@Override
		public Adapter caseProtocolTransition(ProtocolTransition object) {
			return createProtocolTransitionAdapter();
		}

		@Override
		public Adapter caseReceivingTransition(ReceivingTransition object) {
			return createReceivingTransitionAdapter();
		}

		@Override
		public Adapter caseSendingTransition(SendingTransition object) {
			return createSendingTransitionAdapter();
		}

		@Override
		public Adapter caseReplyingTransition(ReplyingTransition object) {
			return createReplyingTransitionAdapter();
		}

		@Override
		public Adapter caseReceiveReplyingTransition(ReceiveReplyingTransition object) {
			return createReceiveReplyingTransitionAdapter();
		}

		@Override
		public Adapter caseNoopTransition(NoopTransition object) {
			return createNoopTransitionAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject) target);
	}


	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceElement <em>Service Element</em>}
	 * '. <!-- begin-user-doc --> This default implementation returns null so
	 * that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ServiceElement
	 * @generated
	 */
	public Adapter createServiceElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.SimpleElement <em>Simple Element</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.SimpleElement
	 * @generated
	 */
	public Adapter createSimpleElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity
	 * <em>Service Activity</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity
	 * @generated
	 */
	public Adapter createServiceActivityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Handler <em>Handler</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Handler
	 * @generated
	 */
	public Adapter createHandlerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Send <em>Send</em>}'. <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Send
	 * @generated
	 */
	public Adapter createSendAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Receive <em>Receive</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Receive
	 * @generated
	 */
	public Adapter createReceiveAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.SendAndReceive <em>Send And Receive</em>}
	 * '. <!-- begin-user-doc --> This default implementation returns null so
	 * that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.SendAndReceive
	 * @generated
	 */
	public Adapter createSendAndReceiveAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.CompensateAll <em>Compensate All</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.CompensateAll
	 * @generated
	 */
	public Adapter createCompensateAllAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Compensate <em>Compensate</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Compensate
	 * @generated
	 */
	public Adapter createCompensateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ExceptionHandler
	 * <em>Exception Handler</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ExceptionHandler
	 * @generated
	 */
	public Adapter createExceptionHandlerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.CompensationHandler
	 * <em>Compensation Handler</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.CompensationHandler
	 * @generated
	 */
	public Adapter createCompensationHandlerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.PathBasedPartition
	 * <em>Path Based Partition</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.PathBasedPartition
	 * @generated
	 */
	public Adapter createPathBasedPartitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Path <em>Path</em>}'. <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Path
	 * @generated
	 */
	public Adapter createPathAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Decision <em>Decision</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Decision
	 * @generated
	 */
	public Adapter createDecisionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Parallel <em>Parallel</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Parallel
	 * @generated
	 */
	public Adapter createParallelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Loop <em>Loop</em>}'. <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Loop
	 * @generated
	 */
	public Adapter createLoopAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.EventHandler <em>Event Handler</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.EventHandler
	 * @generated
	 */
	public Adapter createEventHandlerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction
	 * <em>Service Interaction</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ServiceInteraction
	 * @generated
	 */
	public Adapter createServiceInteractionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Throw <em>Throw</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Throw
	 * @generated
	 */
	public Adapter createThrowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.CompositeElement
	 * <em>Composite Element</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.CompositeElement
	 * @generated
	 */
	public Adapter createCompositeElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Reply <em>Reply</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Reply
	 * @generated
	 */
	public Adapter createReplyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.DataHandling <em>Data Handling</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.DataHandling
	 * @generated
	 */
	public Adapter createDataHandlingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.Terminate <em>Terminate</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.Terminate
	 * @generated
	 */
	public Adapter createTerminateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceProtocol
	 * <em>Service Protocol</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ServiceProtocol
	 * @generated
	 */
	public Adapter createServiceProtocolAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolState <em>Protocol State</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolState
	 * @generated
	 */
	public Adapter createProtocolStateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ProtocolTransition
	 * <em>Protocol Transition</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ProtocolTransition
	 * @generated
	 */
	public Adapter createProtocolTransitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ReceivingTransition
	 * <em>Receiving Transition</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ReceivingTransition
	 * @generated
	 */
	public Adapter createReceivingTransitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.SendingTransition
	 * <em>Sending Transition</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.SendingTransition
	 * @generated
	 */
	public Adapter createSendingTransitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ReplyingTransition
	 * <em>Replying Transition</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ReplyingTransition
	 * @generated
	 */
	public Adapter createReplyingTransitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.ReceiveReplyingTransition
	 * <em>Receive Replying Transition</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.ReceiveReplyingTransition
	 * @generated
	 */
	public Adapter createReceiveReplyingTransitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link eu.mdd4soa.smm.behaviour.NoopTransition <em>Noop Transition</em>}
	 * '. <!-- begin-user-doc --> This default implementation returns null so
	 * that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see eu.mdd4soa.smm.behaviour.NoopTransition
	 * @generated
	 */
	public Adapter createNoopTransitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case. <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // ISMBehaviourAdapterFactory
