/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.behaviour.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import eu.mdd4soa.smm.behaviour.Compensate;
import eu.mdd4soa.smm.behaviour.CompensateAll;
import eu.mdd4soa.smm.behaviour.CompensationHandler;
import eu.mdd4soa.smm.behaviour.CompositeElement;
import eu.mdd4soa.smm.behaviour.DataHandling;
import eu.mdd4soa.smm.behaviour.Decision;
import eu.mdd4soa.smm.behaviour.EventHandler;
import eu.mdd4soa.smm.behaviour.ExceptionHandler;
import eu.mdd4soa.smm.behaviour.Handler;
import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.Loop;
import eu.mdd4soa.smm.behaviour.NoopTransition;
import eu.mdd4soa.smm.behaviour.Parallel;
import eu.mdd4soa.smm.behaviour.Path;
import eu.mdd4soa.smm.behaviour.PathBasedPartition;
import eu.mdd4soa.smm.behaviour.ProtocolState;
import eu.mdd4soa.smm.behaviour.ProtocolTransition;
import eu.mdd4soa.smm.behaviour.Receive;
import eu.mdd4soa.smm.behaviour.ReceiveReplyingTransition;
import eu.mdd4soa.smm.behaviour.ReceivingTransition;
import eu.mdd4soa.smm.behaviour.Reply;
import eu.mdd4soa.smm.behaviour.ReplyingTransition;
import eu.mdd4soa.smm.behaviour.Send;
import eu.mdd4soa.smm.behaviour.SendAndReceive;
import eu.mdd4soa.smm.behaviour.SendingTransition;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.behaviour.ServiceElement;
import eu.mdd4soa.smm.behaviour.ServiceInteraction;
import eu.mdd4soa.smm.behaviour.ServiceProtocol;
import eu.mdd4soa.smm.behaviour.SimpleElement;
import eu.mdd4soa.smm.behaviour.Terminate;
import eu.mdd4soa.smm.behaviour.Throw;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * 
 * @see eu.mdd4soa.smm.behaviour.ISMBehaviourPackage
 * @generated
 */
public class ISMBehaviourSwitch<T> {
	/**
	 * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static ISMBehaviourPackage modelPackage;

	/**
	 * Creates an instance of the switch. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMBehaviourSwitch() {
		if (modelPackage == null) {
			modelPackage= ISMBehaviourPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		} else {
			List<EClass> eSuperTypes= theEClass.getESuperTypes();
			return eSuperTypes.isEmpty() ? defaultCase(theEObject) : doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case ISMBehaviourPackage.SERVICE_ELEMENT: {
				ServiceElement serviceElement= (ServiceElement) theEObject;
				T result= caseServiceElement(serviceElement);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.SIMPLE_ELEMENT: {
				SimpleElement simpleElement= (SimpleElement) theEObject;
				T result= caseSimpleElement(simpleElement);
				if (result == null)
					result= caseServiceElement(simpleElement);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.SERVICE_ACTIVITY: {
				ServiceActivity serviceActivity= (ServiceActivity) theEObject;
				T result= caseServiceActivity(serviceActivity);
				if (result == null)
					result= caseCompositeElement(serviceActivity);
				if (result == null)
					result= caseServiceElement(serviceActivity);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.HANDLER: {
				Handler handler= (Handler) theEObject;
				T result= caseHandler(handler);
				if (result == null)
					result= caseCompositeElement(handler);
				if (result == null)
					result= caseServiceElement(handler);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.SEND: {
				Send send= (Send) theEObject;
				T result= caseSend(send);
				if (result == null)
					result= caseServiceInteraction(send);
				if (result == null)
					result= caseSimpleElement(send);
				if (result == null)
					result= caseServiceElement(send);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.RECEIVE: {
				Receive receive= (Receive) theEObject;
				T result= caseReceive(receive);
				if (result == null)
					result= caseServiceInteraction(receive);
				if (result == null)
					result= caseSimpleElement(receive);
				if (result == null)
					result= caseServiceElement(receive);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.SEND_AND_RECEIVE: {
				SendAndReceive sendAndReceive= (SendAndReceive) theEObject;
				T result= caseSendAndReceive(sendAndReceive);
				if (result == null)
					result= caseSend(sendAndReceive);
				if (result == null)
					result= caseReceive(sendAndReceive);
				if (result == null)
					result= caseServiceInteraction(sendAndReceive);
				if (result == null)
					result= caseSimpleElement(sendAndReceive);
				if (result == null)
					result= caseServiceElement(sendAndReceive);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.COMPENSATE_ALL: {
				CompensateAll compensateAll= (CompensateAll) theEObject;
				T result= caseCompensateAll(compensateAll);
				if (result == null)
					result= caseSimpleElement(compensateAll);
				if (result == null)
					result= caseServiceElement(compensateAll);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.COMPENSATE: {
				Compensate compensate= (Compensate) theEObject;
				T result= caseCompensate(compensate);
				if (result == null)
					result= caseSimpleElement(compensate);
				if (result == null)
					result= caseServiceElement(compensate);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.EXCEPTION_HANDLER: {
				ExceptionHandler exceptionHandler= (ExceptionHandler) theEObject;
				T result= caseExceptionHandler(exceptionHandler);
				if (result == null)
					result= caseHandler(exceptionHandler);
				if (result == null)
					result= caseCompositeElement(exceptionHandler);
				if (result == null)
					result= caseServiceElement(exceptionHandler);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.COMPENSATION_HANDLER: {
				CompensationHandler compensationHandler= (CompensationHandler) theEObject;
				T result= caseCompensationHandler(compensationHandler);
				if (result == null)
					result= caseHandler(compensationHandler);
				if (result == null)
					result= caseCompositeElement(compensationHandler);
				if (result == null)
					result= caseServiceElement(compensationHandler);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.PATH_BASED_PARTITION: {
				PathBasedPartition pathBasedPartition= (PathBasedPartition) theEObject;
				T result= casePathBasedPartition(pathBasedPartition);
				if (result == null)
					result= caseCompositeElement(pathBasedPartition);
				if (result == null)
					result= caseServiceElement(pathBasedPartition);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.PATH: {
				Path path= (Path) theEObject;
				T result= casePath(path);
				if (result == null)
					result= caseCompositeElement(path);
				if (result == null)
					result= caseServiceElement(path);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.DECISION: {
				Decision decision= (Decision) theEObject;
				T result= caseDecision(decision);
				if (result == null)
					result= casePathBasedPartition(decision);
				if (result == null)
					result= caseCompositeElement(decision);
				if (result == null)
					result= caseServiceElement(decision);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.PARALLEL: {
				Parallel parallel= (Parallel) theEObject;
				T result= caseParallel(parallel);
				if (result == null)
					result= casePathBasedPartition(parallel);
				if (result == null)
					result= caseCompositeElement(parallel);
				if (result == null)
					result= caseServiceElement(parallel);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.LOOP: {
				Loop loop= (Loop) theEObject;
				T result= caseLoop(loop);
				if (result == null)
					result= casePathBasedPartition(loop);
				if (result == null)
					result= caseCompositeElement(loop);
				if (result == null)
					result= caseServiceElement(loop);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.EVENT_HANDLER: {
				EventHandler eventHandler= (EventHandler) theEObject;
				T result= caseEventHandler(eventHandler);
				if (result == null)
					result= caseHandler(eventHandler);
				if (result == null)
					result= caseCompositeElement(eventHandler);
				if (result == null)
					result= caseServiceElement(eventHandler);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.SERVICE_INTERACTION: {
				ServiceInteraction serviceInteraction= (ServiceInteraction) theEObject;
				T result= caseServiceInteraction(serviceInteraction);
				if (result == null)
					result= caseSimpleElement(serviceInteraction);
				if (result == null)
					result= caseServiceElement(serviceInteraction);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.THROW: {
				Throw throw_= (Throw) theEObject;
				T result= caseThrow(throw_);
				if (result == null)
					result= caseSimpleElement(throw_);
				if (result == null)
					result= caseServiceElement(throw_);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.COMPOSITE_ELEMENT: {
				CompositeElement compositeElement= (CompositeElement) theEObject;
				T result= caseCompositeElement(compositeElement);
				if (result == null)
					result= caseServiceElement(compositeElement);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.REPLY: {
				Reply reply= (Reply) theEObject;
				T result= caseReply(reply);
				if (result == null)
					result= caseServiceInteraction(reply);
				if (result == null)
					result= caseSimpleElement(reply);
				if (result == null)
					result= caseServiceElement(reply);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.DATA_HANDLING: {
				DataHandling dataHandling= (DataHandling) theEObject;
				T result= caseDataHandling(dataHandling);
				if (result == null)
					result= caseSimpleElement(dataHandling);
				if (result == null)
					result= caseServiceElement(dataHandling);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.TERMINATE: {
				Terminate terminate= (Terminate) theEObject;
				T result= caseTerminate(terminate);
				if (result == null)
					result= caseSimpleElement(terminate);
				if (result == null)
					result= caseServiceElement(terminate);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.SERVICE_PROTOCOL: {
				ServiceProtocol serviceProtocol= (ServiceProtocol) theEObject;
				T result= caseServiceProtocol(serviceProtocol);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.PROTOCOL_STATE: {
				ProtocolState protocolState= (ProtocolState) theEObject;
				T result= caseProtocolState(protocolState);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.PROTOCOL_TRANSITION: {
				ProtocolTransition protocolTransition= (ProtocolTransition) theEObject;
				T result= caseProtocolTransition(protocolTransition);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.RECEIVING_TRANSITION: {
				ReceivingTransition receivingTransition= (ReceivingTransition) theEObject;
				T result= caseReceivingTransition(receivingTransition);
				if (result == null)
					result= caseProtocolTransition(receivingTransition);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.SENDING_TRANSITION: {
				SendingTransition sendingTransition= (SendingTransition) theEObject;
				T result= caseSendingTransition(sendingTransition);
				if (result == null)
					result= caseProtocolTransition(sendingTransition);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.REPLYING_TRANSITION: {
				ReplyingTransition replyingTransition= (ReplyingTransition) theEObject;
				T result= caseReplyingTransition(replyingTransition);
				if (result == null)
					result= caseProtocolTransition(replyingTransition);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.RECEIVE_REPLYING_TRANSITION: {
				ReceiveReplyingTransition receiveReplyingTransition= (ReceiveReplyingTransition) theEObject;
				T result= caseReceiveReplyingTransition(receiveReplyingTransition);
				if (result == null)
					result= caseProtocolTransition(receiveReplyingTransition);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMBehaviourPackage.NOOP_TRANSITION: {
				NoopTransition noopTransition= (NoopTransition) theEObject;
				T result= caseNoopTransition(noopTransition);
				if (result == null)
					result= caseProtocolTransition(noopTransition);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			default:
				return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Service Element</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Service Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceElement(ServiceElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Simple Element</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Simple Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSimpleElement(SimpleElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Service Activity</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Service Activity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceActivity(ServiceActivity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Handler</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Handler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHandler(Handler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Send</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Send</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSend(Send object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Receive</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Receive</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReceive(Receive object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Send And Receive</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Send And Receive</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSendAndReceive(SendAndReceive object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Compensate All</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Compensate All</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompensateAll(CompensateAll object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Compensate</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Compensate</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompensate(Compensate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Exception Handler</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Exception Handler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExceptionHandler(ExceptionHandler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Compensation Handler</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Compensation Handler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompensationHandler(CompensationHandler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Path Based Partition</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Path Based Partition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePathBasedPartition(PathBasedPartition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Path</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Path</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePath(Path object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Decision</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Decision</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDecision(Decision object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Parallel</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Parallel</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParallel(Parallel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Loop</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Loop</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLoop(Loop object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Event Handler</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Event Handler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventHandler(EventHandler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Service Interaction</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Service Interaction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceInteraction(ServiceInteraction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Throw</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Throw</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseThrow(Throw object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Composite Element</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Composite Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompositeElement(CompositeElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Reply</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Reply</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReply(Reply object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Data Handling</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Data Handling</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataHandling(DataHandling object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Terminate</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Terminate</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTerminate(Terminate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Service Protocol</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Service Protocol</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseServiceProtocol(ServiceProtocol object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Protocol State</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Protocol State</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProtocolState(ProtocolState object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Protocol Transition</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Protocol Transition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProtocolTransition(ProtocolTransition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Receiving Transition</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Receiving Transition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReceivingTransition(ReceivingTransition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Sending Transition</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Sending Transition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSendingTransition(SendingTransition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Replying Transition</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Replying Transition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReplyingTransition(ReplyingTransition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Receive Replying Transition</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Receive Replying Transition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReceiveReplyingTransition(ReceiveReplyingTransition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Noop Transition</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Noop Transition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNoopTransition(NoopTransition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>EObject</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch, but this is
	 * the last case anyway. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} // ISMBehaviourSwitch
