/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import eu.mdd4soa.smm.statik.ISMStatikPackage;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see eu.mdd4soa.smm.data.ISMDataFactory
 * @model kind="package"
 * @generated
 */
public interface ISMDataPackage extends EPackage {
	/**
	 * The package name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNAME= "data";

	/**
	 * The package namespace URI. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_URI= "http://www.mdd4soa.eu/ism/data";

	/**
	 * The package namespace name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_PREFIX= "ismData";

	/**
	 * The singleton instance of the package. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	ISMDataPackage eINSTANCE= eu.mdd4soa.smm.data.impl.ISMDataPackageImpl.init();

	/**
	 * The meta object id for the '{@link eu.mdd4soa.smm.data.impl.VariableImpl
	 * <em>Variable</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.VariableImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getVariable()
	 * @generated
	 */
	int VARIABLE= 0;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__MIN= ISMStatikPackage.TYPED_MULTI_ELEMENT__MIN;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__MAX= ISMStatikPackage.TYPED_MULTI_ELEMENT__MAX;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__IS_ORDERED= ISMStatikPackage.TYPED_MULTI_ELEMENT__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__TYPE= ISMStatikPackage.TYPED_MULTI_ELEMENT__TYPE;

	/**
	 * The feature id for the '<em><b>Service Activity</b></em>' container
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__SERVICE_ACTIVITY= ISMStatikPackage.TYPED_MULTI_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE__NAME= ISMStatikPackage.TYPED_MULTI_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variable</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE_FEATURE_COUNT= ISMStatikPackage.TYPED_MULTI_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.ExpressionImpl <em>Expression</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.ExpressionImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getExpression()
	 * @generated
	 */
	int EXPRESSION= 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__TYPE= 0;

	/**
	 * The number of structural features of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FEATURE_COUNT= 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.StatementImpl <em>Statement</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.StatementImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getStatement()
	 * @generated
	 */
	int STATEMENT= 4;

	/**
	 * The number of structural features of the '<em>Statement</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STATEMENT_FEATURE_COUNT= 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.AssignmentImpl <em>Assignment</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.AssignmentImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getAssignment()
	 * @generated
	 */
	int ASSIGNMENT= 2;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__TARGET= STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__SOURCE= STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_FEATURE_COUNT= STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.DeclarationImpl <em>Declaration</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.DeclarationImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getDeclaration()
	 * @generated
	 */
	int DECLARATION= 3;

	/**
	 * The feature id for the '<em><b>Declared Var</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DECLARATION__DECLARED_VAR= STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Declaration</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DECLARATION_FEATURE_COUNT= STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.RightHandSideExpressionImpl
	 * <em>Right Hand Side Expression</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.RightHandSideExpressionImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getRightHandSideExpression()
	 * @generated
	 */
	int RIGHT_HAND_SIDE_EXPRESSION= 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RIGHT_HAND_SIDE_EXPRESSION__TYPE= EXPRESSION__TYPE;

	/**
	 * The number of structural features of the '
	 * <em>Right Hand Side Expression</em>' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT= EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.mdd4soa.smm.data.impl.LiteralImpl
	 * <em>Literal</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.LiteralImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getLiteral()
	 * @generated
	 */
	int LITERAL= 5;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL__TYPE= RIGHT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL__VALUE= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Literal</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_FEATURE_COUNT= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.OperationImpl <em>Operation</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.OperationImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getOperation()
	 * @generated
	 */
	int OPERATION= 6;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION__TYPE= RIGHT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Operands</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION__OPERANDS= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operation Type</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION__OPERATION_TYPE= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Operation</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_FEATURE_COUNT= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.LeftHandSideExpressionImpl
	 * <em>Left Hand Side Expression</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.LeftHandSideExpressionImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getLeftHandSideExpression()
	 * @generated
	 */
	int LEFT_HAND_SIDE_EXPRESSION= 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE_EXPRESSION__TYPE= RIGHT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The number of structural features of the '
	 * <em>Left Hand Side Expression</em>' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT= RIGHT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.InteractionParameterImpl
	 * <em>Interaction Parameter</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.InteractionParameterImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getInteractionParameter()
	 * @generated
	 */
	int INTERACTION_PARAMETER= 9;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_PARAMETER__OPERATION_PARAMETER= 0;

	/**
	 * The number of structural features of the '<em>Interaction Parameter</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_PARAMETER_FEATURE_COUNT= 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.ReceiveParameterImpl
	 * <em>Receive Parameter</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.ReceiveParameterImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getReceiveParameter()
	 * @generated
	 */
	int RECEIVE_PARAMETER= 10;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_PARAMETER__OPERATION_PARAMETER= INTERACTION_PARAMETER__OPERATION_PARAMETER;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_PARAMETER__TARGET= INTERACTION_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Receive Parameter</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEIVE_PARAMETER_FEATURE_COUNT= INTERACTION_PARAMETER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.SendParameterImpl
	 * <em>Send Parameter</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.SendParameterImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getSendParameter()
	 * @generated
	 */
	int SEND_PARAMETER= 11;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_PARAMETER__OPERATION_PARAMETER= INTERACTION_PARAMETER__OPERATION_PARAMETER;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_PARAMETER__SOURCE= INTERACTION_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Send Parameter</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SEND_PARAMETER_FEATURE_COUNT= INTERACTION_PARAMETER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.VariableReferenceImpl
	 * <em>Variable Reference</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.VariableReferenceImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getVariableReference()
	 * @generated
	 */
	int VARIABLE_REFERENCE= 12;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE_REFERENCE__TYPE= LEFT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE_REFERENCE__VARIABLE= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Variable Reference</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VARIABLE_REFERENCE_FEATURE_COUNT= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.data.impl.PropertyReferenceImpl
	 * <em>Property Reference</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.data.impl.PropertyReferenceImpl
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getPropertyReference()
	 * @generated
	 */
	int PROPERTY_REFERENCE= 13;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_REFERENCE__TYPE= LEFT_HAND_SIDE_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_REFERENCE__PARENT= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Property</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_REFERENCE__PROPERTY= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Property Reference</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_REFERENCE_FEATURE_COUNT= LEFT_HAND_SIDE_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.mdd4soa.smm.data.OperationType
	 * <em>Operation Type</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see eu.mdd4soa.smm.data.OperationType
	 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getOperationType()
	 * @generated
	 */
	int OPERATION_TYPE= 14;


	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.data.Variable
	 * <em>Variable</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Variable</em>'.
	 * @see eu.mdd4soa.smm.data.Variable
	 * @generated
	 */
	EClass getVariable();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.data.Variable#getName <em>Name</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.data.Variable#getName()
	 * @see #getVariable()
	 * @generated
	 */
	EAttribute getVariable_Name();

	/**
	 * Returns the meta object for the container reference '
	 * {@link eu.mdd4soa.smm.data.Variable#getServiceActivity
	 * <em>Service Activity</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the container reference '
	 *         <em>Service Activity</em>'.
	 * @see eu.mdd4soa.smm.data.Variable#getServiceActivity()
	 * @see #getVariable()
	 * @generated
	 */
	EReference getVariable_ServiceActivity();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.data.Expression
	 * <em>Expression</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Expression</em>'.
	 * @see eu.mdd4soa.smm.data.Expression
	 * @generated
	 */
	EClass getExpression();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.data.Expression#getType <em>Type</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see eu.mdd4soa.smm.data.Expression#getType()
	 * @see #getExpression()
	 * @generated
	 */
	EReference getExpression_Type();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.data.Assignment
	 * <em>Assignment</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Assignment</em>'.
	 * @see eu.mdd4soa.smm.data.Assignment
	 * @generated
	 */
	EClass getAssignment();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.data.Assignment#getTarget <em>Target</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '<em>Target</em>'.
	 * @see eu.mdd4soa.smm.data.Assignment#getTarget()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_Target();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.data.Assignment#getSource <em>Source</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '<em>Source</em>'.
	 * @see eu.mdd4soa.smm.data.Assignment#getSource()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_Source();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.data.Declaration <em>Declaration</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Declaration</em>'.
	 * @see eu.mdd4soa.smm.data.Declaration
	 * @generated
	 */
	EClass getDeclaration();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.data.Declaration#getDeclaredVar
	 * <em>Declared Var</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '
	 *         <em>Declared Var</em>'.
	 * @see eu.mdd4soa.smm.data.Declaration#getDeclaredVar()
	 * @see #getDeclaration()
	 * @generated
	 */
	EReference getDeclaration_DeclaredVar();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.data.Statement
	 * <em>Statement</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Statement</em>'.
	 * @see eu.mdd4soa.smm.data.Statement
	 * @generated
	 */
	EClass getStatement();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.data.Literal
	 * <em>Literal</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Literal</em>'.
	 * @see eu.mdd4soa.smm.data.Literal
	 * @generated
	 */
	EClass getLiteral();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.data.Literal#getValue <em>Value</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see eu.mdd4soa.smm.data.Literal#getValue()
	 * @see #getLiteral()
	 * @generated
	 */
	EAttribute getLiteral_Value();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.data.Operation
	 * <em>Operation</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Operation</em>'.
	 * @see eu.mdd4soa.smm.data.Operation
	 * @generated
	 */
	EClass getOperation();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.data.Operation#getOperands <em>Operands</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Operands</em>'.
	 * @see eu.mdd4soa.smm.data.Operation#getOperands()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Operands();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.data.Operation#getOperationType
	 * <em>Operation Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Operation Type</em>'.
	 * @see eu.mdd4soa.smm.data.Operation#getOperationType()
	 * @see #getOperation()
	 * @generated
	 */
	EAttribute getOperation_OperationType();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.data.LeftHandSideExpression
	 * <em>Left Hand Side Expression</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Left Hand Side Expression</em>'.
	 * @see eu.mdd4soa.smm.data.LeftHandSideExpression
	 * @generated
	 */
	EClass getLeftHandSideExpression();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.data.RightHandSideExpression
	 * <em>Right Hand Side Expression</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Right Hand Side Expression</em>'.
	 * @see eu.mdd4soa.smm.data.RightHandSideExpression
	 * @generated
	 */
	EClass getRightHandSideExpression();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.data.InteractionParameter
	 * <em>Interaction Parameter</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Interaction Parameter</em>'.
	 * @see eu.mdd4soa.smm.data.InteractionParameter
	 * @generated
	 */
	EClass getInteractionParameter();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.data.InteractionParameter#getOperationParameter
	 * <em>Operation Parameter</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the reference '<em>Operation Parameter</em>'.
	 * @see eu.mdd4soa.smm.data.InteractionParameter#getOperationParameter()
	 * @see #getInteractionParameter()
	 * @generated
	 */
	EReference getInteractionParameter_OperationParameter();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.data.ReceiveParameter <em>Receive Parameter</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Receive Parameter</em>'.
	 * @see eu.mdd4soa.smm.data.ReceiveParameter
	 * @generated
	 */
	EClass getReceiveParameter();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.data.ReceiveParameter#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '<em>Target</em>'.
	 * @see eu.mdd4soa.smm.data.ReceiveParameter#getTarget()
	 * @see #getReceiveParameter()
	 * @generated
	 */
	EReference getReceiveParameter_Target();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.data.SendParameter <em>Send Parameter</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Send Parameter</em>'.
	 * @see eu.mdd4soa.smm.data.SendParameter
	 * @generated
	 */
	EClass getSendParameter();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.data.SendParameter#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '<em>Source</em>'.
	 * @see eu.mdd4soa.smm.data.SendParameter#getSource()
	 * @see #getSendParameter()
	 * @generated
	 */
	EReference getSendParameter_Source();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.data.VariableReference <em>Variable Reference</em>}
	 * '. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Variable Reference</em>'.
	 * @see eu.mdd4soa.smm.data.VariableReference
	 * @generated
	 */
	EClass getVariableReference();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.data.VariableReference#getVariable
	 * <em>Variable</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Variable</em>'.
	 * @see eu.mdd4soa.smm.data.VariableReference#getVariable()
	 * @see #getVariableReference()
	 * @generated
	 */
	EReference getVariableReference_Variable();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.data.PropertyReference <em>Property Reference</em>}
	 * '. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Property Reference</em>'.
	 * @see eu.mdd4soa.smm.data.PropertyReference
	 * @generated
	 */
	EClass getPropertyReference();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.data.PropertyReference#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '<em>Parent</em>'.
	 * @see eu.mdd4soa.smm.data.PropertyReference#getParent()
	 * @see #getPropertyReference()
	 * @generated
	 */
	EReference getPropertyReference_Parent();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.data.PropertyReference#getProperty
	 * <em>Property</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Property</em>'.
	 * @see eu.mdd4soa.smm.data.PropertyReference#getProperty()
	 * @see #getPropertyReference()
	 * @generated
	 */
	EReference getPropertyReference_Property();

	/**
	 * Returns the meta object for enum '
	 * {@link eu.mdd4soa.smm.data.OperationType <em>Operation Type</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for enum '<em>Operation Type</em>'.
	 * @see eu.mdd4soa.smm.data.OperationType
	 * @generated
	 */
	EEnum getOperationType();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ISMDataFactory getISMDataFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.VariableImpl <em>Variable</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.VariableImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getVariable()
		 * @generated
		 */
		EClass VARIABLE= eINSTANCE.getVariable();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute VARIABLE__NAME= eINSTANCE.getVariable_Name();

		/**
		 * The meta object literal for the '<em><b>Service Activity</b></em>'
		 * container reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference VARIABLE__SERVICE_ACTIVITY= eINSTANCE.getVariable_ServiceActivity();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.ExpressionImpl <em>Expression</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.ExpressionImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getExpression()
		 * @generated
		 */
		EClass EXPRESSION= eINSTANCE.getExpression();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference EXPRESSION__TYPE= eINSTANCE.getExpression_Type();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.AssignmentImpl <em>Assignment</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.AssignmentImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getAssignment()
		 * @generated
		 */
		EClass ASSIGNMENT= eINSTANCE.getAssignment();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' containment
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference ASSIGNMENT__TARGET= eINSTANCE.getAssignment_Target();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' containment
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference ASSIGNMENT__SOURCE= eINSTANCE.getAssignment_Source();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.DeclarationImpl <em>Declaration</em>}
		 * ' class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.DeclarationImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getDeclaration()
		 * @generated
		 */
		EClass DECLARATION= eINSTANCE.getDeclaration();

		/**
		 * The meta object literal for the '<em><b>Declared Var</b></em>'
		 * containment reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference DECLARATION__DECLARED_VAR= eINSTANCE.getDeclaration_DeclaredVar();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.StatementImpl <em>Statement</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.StatementImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getStatement()
		 * @generated
		 */
		EClass STATEMENT= eINSTANCE.getStatement();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.LiteralImpl <em>Literal</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.LiteralImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getLiteral()
		 * @generated
		 */
		EClass LITERAL= eINSTANCE.getLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute LITERAL__VALUE= eINSTANCE.getLiteral_Value();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.OperationImpl <em>Operation</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.OperationImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getOperation()
		 * @generated
		 */
		EClass OPERATION= eINSTANCE.getOperation();

		/**
		 * The meta object literal for the '<em><b>Operands</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference OPERATION__OPERANDS= eINSTANCE.getOperation_Operands();

		/**
		 * The meta object literal for the '<em><b>Operation Type</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute OPERATION__OPERATION_TYPE= eINSTANCE.getOperation_OperationType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.LeftHandSideExpressionImpl
		 * <em>Left Hand Side Expression</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.LeftHandSideExpressionImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getLeftHandSideExpression()
		 * @generated
		 */
		EClass LEFT_HAND_SIDE_EXPRESSION= eINSTANCE.getLeftHandSideExpression();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.RightHandSideExpressionImpl
		 * <em>Right Hand Side Expression</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.RightHandSideExpressionImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getRightHandSideExpression()
		 * @generated
		 */
		EClass RIGHT_HAND_SIDE_EXPRESSION= eINSTANCE.getRightHandSideExpression();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.InteractionParameterImpl
		 * <em>Interaction Parameter</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.InteractionParameterImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getInteractionParameter()
		 * @generated
		 */
		EClass INTERACTION_PARAMETER= eINSTANCE.getInteractionParameter();

		/**
		 * The meta object literal for the '<em><b>Operation Parameter</b></em>'
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference INTERACTION_PARAMETER__OPERATION_PARAMETER= eINSTANCE.getInteractionParameter_OperationParameter();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.ReceiveParameterImpl
		 * <em>Receive Parameter</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.ReceiveParameterImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getReceiveParameter()
		 * @generated
		 */
		EClass RECEIVE_PARAMETER= eINSTANCE.getReceiveParameter();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' containment
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference RECEIVE_PARAMETER__TARGET= eINSTANCE.getReceiveParameter_Target();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.SendParameterImpl
		 * <em>Send Parameter</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.SendParameterImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getSendParameter()
		 * @generated
		 */
		EClass SEND_PARAMETER= eINSTANCE.getSendParameter();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' containment
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SEND_PARAMETER__SOURCE= eINSTANCE.getSendParameter_Source();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.VariableReferenceImpl
		 * <em>Variable Reference</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.VariableReferenceImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getVariableReference()
		 * @generated
		 */
		EClass VARIABLE_REFERENCE= eINSTANCE.getVariableReference();

		/**
		 * The meta object literal for the '<em><b>Variable</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference VARIABLE_REFERENCE__VARIABLE= eINSTANCE.getVariableReference_Variable();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.impl.PropertyReferenceImpl
		 * <em>Property Reference</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.impl.PropertyReferenceImpl
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getPropertyReference()
		 * @generated
		 */
		EClass PROPERTY_REFERENCE= eINSTANCE.getPropertyReference();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' containment
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PROPERTY_REFERENCE__PARENT= eINSTANCE.getPropertyReference_Parent();

		/**
		 * The meta object literal for the '<em><b>Property</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PROPERTY_REFERENCE__PROPERTY= eINSTANCE.getPropertyReference_Property();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.data.OperationType <em>Operation Type</em>}'
		 * enum. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.data.OperationType
		 * @see eu.mdd4soa.smm.data.impl.ISMDataPackageImpl#getOperationType()
		 * @generated
		 */
		EEnum OPERATION_TYPE= eINSTANCE.getOperationType();

	}

} // ISMDataPackage
