/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Operation</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.data.Operation#getOperands <em>Operands</em>}</li>
 * <li>{@link eu.mdd4soa.smm.data.Operation#getOperationType <em>Operation Type
 * </em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.data.ISMDataPackage#getOperation()
 * @model
 * @generated
 */
public interface Operation extends RightHandSideExpression {
	/**
	 * Returns the value of the '<em><b>Operands</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link eu.mdd4soa.smm.data.Expression}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operands</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Operands</em>' containment reference list.
	 * @see eu.mdd4soa.smm.data.ISMDataPackage#getOperation_Operands()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<Expression> getOperands();

	/**
	 * Returns the value of the '<em><b>Operation Type</b></em>' attribute. The
	 * literals are from the enumeration
	 * {@link eu.mdd4soa.smm.data.OperationType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operation Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Operation Type</em>' attribute.
	 * @see eu.mdd4soa.smm.data.OperationType
	 * @see #setOperationType(OperationType)
	 * @see eu.mdd4soa.smm.data.ISMDataPackage#getOperation_OperationType()
	 * @model
	 * @generated
	 */
	OperationType getOperationType();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.data.Operation#getOperationType
	 * <em>Operation Type</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Operation Type</em>' attribute.
	 * @see eu.mdd4soa.smm.data.OperationType
	 * @see #getOperationType()
	 * @generated
	 */
	void setOperationType(OperationType value);

} // Operation
