/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data;

import eu.mdd4soa.smm.statik.MessageProperty;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Property Reference</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.data.PropertyReference#getParent <em>Parent</em>}</li>
 * <li>{@link eu.mdd4soa.smm.data.PropertyReference#getProperty <em>Property
 * </em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.data.ISMDataPackage#getPropertyReference()
 * @model
 * @generated
 */
public interface PropertyReference extends LeftHandSideExpression {
	/**
	 * Returns the value of the '<em><b>Parent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' containment reference isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Parent</em>' containment reference.
	 * @see #setParent(LeftHandSideExpression)
	 * @see eu.mdd4soa.smm.data.ISMDataPackage#getPropertyReference_Parent()
	 * @model containment="true"
	 * @generated
	 */
	LeftHandSideExpression getParent();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.data.PropertyReference#getParent <em>Parent</em>}'
	 * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Parent</em>' containment
	 *        reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(LeftHandSideExpression value);

	/**
	 * Returns the value of the '<em><b>Property</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Property</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Property</em>' reference.
	 * @see #setProperty(MessageProperty)
	 * @see eu.mdd4soa.smm.data.ISMDataPackage#getPropertyReference_Property()
	 * @model
	 * @generated
	 */
	MessageProperty getProperty();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.data.PropertyReference#getProperty
	 * <em>Property</em>}' reference. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value the new value of the '<em>Property</em>' reference.
	 * @see #getProperty()
	 * @generated
	 */
	void setProperty(MessageProperty value);

} // PropertyReference
