/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data;

import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.statik.TypedMultiElement;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Variable</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.data.Variable#getServiceActivity <em>Service
 * Activity</em>}</li>
 * <li>{@link eu.mdd4soa.smm.data.Variable#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.data.ISMDataPackage#getVariable()
 * @model
 * @generated
 */
public interface Variable extends TypedMultiElement {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see eu.mdd4soa.smm.data.ISMDataPackage#getVariable_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link eu.mdd4soa.smm.data.Variable#getName
	 * <em>Name</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Service Activity</b></em>' container
	 * reference. It is bidirectional and its opposite is '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getVariables
	 * <em>Variables</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Service Activity</em>' container reference
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Service Activity</em>' container reference.
	 * @see #setServiceActivity(ServiceActivity)
	 * @see eu.mdd4soa.smm.data.ISMDataPackage#getVariable_ServiceActivity()
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity#getVariables
	 * @model opposite="variables" transient="false"
	 * @generated
	 */
	ServiceActivity getServiceActivity();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.data.Variable#getServiceActivity
	 * <em>Service Activity</em>}' container reference. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Service Activity</em>' container
	 *        reference.
	 * @see #getServiceActivity()
	 * @generated
	 */
	void setServiceActivity(ServiceActivity value);

} // Variable
