/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.mdd4soa.smm.data.Assignment;
import eu.mdd4soa.smm.data.ISMDataPackage;
import eu.mdd4soa.smm.data.LeftHandSideExpression;
import eu.mdd4soa.smm.data.RightHandSideExpression;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Assignment</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.data.impl.AssignmentImpl#getTarget <em>Target</em>}
 * </li>
 * <li>{@link eu.mdd4soa.smm.data.impl.AssignmentImpl#getSource <em>Source</em>}
 * </li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class AssignmentImpl extends StatementImpl implements Assignment {
	/**
	 * The cached value of the '{@link #getTarget() <em>Target</em>}'
	 * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getTarget()
	 * @generated
	 * @ordered
	 */
	protected LeftHandSideExpression target;

	/**
	 * The cached value of the '{@link #getSource() <em>Source</em>}'
	 * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getSource()
	 * @generated
	 * @ordered
	 */
	protected RightHandSideExpression source;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AssignmentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMDataPackage.Literals.ASSIGNMENT;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public LeftHandSideExpression getTarget() {
		return target;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetTarget(LeftHandSideExpression newTarget, NotificationChain msgs) {
		LeftHandSideExpression oldTarget= target;
		target= newTarget;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.SET, ISMDataPackage.ASSIGNMENT__TARGET, oldTarget, newTarget);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setTarget(LeftHandSideExpression newTarget) {
		if (newTarget != target) {
			NotificationChain msgs= null;
			if (target != null)
				msgs= ((InternalEObject) target).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ISMDataPackage.ASSIGNMENT__TARGET, null, msgs);
			if (newTarget != null)
				msgs= ((InternalEObject) newTarget).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ISMDataPackage.ASSIGNMENT__TARGET, null, msgs);
			msgs= basicSetTarget(newTarget, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMDataPackage.ASSIGNMENT__TARGET, newTarget, newTarget));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public RightHandSideExpression getSource() {
		return source;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetSource(RightHandSideExpression newSource, NotificationChain msgs) {
		RightHandSideExpression oldSource= source;
		source= newSource;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.SET, ISMDataPackage.ASSIGNMENT__SOURCE, oldSource, newSource);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setSource(RightHandSideExpression newSource) {
		if (newSource != source) {
			NotificationChain msgs= null;
			if (source != null)
				msgs= ((InternalEObject) source).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ISMDataPackage.ASSIGNMENT__SOURCE, null, msgs);
			if (newSource != null)
				msgs= ((InternalEObject) newSource).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ISMDataPackage.ASSIGNMENT__SOURCE, null, msgs);
			msgs= basicSetSource(newSource, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMDataPackage.ASSIGNMENT__SOURCE, newSource, newSource));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMDataPackage.ASSIGNMENT__TARGET:
				return basicSetTarget(null, msgs);
			case ISMDataPackage.ASSIGNMENT__SOURCE:
				return basicSetSource(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMDataPackage.ASSIGNMENT__TARGET:
				return getTarget();
			case ISMDataPackage.ASSIGNMENT__SOURCE:
				return getSource();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMDataPackage.ASSIGNMENT__TARGET:
				setTarget((LeftHandSideExpression) newValue);
				return;
			case ISMDataPackage.ASSIGNMENT__SOURCE:
				setSource((RightHandSideExpression) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMDataPackage.ASSIGNMENT__TARGET:
				setTarget((LeftHandSideExpression) null);
				return;
			case ISMDataPackage.ASSIGNMENT__SOURCE:
				setSource((RightHandSideExpression) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMDataPackage.ASSIGNMENT__TARGET:
				return target != null;
			case ISMDataPackage.ASSIGNMENT__SOURCE:
				return source != null;
		}
		return super.eIsSet(featureID);
	}

} // AssignmentImpl
