/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.impl.ISMBehaviourPackageImpl;
import eu.mdd4soa.smm.data.Assignment;
import eu.mdd4soa.smm.data.Declaration;
import eu.mdd4soa.smm.data.Expression;
import eu.mdd4soa.smm.data.ISMDataFactory;
import eu.mdd4soa.smm.data.ISMDataPackage;
import eu.mdd4soa.smm.data.InteractionParameter;
import eu.mdd4soa.smm.data.LeftHandSideExpression;
import eu.mdd4soa.smm.data.Literal;
import eu.mdd4soa.smm.data.Operation;
import eu.mdd4soa.smm.data.OperationType;
import eu.mdd4soa.smm.data.PropertyReference;
import eu.mdd4soa.smm.data.ReceiveParameter;
import eu.mdd4soa.smm.data.RightHandSideExpression;
import eu.mdd4soa.smm.data.SendParameter;
import eu.mdd4soa.smm.data.Statement;
import eu.mdd4soa.smm.data.Variable;
import eu.mdd4soa.smm.data.VariableReference;
import eu.mdd4soa.smm.statik.ISMStatikPackage;
import eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class ISMDataPackageImpl extends EPackageImpl implements ISMDataPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass variableEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass expressionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass assignmentEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass declarationEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass statementEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass literalEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass operationEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass leftHandSideExpressionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rightHandSideExpressionEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass interactionParameterEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass receiveParameterEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass sendParameterEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass variableReferenceEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass propertyReferenceEClass= null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum operationTypeEEnum= null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see eu.mdd4soa.smm.data.ISMDataPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ISMDataPackageImpl() {
		super(eNS_URI, ISMDataFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static boolean isInited= false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link ISMDataPackage#eINSTANCE} when
	 * that field is accessed. Clients should not invoke it directly. Instead,
	 * they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ISMDataPackage init() {
		if (isInited)
			return (ISMDataPackage) EPackage.Registry.INSTANCE.getEPackage(ISMDataPackage.eNS_URI);

		// Obtain or create and register package
		ISMDataPackageImpl theISMDataPackage= (ISMDataPackageImpl) (EPackage.Registry.INSTANCE.get(eNS_URI) instanceof ISMDataPackageImpl
				? EPackage.Registry.INSTANCE.get(eNS_URI)
				: new ISMDataPackageImpl());

		isInited= true;

		// Obtain or create and register interdependencies
		ISMBehaviourPackageImpl theISMBehaviourPackage= (ISMBehaviourPackageImpl) (EPackage.Registry.INSTANCE
				.getEPackage(ISMBehaviourPackage.eNS_URI) instanceof ISMBehaviourPackageImpl ? EPackage.Registry.INSTANCE
				.getEPackage(ISMBehaviourPackage.eNS_URI) : ISMBehaviourPackage.eINSTANCE);
		ISMStatikPackageImpl theISMStatikPackage= (ISMStatikPackageImpl) (EPackage.Registry.INSTANCE.getEPackage(ISMStatikPackage.eNS_URI) instanceof ISMStatikPackageImpl
				? EPackage.Registry.INSTANCE.getEPackage(ISMStatikPackage.eNS_URI)
				: ISMStatikPackage.eINSTANCE);

		// Create package meta-data objects
		theISMDataPackage.createPackageContents();
		theISMBehaviourPackage.createPackageContents();
		theISMStatikPackage.createPackageContents();

		// Initialize created meta-data
		theISMDataPackage.initializePackageContents();
		theISMBehaviourPackage.initializePackageContents();
		theISMStatikPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theISMDataPackage.freeze();


		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ISMDataPackage.eNS_URI, theISMDataPackage);
		return theISMDataPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getVariable() {
		return variableEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getVariable_Name() {
		return (EAttribute) variableEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getVariable_ServiceActivity() {
		return (EReference) variableEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getExpression() {
		return expressionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getExpression_Type() {
		return (EReference) expressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getAssignment() {
		return assignmentEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getAssignment_Target() {
		return (EReference) assignmentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getAssignment_Source() {
		return (EReference) assignmentEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getDeclaration() {
		return declarationEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getDeclaration_DeclaredVar() {
		return (EReference) declarationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getStatement() {
		return statementEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getLiteral() {
		return literalEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getLiteral_Value() {
		return (EAttribute) literalEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getOperation() {
		return operationEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getOperation_Operands() {
		return (EReference) operationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getOperation_OperationType() {
		return (EAttribute) operationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getLeftHandSideExpression() {
		return leftHandSideExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getRightHandSideExpression() {
		return rightHandSideExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getInteractionParameter() {
		return interactionParameterEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getInteractionParameter_OperationParameter() {
		return (EReference) interactionParameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getReceiveParameter() {
		return receiveParameterEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getReceiveParameter_Target() {
		return (EReference) receiveParameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getSendParameter() {
		return sendParameterEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getSendParameter_Source() {
		return (EReference) sendParameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getVariableReference() {
		return variableReferenceEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getVariableReference_Variable() {
		return (EReference) variableReferenceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getPropertyReference() {
		return propertyReferenceEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getPropertyReference_Parent() {
		return (EReference) propertyReferenceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getPropertyReference_Property() {
		return (EReference) propertyReferenceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EEnum getOperationType() {
		return operationTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMDataFactory getISMDataFactory() {
		return (ISMDataFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isCreated= false;

	/**
	 * Creates the meta-model objects for the package. This method is guarded to
	 * have no affect on any invocation but its first. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated)
			return;
		isCreated= true;

		// Create classes and their features
		variableEClass= createEClass(VARIABLE);
		createEReference(variableEClass, VARIABLE__SERVICE_ACTIVITY);
		createEAttribute(variableEClass, VARIABLE__NAME);

		expressionEClass= createEClass(EXPRESSION);
		createEReference(expressionEClass, EXPRESSION__TYPE);

		assignmentEClass= createEClass(ASSIGNMENT);
		createEReference(assignmentEClass, ASSIGNMENT__TARGET);
		createEReference(assignmentEClass, ASSIGNMENT__SOURCE);

		declarationEClass= createEClass(DECLARATION);
		createEReference(declarationEClass, DECLARATION__DECLARED_VAR);

		statementEClass= createEClass(STATEMENT);

		literalEClass= createEClass(LITERAL);
		createEAttribute(literalEClass, LITERAL__VALUE);

		operationEClass= createEClass(OPERATION);
		createEReference(operationEClass, OPERATION__OPERANDS);
		createEAttribute(operationEClass, OPERATION__OPERATION_TYPE);

		leftHandSideExpressionEClass= createEClass(LEFT_HAND_SIDE_EXPRESSION);

		rightHandSideExpressionEClass= createEClass(RIGHT_HAND_SIDE_EXPRESSION);

		interactionParameterEClass= createEClass(INTERACTION_PARAMETER);
		createEReference(interactionParameterEClass, INTERACTION_PARAMETER__OPERATION_PARAMETER);

		receiveParameterEClass= createEClass(RECEIVE_PARAMETER);
		createEReference(receiveParameterEClass, RECEIVE_PARAMETER__TARGET);

		sendParameterEClass= createEClass(SEND_PARAMETER);
		createEReference(sendParameterEClass, SEND_PARAMETER__SOURCE);

		variableReferenceEClass= createEClass(VARIABLE_REFERENCE);
		createEReference(variableReferenceEClass, VARIABLE_REFERENCE__VARIABLE);

		propertyReferenceEClass= createEClass(PROPERTY_REFERENCE);
		createEReference(propertyReferenceEClass, PROPERTY_REFERENCE__PARENT);
		createEReference(propertyReferenceEClass, PROPERTY_REFERENCE__PROPERTY);

		// Create enums
		operationTypeEEnum= createEEnum(OPERATION_TYPE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isInitialized= false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized)
			return;
		isInitialized= true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		ISMStatikPackage theISMStatikPackage= (ISMStatikPackage) EPackage.Registry.INSTANCE.getEPackage(ISMStatikPackage.eNS_URI);
		ISMBehaviourPackage theISMBehaviourPackage= (ISMBehaviourPackage) EPackage.Registry.INSTANCE.getEPackage(ISMBehaviourPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		variableEClass.getESuperTypes().add(theISMStatikPackage.getTypedMultiElement());
		assignmentEClass.getESuperTypes().add(this.getStatement());
		declarationEClass.getESuperTypes().add(this.getStatement());
		literalEClass.getESuperTypes().add(this.getRightHandSideExpression());
		operationEClass.getESuperTypes().add(this.getRightHandSideExpression());
		leftHandSideExpressionEClass.getESuperTypes().add(this.getRightHandSideExpression());
		rightHandSideExpressionEClass.getESuperTypes().add(this.getExpression());
		receiveParameterEClass.getESuperTypes().add(this.getInteractionParameter());
		sendParameterEClass.getESuperTypes().add(this.getInteractionParameter());
		variableReferenceEClass.getESuperTypes().add(this.getLeftHandSideExpression());
		propertyReferenceEClass.getESuperTypes().add(this.getLeftHandSideExpression());

		// Initialize classes and features; add operations and parameters
		initEClass(variableEClass, Variable.class, "Variable", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVariable_ServiceActivity(), theISMBehaviourPackage.getServiceActivity(),
				theISMBehaviourPackage.getServiceActivity_Variables(), "serviceActivity", null, 0, 1, Variable.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getVariable_Name(), ecorePackage.getEString(), "name", null, 0, 1, Variable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(expressionEClass, Expression.class, "Expression", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExpression_Type(), theISMStatikPackage.getSMMType(), null, "type", null, 0, 1, Expression.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(assignmentEClass, Assignment.class, "Assignment", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAssignment_Target(), this.getLeftHandSideExpression(), null, "target", null, 1, 1, Assignment.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAssignment_Source(), this.getRightHandSideExpression(), null, "source", null, 1, 1, Assignment.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(declarationEClass, Declaration.class, "Declaration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDeclaration_DeclaredVar(), this.getVariableReference(), null, "declaredVar", null, 1, 1, Declaration.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(statementEClass, Statement.class, "Statement", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(literalEClass, Literal.class, "Literal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLiteral_Value(), ecorePackage.getEJavaObject(), "value", null, 0, 1, Literal.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(operationEClass, Operation.class, "Operation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOperation_Operands(), this.getExpression(), null, "operands", null, 1, -1, Operation.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOperation_OperationType(), this.getOperationType(), "operationType", null, 0, 1, Operation.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(leftHandSideExpressionEClass, LeftHandSideExpression.class, "LeftHandSideExpression", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(rightHandSideExpressionEClass, RightHandSideExpression.class, "RightHandSideExpression", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(interactionParameterEClass, InteractionParameter.class, "InteractionParameter", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getInteractionParameter_OperationParameter(), theISMStatikPackage.getInterfaceParameter(), null, "operationParameter", null,
				1, 1, InteractionParameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(receiveParameterEClass, ReceiveParameter.class, "ReceiveParameter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getReceiveParameter_Target(), this.getLeftHandSideExpression(), null, "target", null, 0, 1, ReceiveParameter.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(sendParameterEClass, SendParameter.class, "SendParameter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSendParameter_Source(), this.getRightHandSideExpression(), null, "source", null, 0, 1, SendParameter.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(variableReferenceEClass, VariableReference.class, "VariableReference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVariableReference_Variable(), this.getVariable(), null, "variable", null, 0, 1, VariableReference.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(propertyReferenceEClass, PropertyReference.class, "PropertyReference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPropertyReference_Parent(), this.getLeftHandSideExpression(), null, "parent", null, 0, 1, PropertyReference.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPropertyReference_Property(), theISMStatikPackage.getMessageProperty(), null, "property", null, 0, 1,
				PropertyReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(operationTypeEEnum, OperationType.class, "OperationType");
		addEEnumLiteral(operationTypeEEnum, OperationType.ADDITION);
		addEEnumLiteral(operationTypeEEnum, OperationType.SUBTRACTION);
		addEEnumLiteral(operationTypeEEnum, OperationType.MULTIPLICATION);
		addEEnumLiteral(operationTypeEEnum, OperationType.DIVISION);
		addEEnumLiteral(operationTypeEEnum, OperationType.MODULO);
		addEEnumLiteral(operationTypeEEnum, OperationType.NEGATION);
		addEEnumLiteral(operationTypeEEnum, OperationType.AND);
		addEEnumLiteral(operationTypeEEnum, OperationType.OR);
		addEEnumLiteral(operationTypeEEnum, OperationType.NOT);
		addEEnumLiteral(operationTypeEEnum, OperationType.EQUALS);
		addEEnumLiteral(operationTypeEEnum, OperationType.GREATER);
		addEEnumLiteral(operationTypeEEnum, OperationType.GREATER_EQUAL);
		addEEnumLiteral(operationTypeEEnum, OperationType.LESS);
		addEEnumLiteral(operationTypeEEnum, OperationType.LESS_EQUAL);
		addEEnumLiteral(operationTypeEEnum, OperationType.NOT_EQUALS);

		// Create resource
		createResource(eNS_URI);
	}

} // ISMDataPackageImpl
