/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.mdd4soa.smm.data.Expression;
import eu.mdd4soa.smm.data.ISMDataPackage;
import eu.mdd4soa.smm.data.Operation;
import eu.mdd4soa.smm.data.OperationType;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Operation</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.data.impl.OperationImpl#getOperands <em>Operands
 * </em>}</li>
 * <li>{@link eu.mdd4soa.smm.data.impl.OperationImpl#getOperationType <em>
 * Operation Type</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class OperationImpl extends RightHandSideExpressionImpl implements Operation {
	/**
	 * The cached value of the '{@link #getOperands() <em>Operands</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getOperands()
	 * @generated
	 * @ordered
	 */
	protected EList<Expression> operands;

	/**
	 * The default value of the '{@link #getOperationType()
	 * <em>Operation Type</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getOperationType()
	 * @generated
	 * @ordered
	 */
	protected static final OperationType OPERATION_TYPE_EDEFAULT= OperationType.ADDITION;

	/**
	 * The cached value of the '{@link #getOperationType()
	 * <em>Operation Type</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getOperationType()
	 * @generated
	 * @ordered
	 */
	protected OperationType operationType= OPERATION_TYPE_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected OperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMDataPackage.Literals.OPERATION;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<Expression> getOperands() {
		if (operands == null) {
			operands= new EObjectContainmentEList<Expression>(Expression.class, this, ISMDataPackage.OPERATION__OPERANDS);
		}
		return operands;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public OperationType getOperationType() {
		return operationType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setOperationType(OperationType newOperationType) {
		OperationType oldOperationType= operationType;
		operationType= newOperationType == null ? OPERATION_TYPE_EDEFAULT : newOperationType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMDataPackage.OPERATION__OPERATION_TYPE, oldOperationType, operationType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMDataPackage.OPERATION__OPERANDS:
				return ((InternalEList<?>) getOperands()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMDataPackage.OPERATION__OPERANDS:
				return getOperands();
			case ISMDataPackage.OPERATION__OPERATION_TYPE:
				return getOperationType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMDataPackage.OPERATION__OPERANDS:
				getOperands().clear();
				getOperands().addAll((Collection<? extends Expression>) newValue);
				return;
			case ISMDataPackage.OPERATION__OPERATION_TYPE:
				setOperationType((OperationType) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMDataPackage.OPERATION__OPERANDS:
				getOperands().clear();
				return;
			case ISMDataPackage.OPERATION__OPERATION_TYPE:
				setOperationType(OPERATION_TYPE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMDataPackage.OPERATION__OPERANDS:
				return operands != null && !operands.isEmpty();
			case ISMDataPackage.OPERATION__OPERATION_TYPE:
				return operationType != OPERATION_TYPE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer(super.toString());
		result.append(" (operationType: ");
		result.append(operationType);
		result.append(')');
		return result.toString();
	}

} // OperationImpl
