/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.mdd4soa.smm.data.ISMDataPackage;
import eu.mdd4soa.smm.data.LeftHandSideExpression;
import eu.mdd4soa.smm.data.PropertyReference;
import eu.mdd4soa.smm.statik.MessageProperty;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Property Reference</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.data.impl.PropertyReferenceImpl#getParent <em>
 * Parent</em>}</li>
 * <li>{@link eu.mdd4soa.smm.data.impl.PropertyReferenceImpl#getProperty <em>
 * Property</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class PropertyReferenceImpl extends LeftHandSideExpressionImpl implements PropertyReference {
	/**
	 * The cached value of the '{@link #getParent() <em>Parent</em>}'
	 * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getParent()
	 * @generated
	 * @ordered
	 */
	protected LeftHandSideExpression parent;

	/**
	 * The cached value of the '{@link #getProperty() <em>Property</em>}'
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getProperty()
	 * @generated
	 * @ordered
	 */
	protected MessageProperty property;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PropertyReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMDataPackage.Literals.PROPERTY_REFERENCE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public LeftHandSideExpression getParent() {
		return parent;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetParent(LeftHandSideExpression newParent, NotificationChain msgs) {
		LeftHandSideExpression oldParent= parent;
		parent= newParent;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.SET, ISMDataPackage.PROPERTY_REFERENCE__PARENT, oldParent,
					newParent);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParent(LeftHandSideExpression newParent) {
		if (newParent != parent) {
			NotificationChain msgs= null;
			if (parent != null)
				msgs= ((InternalEObject) parent).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ISMDataPackage.PROPERTY_REFERENCE__PARENT, null, msgs);
			if (newParent != null)
				msgs= ((InternalEObject) newParent).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ISMDataPackage.PROPERTY_REFERENCE__PARENT, null, msgs);
			msgs= basicSetParent(newParent, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMDataPackage.PROPERTY_REFERENCE__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MessageProperty getProperty() {
		if (property != null && property.eIsProxy()) {
			InternalEObject oldProperty= (InternalEObject) property;
			property= (MessageProperty) eResolveProxy(oldProperty);
			if (property != oldProperty) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ISMDataPackage.PROPERTY_REFERENCE__PROPERTY, oldProperty, property));
			}
		}
		return property;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MessageProperty basicGetProperty() {
		return property;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setProperty(MessageProperty newProperty) {
		MessageProperty oldProperty= property;
		property= newProperty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMDataPackage.PROPERTY_REFERENCE__PROPERTY, oldProperty, property));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMDataPackage.PROPERTY_REFERENCE__PARENT:
				return basicSetParent(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMDataPackage.PROPERTY_REFERENCE__PARENT:
				return getParent();
			case ISMDataPackage.PROPERTY_REFERENCE__PROPERTY:
				if (resolve)
					return getProperty();
				return basicGetProperty();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMDataPackage.PROPERTY_REFERENCE__PARENT:
				setParent((LeftHandSideExpression) newValue);
				return;
			case ISMDataPackage.PROPERTY_REFERENCE__PROPERTY:
				setProperty((MessageProperty) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMDataPackage.PROPERTY_REFERENCE__PARENT:
				setParent((LeftHandSideExpression) null);
				return;
			case ISMDataPackage.PROPERTY_REFERENCE__PROPERTY:
				setProperty((MessageProperty) null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMDataPackage.PROPERTY_REFERENCE__PARENT:
				return parent != null;
			case ISMDataPackage.PROPERTY_REFERENCE__PROPERTY:
				return property != null;
		}
		return super.eIsSet(featureID);
	}

} // PropertyReferenceImpl
