/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.data.ISMDataPackage;
import eu.mdd4soa.smm.data.Variable;
import eu.mdd4soa.smm.statik.impl.TypedMultiElementImpl;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Variable</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.data.impl.VariableImpl#getServiceActivity <em>
 * Service Activity</em>}</li>
 * <li>{@link eu.mdd4soa.smm.data.impl.VariableImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class VariableImpl extends TypedMultiElementImpl implements Variable {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT= null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name= NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected VariableImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMDataPackage.Literals.VARIABLE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setName(String newName) {
		String oldName= name;
		name= newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMDataPackage.VARIABLE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ServiceActivity getServiceActivity() {
		if (eContainerFeatureID() != ISMDataPackage.VARIABLE__SERVICE_ACTIVITY)
			return null;
		return (ServiceActivity) eContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetServiceActivity(ServiceActivity newServiceActivity, NotificationChain msgs) {
		msgs= eBasicSetContainer((InternalEObject) newServiceActivity, ISMDataPackage.VARIABLE__SERVICE_ACTIVITY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setServiceActivity(ServiceActivity newServiceActivity) {
		if (newServiceActivity != eInternalContainer()
				|| (eContainerFeatureID() != ISMDataPackage.VARIABLE__SERVICE_ACTIVITY && newServiceActivity != null)) {
			if (EcoreUtil.isAncestor(this, newServiceActivity))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs= null;
			if (eInternalContainer() != null)
				msgs= eBasicRemoveFromContainer(msgs);
			if (newServiceActivity != null)
				msgs= ((InternalEObject) newServiceActivity).eInverseAdd(this, ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES,
						ServiceActivity.class, msgs);
			msgs= basicSetServiceActivity(newServiceActivity, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMDataPackage.VARIABLE__SERVICE_ACTIVITY, newServiceActivity, newServiceActivity));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMDataPackage.VARIABLE__SERVICE_ACTIVITY:
				if (eInternalContainer() != null)
					msgs= eBasicRemoveFromContainer(msgs);
				return basicSetServiceActivity((ServiceActivity) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMDataPackage.VARIABLE__SERVICE_ACTIVITY:
				return basicSetServiceActivity(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ISMDataPackage.VARIABLE__SERVICE_ACTIVITY:
				return eInternalContainer().eInverseRemove(this, ISMBehaviourPackage.SERVICE_ACTIVITY__VARIABLES, ServiceActivity.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMDataPackage.VARIABLE__SERVICE_ACTIVITY:
				return getServiceActivity();
			case ISMDataPackage.VARIABLE__NAME:
				return getName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMDataPackage.VARIABLE__SERVICE_ACTIVITY:
				setServiceActivity((ServiceActivity) newValue);
				return;
			case ISMDataPackage.VARIABLE__NAME:
				setName((String) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMDataPackage.VARIABLE__SERVICE_ACTIVITY:
				setServiceActivity((ServiceActivity) null);
				return;
			case ISMDataPackage.VARIABLE__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMDataPackage.VARIABLE__SERVICE_ACTIVITY:
				return getServiceActivity() != null;
			case ISMDataPackage.VARIABLE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} // VariableImpl
