/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.data.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import eu.mdd4soa.smm.data.Assignment;
import eu.mdd4soa.smm.data.Declaration;
import eu.mdd4soa.smm.data.Expression;
import eu.mdd4soa.smm.data.ISMDataPackage;
import eu.mdd4soa.smm.data.InteractionParameter;
import eu.mdd4soa.smm.data.LeftHandSideExpression;
import eu.mdd4soa.smm.data.Literal;
import eu.mdd4soa.smm.data.Operation;
import eu.mdd4soa.smm.data.PropertyReference;
import eu.mdd4soa.smm.data.ReceiveParameter;
import eu.mdd4soa.smm.data.RightHandSideExpression;
import eu.mdd4soa.smm.data.SendParameter;
import eu.mdd4soa.smm.data.Statement;
import eu.mdd4soa.smm.data.Variable;
import eu.mdd4soa.smm.data.VariableReference;
import eu.mdd4soa.smm.statik.TypedMultiElement;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * 
 * @see eu.mdd4soa.smm.data.ISMDataPackage
 * @generated
 */
public class ISMDataSwitch<T> {
	/**
	 * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static ISMDataPackage modelPackage;

	/**
	 * Creates an instance of the switch. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMDataSwitch() {
		if (modelPackage == null) {
			modelPackage= ISMDataPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		} else {
			List<EClass> eSuperTypes= theEClass.getESuperTypes();
			return eSuperTypes.isEmpty() ? defaultCase(theEObject) : doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case ISMDataPackage.VARIABLE: {
				Variable variable= (Variable) theEObject;
				T result= caseVariable(variable);
				if (result == null)
					result= caseTypedMultiElement(variable);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.EXPRESSION: {
				Expression expression= (Expression) theEObject;
				T result= caseExpression(expression);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.ASSIGNMENT: {
				Assignment assignment= (Assignment) theEObject;
				T result= caseAssignment(assignment);
				if (result == null)
					result= caseStatement(assignment);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.DECLARATION: {
				Declaration declaration= (Declaration) theEObject;
				T result= caseDeclaration(declaration);
				if (result == null)
					result= caseStatement(declaration);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.STATEMENT: {
				Statement statement= (Statement) theEObject;
				T result= caseStatement(statement);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.LITERAL: {
				Literal literal= (Literal) theEObject;
				T result= caseLiteral(literal);
				if (result == null)
					result= caseRightHandSideExpression(literal);
				if (result == null)
					result= caseExpression(literal);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.OPERATION: {
				Operation operation= (Operation) theEObject;
				T result= caseOperation(operation);
				if (result == null)
					result= caseRightHandSideExpression(operation);
				if (result == null)
					result= caseExpression(operation);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.LEFT_HAND_SIDE_EXPRESSION: {
				LeftHandSideExpression leftHandSideExpression= (LeftHandSideExpression) theEObject;
				T result= caseLeftHandSideExpression(leftHandSideExpression);
				if (result == null)
					result= caseRightHandSideExpression(leftHandSideExpression);
				if (result == null)
					result= caseExpression(leftHandSideExpression);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.RIGHT_HAND_SIDE_EXPRESSION: {
				RightHandSideExpression rightHandSideExpression= (RightHandSideExpression) theEObject;
				T result= caseRightHandSideExpression(rightHandSideExpression);
				if (result == null)
					result= caseExpression(rightHandSideExpression);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.INTERACTION_PARAMETER: {
				InteractionParameter interactionParameter= (InteractionParameter) theEObject;
				T result= caseInteractionParameter(interactionParameter);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.RECEIVE_PARAMETER: {
				ReceiveParameter receiveParameter= (ReceiveParameter) theEObject;
				T result= caseReceiveParameter(receiveParameter);
				if (result == null)
					result= caseInteractionParameter(receiveParameter);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.SEND_PARAMETER: {
				SendParameter sendParameter= (SendParameter) theEObject;
				T result= caseSendParameter(sendParameter);
				if (result == null)
					result= caseInteractionParameter(sendParameter);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.VARIABLE_REFERENCE: {
				VariableReference variableReference= (VariableReference) theEObject;
				T result= caseVariableReference(variableReference);
				if (result == null)
					result= caseLeftHandSideExpression(variableReference);
				if (result == null)
					result= caseRightHandSideExpression(variableReference);
				if (result == null)
					result= caseExpression(variableReference);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMDataPackage.PROPERTY_REFERENCE: {
				PropertyReference propertyReference= (PropertyReference) theEObject;
				T result= casePropertyReference(propertyReference);
				if (result == null)
					result= caseLeftHandSideExpression(propertyReference);
				if (result == null)
					result= caseRightHandSideExpression(propertyReference);
				if (result == null)
					result= caseExpression(propertyReference);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			default:
				return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Variable</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariable(Variable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Expression</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpression(Expression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Assignment</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssignment(Assignment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Declaration</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeclaration(Declaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Statement</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStatement(Statement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Literal</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLiteral(Literal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Operation</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOperation(Operation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Left Hand Side Expression</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Left Hand Side Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLeftHandSideExpression(LeftHandSideExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Right Hand Side Expression</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Right Hand Side Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRightHandSideExpression(RightHandSideExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Interaction Parameter</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Interaction Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInteractionParameter(InteractionParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Receive Parameter</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Receive Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReceiveParameter(ReceiveParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Send Parameter</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Send Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSendParameter(SendParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Variable Reference</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Variable Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariableReference(VariableReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Property Reference</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Property Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertyReference(PropertyReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Typed Multi Element</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Typed Multi Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypedMultiElement(TypedMultiElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>EObject</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch, but this is
	 * the last case anyway. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} // ISMDataSwitch
